/*
 * Decompiled with CFR 0.152.
 */
package thut.essentials.commands.land.management;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import net.minecraft.command.CommandSource;
import net.minecraft.command.Commands;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraftforge.server.permission.DefaultPermissionLevel;
import net.minecraftforge.server.permission.PermissionAPI;
import thut.essentials.Essentials;
import thut.essentials.commands.CommandManager;
import thut.essentials.commands.land.management.Edit;
import thut.essentials.land.LandManager;

public class Delete {
    public static void register(CommandDispatcher<CommandSource> commandDispatcher) {
        String name = "delete_team";
        if (!Essentials.config.commandBlacklist.contains("delete_team")) {
            String perm = "command.delete_team";
            PermissionAPI.registerNode((String)"command.delete_team", (DefaultPermissionLevel)DefaultPermissionLevel.ALL, (String)"Can the player use /delete_team");
            LiteralArgumentBuilder command = (LiteralArgumentBuilder)Commands.func_197057_a((String)"delete_team").requires(cs -> Edit.adminUse(cs, perm));
            command = (LiteralArgumentBuilder)command.executes(ctx -> Delete.execute((CommandSource)ctx.getSource()));
            commandDispatcher.register(command);
        }
    }

    private static int execute(CommandSource source) throws CommandSyntaxException {
        ServerPlayerEntity player = source.func_197035_h();
        LandManager.LandTeam team = LandManager.getTeam((Entity)player);
        if (team == null || team == LandManager.getDefaultTeam()) {
            source.func_197021_a(CommandManager.makeFormattedComponent("thutessentials.team.notinateam"));
            return 1;
        }
        LandManager.getInstance().removeTeam(team.teamName);
        Essentials.config.sendFeedback(source, "thutessentials.team.delete.done", false, new Object[0]);
        return 0;
    }
}

