/*
 * Decompiled with CFR 0.152.
 */
package thut.essentials.commands.land.management;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import net.minecraft.command.CommandSource;
import net.minecraft.command.Commands;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.server.MinecraftServer;
import net.minecraftforge.server.permission.DefaultPermissionLevel;
import net.minecraftforge.server.permission.PermissionAPI;
import thut.essentials.Essentials;
import thut.essentials.commands.CommandManager;
import thut.essentials.land.LandManager;
import thut.essentials.land.LandSaveHandler;
import thut.essentials.util.Coordinate;
import thut.essentials.util.RuleManager;

public class Edit {
    private static final String PERMRESERVELAND = "thutessentials.land.toggle.reserve";
    private static final String PERMTOGGLEMOBS = "thutessentials.land.toggle.mobspawn";
    private static final String PERMTOGGLEEXPLODE = "thutessentials.land.toggle.explode";
    private static final String PERMTOGGLEFF = "thutessentials.land.toggle.friendlyfire";
    private static final String PERMTOGGLEPLAYERDAMAGE = "thutessentials.land.toggle.playerdamage";
    private static final String PERMTOGGLENPCDAMAGE = "thutessentials.land.toggle.npcdamage";
    private static final String PERMTOGGLEFAKEPLAYERS = "thutessentials.land.toggle.fakeplayers";

    public static boolean adminUse(CommandSource source, String perm) {
        if (perm != null && !CommandManager.hasPerm(source, perm)) {
            return false;
        }
        try {
            ServerPlayerEntity player = source.func_197035_h();
            LandManager.LandTeam landTeam = LandManager.getTeam((Entity)player);
            return landTeam.isAdmin((Entity)player);
        }
        catch (CommandSyntaxException e) {
            return false;
        }
    }

    public static boolean permUse(CommandSource source, String perm) {
        try {
            ServerPlayerEntity player = source.func_197035_h();
            LandManager.LandTeam landTeam = LandManager.getTeam((Entity)player);
            return landTeam.hasRankPerm(player.func_110124_au(), perm);
        }
        catch (CommandSyntaxException e) {
            return false;
        }
    }

    public static void register(CommandDispatcher<CommandSource> commandDispatcher) {
        PermissionAPI.registerNode((String)PERMTOGGLEEXPLODE, (DefaultPermissionLevel)DefaultPermissionLevel.OP, (String)"Allowed to toggle explosions on/off in their team land");
        PermissionAPI.registerNode((String)PERMTOGGLEMOBS, (DefaultPermissionLevel)DefaultPermissionLevel.OP, (String)"Allowed to toggle mob spawns on/off in their team land");
        PermissionAPI.registerNode((String)PERMRESERVELAND, (DefaultPermissionLevel)DefaultPermissionLevel.OP, (String)"Allowed to toggle reserved status on/off for their team");
        PermissionAPI.registerNode((String)PERMTOGGLEFF, (DefaultPermissionLevel)DefaultPermissionLevel.OP, (String)"Allowed to toggle friendly fire on/off for their team");
        PermissionAPI.registerNode((String)PERMTOGGLEPLAYERDAMAGE, (DefaultPermissionLevel)DefaultPermissionLevel.OP, (String)"Allowed to toggle player damage on/off in their team land");
        PermissionAPI.registerNode((String)PERMTOGGLENPCDAMAGE, (DefaultPermissionLevel)DefaultPermissionLevel.ALL, (String)"Allowed to toggle npc damage on/off in their team land");
        PermissionAPI.registerNode((String)PERMTOGGLEFAKEPLAYERS, (DefaultPermissionLevel)DefaultPermissionLevel.ALL, (String)"Allowed to toggle whether fakeplayers are ignored for land stuff.");
        String name = "edit_team";
        if (Essentials.config.commandBlacklist.contains("edit_team")) {
            return;
        }
        String perm = "command.edit_team";
        PermissionAPI.registerNode((String)"command.edit_team", (DefaultPermissionLevel)DefaultPermissionLevel.ALL, (String)"Can the player use /edit_team");
        LiteralArgumentBuilder base = (LiteralArgumentBuilder)Commands.func_197057_a((String)"edit_team").requires(cs -> CommandManager.hasPerm(cs, perm));
        LiteralArgumentBuilder command = (LiteralArgumentBuilder)base.then(((LiteralArgumentBuilder)Commands.func_197057_a((String)"public").requires(cs -> Edit.adminUse(cs, null))).executes(ctx -> Edit.toggle_public((CommandSource)ctx.getSource())));
        commandDispatcher.register(command);
        command = (LiteralArgumentBuilder)base.then(((LiteralArgumentBuilder)Commands.func_197057_a((String)"any_place").requires(cs -> Edit.adminUse(cs, null))).executes(ctx -> Edit.toggle_any_place((CommandSource)ctx.getSource())));
        commandDispatcher.register(command);
        command = (LiteralArgumentBuilder)base.then(((LiteralArgumentBuilder)Commands.func_197057_a((String)"frames").requires(cs -> Edit.adminUse(cs, null))).executes(ctx -> Edit.toggle_frames((CommandSource)ctx.getSource())));
        commandDispatcher.register(command);
        command = (LiteralArgumentBuilder)base.then(((LiteralArgumentBuilder)Commands.func_197057_a((String)"fake_players").requires(cs -> Edit.adminUse(cs, PERMTOGGLEFAKEPLAYERS))).executes(ctx -> Edit.toggle_fake_players((CommandSource)ctx.getSource())));
        commandDispatcher.register(command);
        command = (LiteralArgumentBuilder)base.then(((LiteralArgumentBuilder)Commands.func_197057_a((String)"any_break").requires(cs -> Edit.adminUse(cs, null))).executes(ctx -> Edit.toggle_any_break((CommandSource)ctx.getSource())));
        commandDispatcher.register(command);
        command = (LiteralArgumentBuilder)base.then(((LiteralArgumentBuilder)Commands.func_197057_a((String)"reserve").requires(cs -> Edit.adminUse(cs, PERMRESERVELAND))).executes(ctx -> Edit.toggle_reserve((CommandSource)ctx.getSource())));
        commandDispatcher.register(command);
        command = (LiteralArgumentBuilder)base.then(((LiteralArgumentBuilder)Commands.func_197057_a((String)"no_player_damage").requires(cs -> Edit.adminUse(cs, PERMTOGGLEPLAYERDAMAGE))).executes(ctx -> Edit.toggle_no_player_damage((CommandSource)ctx.getSource())));
        commandDispatcher.register(command);
        command = (LiteralArgumentBuilder)base.then(((LiteralArgumentBuilder)Commands.func_197057_a((String)"no_npc_damage").requires(cs -> Edit.adminUse(cs, PERMTOGGLENPCDAMAGE))).executes(ctx -> Edit.toggle_no_npc_damage((CommandSource)ctx.getSource())));
        commandDispatcher.register(command);
        command = (LiteralArgumentBuilder)base.then(((LiteralArgumentBuilder)Commands.func_197057_a((String)"friendly_fire").requires(cs -> Edit.adminUse(cs, PERMTOGGLEFF))).executes(ctx -> Edit.toggle_ff((CommandSource)ctx.getSource())));
        commandDispatcher.register(command);
        command = (LiteralArgumentBuilder)base.then(((LiteralArgumentBuilder)Commands.func_197057_a((String)"no_mob_spawn").requires(cs -> Edit.adminUse(cs, PERMTOGGLEMOBS))).executes(ctx -> Edit.toggle_no_mob_spawn((CommandSource)ctx.getSource())));
        commandDispatcher.register(command);
        command = (LiteralArgumentBuilder)base.then(((LiteralArgumentBuilder)Commands.func_197057_a((String)"no_explosions").requires(cs -> Edit.adminUse(cs, PERMTOGGLEEXPLODE))).executes(ctx -> Edit.toggle_no_booms((CommandSource)ctx.getSource())));
        commandDispatcher.register(command);
        command = (LiteralArgumentBuilder)base.then(((LiteralArgumentBuilder)Commands.func_197057_a((String)"prefix").requires(cs -> Edit.permUse(cs, "prefix"))).then(Commands.func_197056_a((String)"words", (ArgumentType)StringArgumentType.greedyString()).executes(ctx -> Edit.set_prefix((CommandSource)ctx.getSource(), StringArgumentType.getString((CommandContext)ctx, (String)"words")))));
        commandDispatcher.register(command);
        command = (LiteralArgumentBuilder)base.then(((LiteralArgumentBuilder)Commands.func_197057_a((String)"enter").requires(cs -> Edit.permUse(cs, "editMessages"))).then(Commands.func_197056_a((String)"words", (ArgumentType)StringArgumentType.greedyString()).executes(ctx -> Edit.set_enter((CommandSource)ctx.getSource(), StringArgumentType.getString((CommandContext)ctx, (String)"words")))));
        commandDispatcher.register(command);
        command = (LiteralArgumentBuilder)base.then(((LiteralArgumentBuilder)Commands.func_197057_a((String)"exit").requires(cs -> Edit.permUse(cs, "editMessages"))).then(Commands.func_197056_a((String)"words", (ArgumentType)StringArgumentType.greedyString()).executes(ctx -> Edit.set_exit((CommandSource)ctx.getSource(), StringArgumentType.getString((CommandContext)ctx, (String)"words")))));
        commandDispatcher.register(command);
        command = (LiteralArgumentBuilder)base.then(((LiteralArgumentBuilder)Commands.func_197057_a((String)"deny").requires(cs -> Edit.permUse(cs, "editMessages"))).then(Commands.func_197056_a((String)"words", (ArgumentType)StringArgumentType.greedyString()).executes(ctx -> Edit.set_deny((CommandSource)ctx.getSource(), StringArgumentType.getString((CommandContext)ctx, (String)"words")))));
        commandDispatcher.register(command);
        command = (LiteralArgumentBuilder)base.then(((LiteralArgumentBuilder)Commands.func_197057_a((String)"home").requires(cs -> Edit.permUse(cs, "sethome"))).executes(ctx -> Edit.set_home((CommandSource)ctx.getSource())));
        commandDispatcher.register(command);
    }

    private static int set_prefix(CommandSource source, String prefix) throws CommandSyntaxException {
        prefix = RuleManager.format(prefix);
        ServerPlayerEntity player = source.func_197035_h();
        LandManager.LandTeam landTeam = LandManager.getTeam((Entity)player);
        if (prefix.length() > Essentials.config.prefixLength) {
            prefix = prefix.substring(0, Essentials.config.prefixLength);
        }
        landTeam.prefix = prefix;
        player.func_145747_a(CommandManager.makeFormattedComponent("thutessentials.team.prefix.set", null, false, prefix));
        Edit.refreshTeam(landTeam, source.func_197028_i());
        LandSaveHandler.saveTeam(landTeam.teamName);
        return 0;
    }

    private static int set_enter(CommandSource source, String message) throws CommandSyntaxException {
        message = RuleManager.format(message);
        ServerPlayerEntity player = source.func_197035_h();
        LandManager.LandTeam landTeam = LandManager.getTeam((Entity)player);
        landTeam.enterMessage = message;
        player.func_145747_a(CommandManager.makeFormattedComponent("thutessentials.team.enter.set", null, false, message));
        LandSaveHandler.saveTeam(landTeam.teamName);
        return 0;
    }

    private static int set_exit(CommandSource source, String message) throws CommandSyntaxException {
        message = RuleManager.format(message);
        ServerPlayerEntity player = source.func_197035_h();
        LandManager.LandTeam landTeam = LandManager.getTeam((Entity)player);
        landTeam.exitMessage = message;
        player.func_145747_a(CommandManager.makeFormattedComponent("thutessentials.team.exit.set", null, false, message));
        LandSaveHandler.saveTeam(landTeam.teamName);
        return 0;
    }

    private static int set_deny(CommandSource source, String message) throws CommandSyntaxException {
        message = RuleManager.format(message);
        ServerPlayerEntity player = source.func_197035_h();
        LandManager.LandTeam landTeam = LandManager.getTeam((Entity)player);
        landTeam.denyMessage = message;
        player.func_145747_a(CommandManager.makeFormattedComponent("thutessentials.team.deny.set", null, false, message));
        LandSaveHandler.saveTeam(landTeam.teamName);
        return 0;
    }

    private static int set_home(CommandSource source) throws CommandSyntaxException {
        ServerPlayerEntity player = source.func_197035_h();
        LandManager.LandTeam landTeam = LandManager.getTeam((Entity)player);
        landTeam.home = new Coordinate(player.func_180425_c(), player.field_71093_bK);
        player.func_145747_a(CommandManager.makeFormattedComponent("thutessentials.team.home.set", null, false, landTeam.home));
        LandSaveHandler.saveTeam(landTeam.teamName);
        return 0;
    }

    private static int toggle_frames(CommandSource source) throws CommandSyntaxException {
        ServerPlayerEntity player = source.func_197035_h();
        LandManager.LandTeam landTeam = LandManager.getTeam((Entity)player);
        landTeam.protectFrames = !landTeam.protectFrames;
        player.func_145747_a(CommandManager.makeFormattedComponent("thutessentials.team.frames.set", null, false, landTeam.protectFrames));
        LandSaveHandler.saveTeam(landTeam.teamName);
        return 0;
    }

    private static int toggle_reserve(CommandSource source) throws CommandSyntaxException {
        ServerPlayerEntity player = source.func_197035_h();
        LandManager.LandTeam landTeam = LandManager.getTeam((Entity)player);
        landTeam.reserved = !landTeam.reserved;
        player.func_145747_a(CommandManager.makeFormattedComponent("thutessentials.team.reserve.set", null, false, landTeam.reserved));
        LandSaveHandler.saveTeam(landTeam.teamName);
        return 0;
    }

    private static int toggle_ff(CommandSource source) throws CommandSyntaxException {
        ServerPlayerEntity player = source.func_197035_h();
        LandManager.LandTeam landTeam = LandManager.getTeam((Entity)player);
        landTeam.friendlyFire = !landTeam.friendlyFire;
        player.func_145747_a(CommandManager.makeFormattedComponent("thutessentials.team.ff.set", null, false, landTeam.friendlyFire));
        LandSaveHandler.saveTeam(landTeam.teamName);
        return 0;
    }

    private static int toggle_no_player_damage(CommandSource source) throws CommandSyntaxException {
        ServerPlayerEntity player = source.func_197035_h();
        LandManager.LandTeam landTeam = LandManager.getTeam((Entity)player);
        landTeam.noPlayerDamage = !landTeam.noPlayerDamage;
        player.func_145747_a(CommandManager.makeFormattedComponent("thutessentials.team.noplayerdamage.set", null, false, landTeam.noPlayerDamage));
        LandSaveHandler.saveTeam(landTeam.teamName);
        return 0;
    }

    private static int toggle_no_npc_damage(CommandSource source) throws CommandSyntaxException {
        ServerPlayerEntity player = source.func_197035_h();
        LandManager.LandTeam landTeam = LandManager.getTeam((Entity)player);
        landTeam.noNPCDamage = !landTeam.noNPCDamage;
        player.func_145747_a(CommandManager.makeFormattedComponent("thutessentials.team.nonpcdamage.set", null, false, landTeam.noNPCDamage));
        LandSaveHandler.saveTeam(landTeam.teamName);
        return 0;
    }

    private static int toggle_no_mob_spawn(CommandSource source) throws CommandSyntaxException {
        ServerPlayerEntity player = source.func_197035_h();
        LandManager.LandTeam landTeam = LandManager.getTeam((Entity)player);
        landTeam.noMobSpawn = !landTeam.noMobSpawn;
        player.func_145747_a(CommandManager.makeFormattedComponent("thutessentials.team.nomobspawn.set", null, false, landTeam.noMobSpawn));
        LandSaveHandler.saveTeam(landTeam.teamName);
        return 0;
    }

    private static int toggle_no_booms(CommandSource source) throws CommandSyntaxException {
        ServerPlayerEntity player = source.func_197035_h();
        LandManager.LandTeam landTeam = LandManager.getTeam((Entity)player);
        landTeam.noExplosions = !landTeam.noExplosions;
        player.func_145747_a(CommandManager.makeFormattedComponent("thutessentials.team.nobooms.set", null, false, landTeam.noExplosions));
        LandSaveHandler.saveTeam(landTeam.teamName);
        return 0;
    }

    private static int toggle_any_break(CommandSource source) throws CommandSyntaxException {
        ServerPlayerEntity player = source.func_197035_h();
        LandManager.LandTeam landTeam = LandManager.getTeam((Entity)player);
        landTeam.anyBreak = !landTeam.anyBreak;
        player.func_145747_a(CommandManager.makeFormattedComponent("thutessentials.team.anybreak.set", null, false, landTeam.anyBreak));
        LandSaveHandler.saveTeam(landTeam.teamName);
        return 0;
    }

    private static int toggle_fake_players(CommandSource source) throws CommandSyntaxException {
        ServerPlayerEntity player = source.func_197035_h();
        LandManager.LandTeam landTeam = LandManager.getTeam((Entity)player);
        landTeam.fakePlayers = !landTeam.fakePlayers;
        player.func_145747_a(CommandManager.makeFormattedComponent("thutessentials.team.fakeplayers.set", null, false, landTeam.fakePlayers));
        LandSaveHandler.saveTeam(landTeam.teamName);
        return 0;
    }

    private static int toggle_any_place(CommandSource source) throws CommandSyntaxException {
        ServerPlayerEntity player = source.func_197035_h();
        LandManager.LandTeam landTeam = LandManager.getTeam((Entity)player);
        landTeam.anyPlace = !landTeam.anyPlace;
        player.func_145747_a(CommandManager.makeFormattedComponent("thutessentials.team.anyplace.set", null, false, landTeam.anyPlace));
        LandSaveHandler.saveTeam(landTeam.teamName);
        return 0;
    }

    private static int toggle_public(CommandSource source) throws CommandSyntaxException {
        ServerPlayerEntity player = source.func_197035_h();
        LandManager.LandTeam landTeam = LandManager.getTeam((Entity)player);
        landTeam.allPublic = !landTeam.allPublic;
        player.func_145747_a(CommandManager.makeFormattedComponent("thutessentials.team.public.set", null, false, landTeam.allPublic));
        LandSaveHandler.saveTeam(landTeam.teamName);
        return 0;
    }

    private static void refreshTeam(LandManager.LandTeam landTeam, MinecraftServer server) {
    }
}

