/*
 * Decompiled with CFR 0.152.
 */
package thut.essentials.commands.land.management;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.util.List;
import net.minecraft.command.CommandSource;
import net.minecraft.command.Commands;
import net.minecraft.command.arguments.EntityArgument;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.util.text.ITextComponent;
import net.minecraftforge.server.permission.DefaultPermissionLevel;
import net.minecraftforge.server.permission.PermissionAPI;
import thut.essentials.Essentials;
import thut.essentials.commands.CommandManager;
import thut.essentials.land.LandManager;

public class Invite {
    public static void register(CommandDispatcher<CommandSource> commandDispatcher) {
        LiteralArgumentBuilder command;
        String perm;
        String name = "team_invites";
        if (!Essentials.config.commandBlacklist.contains(name)) {
            perm = "command." + name;
            PermissionAPI.registerNode((String)perm, (DefaultPermissionLevel)DefaultPermissionLevel.ALL, (String)("Can the player use /" + name));
            command = (LiteralArgumentBuilder)Commands.func_197057_a((String)name).requires(cs -> CommandManager.hasPerm(cs, perm));
            command = (LiteralArgumentBuilder)command.executes(ctx -> Invite.execute_invites((CommandSource)ctx.getSource()));
            commandDispatcher.register(command);
        }
        if (!Essentials.config.commandBlacklist.contains(name = "team_invite")) {
            perm = "command." + name;
            PermissionAPI.registerNode((String)perm, (DefaultPermissionLevel)DefaultPermissionLevel.ALL, (String)("Can the player use /" + name));
            command = (LiteralArgumentBuilder)Commands.func_197057_a((String)name).requires(cs -> CommandManager.hasPerm(cs, perm));
            command = (LiteralArgumentBuilder)command.then(Commands.func_197056_a((String)"player", (ArgumentType)EntityArgument.func_197096_c()).executes(ctx -> Invite.execute_invite((CommandSource)ctx.getSource(), EntityArgument.func_197089_d((CommandContext)ctx, (String)"player"))));
            commandDispatcher.register(command);
        }
    }

    private static int execute_invites(CommandSource source) throws CommandSyntaxException {
        ServerPlayerEntity player = source.func_197035_h();
        List<String> c = LandManager.getInstance().getInvites(player.func_110124_au());
        if (c.isEmpty()) {
            player.func_145747_a(CommandManager.makeFormattedComponent("thutessentials.team.invite.none"));
            return 1;
        }
        player.func_145747_a(CommandManager.makeFormattedComponent("thutessentials.team.invites"));
        String cmd = "join_team";
        for (String element : c) {
            String command = "/join_team " + element;
            ITextComponent message = CommandManager.makeFormattedCommandLink("thutessentials.team.invite.link", command, null, false, c);
            player.func_145747_a(message);
        }
        return 0;
    }

    private static int execute_invite(CommandSource source, ServerPlayerEntity invitee) throws CommandSyntaxException {
        LandManager.LandTeam oldTeam;
        ServerPlayerEntity inviter = source.func_197035_h();
        if (inviter == invitee) {
            source.func_197021_a(CommandManager.makeFormattedComponent("thutessentials.team.invite.noself"));
            return 1;
        }
        LandManager.LandTeam landTeam = LandManager.getTeam((Entity)inviter);
        if (landTeam == (oldTeam = LandManager.getTeam((Entity)invitee))) {
            source.func_197021_a(CommandManager.makeFormattedComponent("thutessentials.team.invite.alreadyin", null, false, invitee.func_145748_c_().func_150254_d()));
            return 1;
        }
        if (!landTeam.hasRankPerm(inviter.func_110124_au(), "invite")) {
            source.func_197021_a(CommandManager.makeFormattedComponent("thutessentials.team.invite.noteamperms"));
            return 1;
        }
        String team = landTeam.teamName;
        if (LandManager.getInstance().hasInvite(invitee.func_110124_au(), team)) {
            source.func_197021_a(CommandManager.makeFormattedComponent("thutessentials.team.invite.alreadyinvited", null, false, invitee.func_145748_c_().func_150254_d()));
            return 1;
        }
        boolean invite = LandManager.getInstance().invite(inviter.func_110124_au(), invitee.func_110124_au());
        if (!invite) {
            source.func_197021_a(CommandManager.makeFormattedComponent("thutessentials.team.invite.failed"));
            return 1;
        }
        String cmd = "join_team";
        String command = "/join_team " + team;
        ITextComponent header = CommandManager.makeFormattedComponent("thutessentials.team.invite.invited_recieve", null, false, landTeam.teamName, inviter.func_145748_c_());
        ITextComponent message = CommandManager.makeFormattedCommandLink("thutessentials.team.invite.link", command, null, false, landTeam.teamName);
        invitee.func_145747_a(header);
        invitee.func_145747_a(message);
        inviter.func_145747_a(CommandManager.makeFormattedComponent("thutessentials.team.invite.invited_sent", null, false, invitee.func_145748_c_().func_150254_d()));
        return 0;
    }
}

