/*
 * Decompiled with CFR 0.152.
 */
package thut.essentials.commands.land.management;

import com.google.common.collect.Lists;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.suggestion.SuggestionProvider;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.minecraft.command.CommandSource;
import net.minecraft.command.Commands;
import net.minecraft.command.ISuggestionProvider;
import net.minecraft.command.arguments.EntityArgument;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraftforge.server.permission.DefaultPermissionLevel;
import net.minecraftforge.server.permission.PermissionAPI;
import thut.essentials.Essentials;
import thut.essentials.commands.CommandManager;
import thut.essentials.land.LandManager;

public class Join {
    public static void register(CommandDispatcher<CommandSource> commandDispatcher) {
        LiteralArgumentBuilder command;
        String perm;
        SuggestionProvider suggestor = (ctx, sb) -> ISuggestionProvider.func_197005_b(Join.getTeams(), (SuggestionsBuilder)sb);
        String name = "join_team";
        if (!Essentials.config.commandBlacklist.contains(name)) {
            perm = "command." + name;
            PermissionAPI.registerNode((String)perm, (DefaultPermissionLevel)DefaultPermissionLevel.ALL, (String)("Can the player use /" + name));
            command = (LiteralArgumentBuilder)Commands.func_197057_a((String)name).requires(cs -> CommandManager.hasPerm(cs, perm));
            command = (LiteralArgumentBuilder)command.then(Commands.func_197056_a((String)"team", (ArgumentType)StringArgumentType.string()).suggests(suggestor).executes(ctx -> Join.execute((CommandSource)ctx.getSource(), null, StringArgumentType.getString((CommandContext)ctx, (String)"team"))));
            commandDispatcher.register(command);
        }
        if (!Essentials.config.commandBlacklist.contains(name = "leave_team")) {
            perm = "command." + name;
            PermissionAPI.registerNode((String)perm, (DefaultPermissionLevel)DefaultPermissionLevel.ALL, (String)("Can the player use /" + name));
            command = (LiteralArgumentBuilder)Commands.func_197057_a((String)name).requires(cs -> CommandManager.hasPerm(cs, perm));
            command = (LiteralArgumentBuilder)command.executes(ctx -> Join.execute((CommandSource)ctx.getSource(), null, LandManager.getDefaultTeam().teamName));
            commandDispatcher.register(command);
        }
        if (!Essentials.config.commandBlacklist.contains(name = "add_to_team")) {
            perm = "command." + name;
            PermissionAPI.registerNode((String)perm, (DefaultPermissionLevel)DefaultPermissionLevel.OP, (String)("Can the player use /" + name));
            command = (LiteralArgumentBuilder)Commands.func_197057_a((String)name).requires(cs -> CommandManager.hasPerm(cs, perm));
            command = (LiteralArgumentBuilder)command.then(Commands.func_197056_a((String)"team", (ArgumentType)StringArgumentType.string()).suggests(suggestor).then(Commands.func_197056_a((String)"player", (ArgumentType)EntityArgument.func_197096_c()).executes(ctx -> Join.execute((CommandSource)ctx.getSource(), EntityArgument.func_197089_d((CommandContext)ctx, (String)"player"), StringArgumentType.getString((CommandContext)ctx, (String)"team")))));
            commandDispatcher.register(command);
        }
    }

    private static List<String> getTeams() {
        ArrayList teams = Lists.newArrayList(LandManager.getInstance()._teamMap.keySet());
        Collections.sort(teams);
        return teams;
    }

    private static int execute(CommandSource source, ServerPlayerEntity player, String team) throws CommandSyntaxException {
        boolean forced;
        boolean bl = forced = player != null;
        if (player == null) {
            player = source.func_197035_h();
        }
        LandManager.LandTeam teamtojoin = LandManager.getInstance().getTeam(team, false);
        LandManager.LandTeam oldTeam = LandManager.getTeam((Entity)player);
        if (oldTeam == teamtojoin) {
            source.func_197021_a(CommandManager.makeFormattedComponent("thutessentials.team.join.alreadyin"));
            return 1;
        }
        if (teamtojoin == null) {
            source.func_197021_a(CommandManager.makeFormattedComponent("thutessentials.team.notfound"));
            return 1;
        }
        boolean canJoinInvite = PermissionAPI.hasPermission((PlayerEntity)player, (String)"thutessentials.teams.join.invite");
        canJoinInvite = canJoinInvite && LandManager.getInstance().hasInvite(player.func_110124_au(), team);
        boolean canJoinNoInvite = forced || PermissionAPI.hasPermission((PlayerEntity)player, (String)"thutessentials.teams.join.force");
        boolean bl2 = canJoinInvite = canJoinInvite || teamtojoin.teamName.equalsIgnoreCase(Essentials.config.defaultTeamName);
        if (canJoinInvite && teamtojoin.member.size() == 0) {
            boolean bl3 = canJoinInvite = !LandManager.getInstance().getTeam((String)team, (boolean)false).reserved;
        }
        if (canJoinInvite || canJoinNoInvite) {
            LandManager.getInstance().addToTeam(player.func_110124_au(), team);
            player.func_145747_a(CommandManager.makeFormattedComponent("thutessentials.team.joined", null, false, teamtojoin.teamName));
            return 0;
        }
        return 1;
    }
}

