/*
 * Decompiled with CFR 0.152.
 */
package thut.essentials.commands.land.management;

import com.mojang.authlib.GameProfile;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.util.Collection;
import net.minecraft.command.CommandSource;
import net.minecraft.command.Commands;
import net.minecraft.command.arguments.GameProfileArgument;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraftforge.server.permission.DefaultPermissionLevel;
import net.minecraftforge.server.permission.PermissionAPI;
import thut.essentials.Essentials;
import thut.essentials.commands.CommandManager;
import thut.essentials.land.LandManager;

public class Kick {
    public static void register(CommandDispatcher<CommandSource> commandDispatcher) {
        String name = "kick_team_member";
        if (!Essentials.config.commandBlacklist.contains("kick_team_member")) {
            String perm = "command.kick_team_member";
            PermissionAPI.registerNode((String)"command.kick_team_member", (DefaultPermissionLevel)DefaultPermissionLevel.ALL, (String)"Can the player use /kick_team_member");
            LiteralArgumentBuilder command = (LiteralArgumentBuilder)Commands.func_197057_a((String)"kick_team_member").requires(cs -> CommandManager.hasPerm(cs, perm));
            command = (LiteralArgumentBuilder)command.then(Commands.func_197056_a((String)"player", (ArgumentType)GameProfileArgument.func_197108_a()).executes(ctx -> Kick.kick((CommandSource)ctx.getSource(), GameProfileArgument.func_197109_a((CommandContext)ctx, (String)"player"))));
            commandDispatcher.register(command);
        }
    }

    private static int kick(CommandSource source, Collection<GameProfile> collection) throws CommandSyntaxException {
        int i = 0;
        for (GameProfile player : collection) {
            i += Kick.kick(source, player);
        }
        return i;
    }

    private static int kick(CommandSource source, GameProfile player) throws CommandSyntaxException {
        LandManager.LandTeam teamB;
        ServerPlayerEntity user = source.func_197035_h();
        LandManager.LandTeam teamA = LandManager.getTeam((Entity)user);
        if (teamA != (teamB = LandManager.getTeam(player.getId()))) {
            source.func_197021_a(CommandManager.makeFormattedComponent("thutessentials.teams.kick.mustbeteam"));
            return 1;
        }
        if (!teamA.hasRankPerm(user.func_110124_au(), "kick")) {
            source.func_197021_a(CommandManager.makeFormattedComponent("thutessentials.teams.kick.teamperms"));
            return 1;
        }
        LandManager.getInstance().removeFromTeam(player.getId());
        Essentials.config.sendFeedback(source, "thutessentials.teams.kicked", false, player.getName());
        return 0;
    }
}

