/*
 * Decompiled with CFR 0.152.
 */
package thut.essentials.commands.land.management;

import com.google.common.collect.Lists;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Set;
import java.util.UUID;
import net.minecraft.command.CommandSource;
import net.minecraft.command.Commands;
import net.minecraft.command.arguments.EntityArgument;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.util.text.ITextComponent;
import net.minecraftforge.server.permission.DefaultPermissionLevel;
import net.minecraftforge.server.permission.PermissionAPI;
import thut.essentials.Essentials;
import thut.essentials.commands.CommandManager;
import thut.essentials.commands.land.management.Edit;
import thut.essentials.commands.land.util.Members;
import thut.essentials.land.LandManager;
import thut.essentials.land.LandSaveHandler;

public class Ranks {
    public static void register(CommandDispatcher<CommandSource> commandDispatcher) {
        String name = "edit_ranks";
        if (Essentials.config.commandBlacklist.contains("edit_ranks")) {
            return;
        }
        String perm = "command.edit_ranks";
        PermissionAPI.registerNode((String)"command.edit_ranks", (DefaultPermissionLevel)DefaultPermissionLevel.ALL, (String)"Can the player use /edit_ranks");
        LiteralArgumentBuilder base = (LiteralArgumentBuilder)Commands.func_197057_a((String)"edit_ranks").requires(cs -> Edit.adminUse(cs, perm));
        LiteralArgumentBuilder command = (LiteralArgumentBuilder)base.then(Commands.func_197057_a((String)"list_ranks").executes(ctx -> Ranks.list_ranks((CommandSource)ctx.getSource())));
        commandDispatcher.register(command);
        base = (LiteralArgumentBuilder)Commands.func_197057_a((String)"edit_ranks").requires(cs -> Edit.adminUse(cs, perm));
        command = (LiteralArgumentBuilder)base.then(Commands.func_197057_a((String)"list_members").then(Commands.func_197056_a((String)"rank", (ArgumentType)StringArgumentType.string()).executes(ctx -> Ranks.list_members((CommandSource)ctx.getSource(), StringArgumentType.getString((CommandContext)ctx, (String)"rank")))));
        commandDispatcher.register(command);
        base = (LiteralArgumentBuilder)Commands.func_197057_a((String)"edit_ranks").requires(cs -> Edit.adminUse(cs, perm));
        command = (LiteralArgumentBuilder)base.then(Commands.func_197057_a((String)"add_rank").then(Commands.func_197056_a((String)"rank", (ArgumentType)StringArgumentType.string()).executes(ctx -> Ranks.add_rank((CommandSource)ctx.getSource(), StringArgumentType.getString((CommandContext)ctx, (String)"rank")))));
        commandDispatcher.register(command);
        base = (LiteralArgumentBuilder)Commands.func_197057_a((String)"edit_ranks").requires(cs -> Edit.adminUse(cs, perm));
        command = (LiteralArgumentBuilder)base.then(Commands.func_197057_a((String)"del_rank").then(Commands.func_197056_a((String)"rank", (ArgumentType)StringArgumentType.string()).executes(ctx -> Ranks.del_rank((CommandSource)ctx.getSource(), StringArgumentType.getString((CommandContext)ctx, (String)"rank")))));
        commandDispatcher.register(command);
        base = (LiteralArgumentBuilder)Commands.func_197057_a((String)"edit_ranks").requires(cs -> Edit.adminUse(cs, perm));
        command = (LiteralArgumentBuilder)base.then(Commands.func_197057_a((String)"add_perm").then(Commands.func_197056_a((String)"rank", (ArgumentType)StringArgumentType.string()).then(Commands.func_197056_a((String)"perm", (ArgumentType)StringArgumentType.string()).executes(ctx -> Ranks.add_perm((CommandSource)ctx.getSource(), StringArgumentType.getString((CommandContext)ctx, (String)"rank"), StringArgumentType.getString((CommandContext)ctx, (String)"perm"))))));
        commandDispatcher.register(command);
        base = (LiteralArgumentBuilder)Commands.func_197057_a((String)"edit_ranks").requires(cs -> Edit.adminUse(cs, perm));
        command = (LiteralArgumentBuilder)base.then(Commands.func_197057_a((String)"del_perm").then(Commands.func_197056_a((String)"rank", (ArgumentType)StringArgumentType.string()).then(Commands.func_197056_a((String)"perm", (ArgumentType)StringArgumentType.string()).executes(ctx -> Ranks.del_perm((CommandSource)ctx.getSource(), StringArgumentType.getString((CommandContext)ctx, (String)"rank"), StringArgumentType.getString((CommandContext)ctx, (String)"perm"))))));
        commandDispatcher.register(command);
        base = (LiteralArgumentBuilder)Commands.func_197057_a((String)"edit_ranks").requires(cs -> Edit.adminUse(cs, perm));
        command = (LiteralArgumentBuilder)base.then(Commands.func_197057_a((String)"set_rank").then(Commands.func_197056_a((String)"rank", (ArgumentType)StringArgumentType.string()).then(Commands.func_197056_a((String)"player", (ArgumentType)EntityArgument.func_197096_c()).executes(ctx -> Ranks.set_rank((CommandSource)ctx.getSource(), EntityArgument.func_197089_d((CommandContext)ctx, (String)"player"), StringArgumentType.getString((CommandContext)ctx, (String)"rank"))))));
        commandDispatcher.register(command);
        base = (LiteralArgumentBuilder)Commands.func_197057_a((String)"edit_ranks").requires(cs -> Edit.adminUse(cs, perm));
        command = (LiteralArgumentBuilder)base.then(Commands.func_197057_a((String)"rem_rank").then(Commands.func_197056_a((String)"rank", (ArgumentType)StringArgumentType.string()).then(Commands.func_197056_a((String)"player", (ArgumentType)EntityArgument.func_197096_c()).executes(ctx -> Ranks.rem_rank((CommandSource)ctx.getSource(), EntityArgument.func_197089_d((CommandContext)ctx, (String)"player"), StringArgumentType.getString((CommandContext)ctx, (String)"rank"))))));
        commandDispatcher.register(command);
    }

    private static int set_rank(CommandSource source, ServerPlayerEntity player, String rankName) throws CommandSyntaxException {
        LandManager.LandTeam landTeam = LandManager.getTeam((Entity)player);
        LandManager.PlayerRank rank = landTeam.rankMap.get(rankName);
        if (rank == null) {
            Essentials.config.sendError(source, "thutessentials.team.rank.notfound", rankName);
            return 1;
        }
        rank.members.add(player.func_110124_au());
        landTeam._ranksMembers.put(player.func_110124_au(), rank);
        player.func_145747_a(CommandManager.makeFormattedComponent("thutessentials.team.rank.set", null, false, player.func_145748_c_(), rankName));
        LandSaveHandler.saveTeam(landTeam.teamName);
        return 0;
    }

    private static int rem_rank(CommandSource source, ServerPlayerEntity player, String rankName) throws CommandSyntaxException {
        LandManager.LandTeam landTeam = LandManager.getTeam((Entity)player);
        LandManager.PlayerRank rank = landTeam.rankMap.get(rankName);
        if (rank == null) {
            Essentials.config.sendError(source, "thutessentials.team.rank.notfound", rankName);
            return 1;
        }
        rank.members.remove(player.func_110124_au());
        landTeam._ranksMembers.remove(player.func_110124_au());
        player.func_145747_a(CommandManager.makeFormattedComponent("thutessentials.team.rank.rem", null, false, player.func_145748_c_(), rankName));
        LandSaveHandler.saveTeam(landTeam.teamName);
        return 0;
    }

    private static int list_ranks(CommandSource source) throws CommandSyntaxException {
        ServerPlayerEntity player = source.func_197035_h();
        LandManager.LandTeam landTeam = LandManager.getTeam((Entity)player);
        player.func_145747_a(CommandManager.makeFormattedComponent("thutessentials.team.rank.header"));
        ArrayList ranks = Lists.newArrayList(landTeam.rankMap.keySet());
        Collections.sort(ranks);
        for (String s : ranks) {
            player.func_145747_a(CommandManager.makeFormattedComponent("thutessentials.team.rank.entry", null, false, s));
        }
        return 0;
    }

    private static int add_perm(CommandSource source, String rankName, String perm) throws CommandSyntaxException {
        ServerPlayerEntity player = source.func_197035_h();
        LandManager.LandTeam landTeam = LandManager.getTeam((Entity)player);
        LandManager.PlayerRank rank = landTeam.rankMap.get(rankName);
        if (rank == null) {
            Essentials.config.sendError(source, "thutessentials.team.rank.notfound", rankName);
            return 1;
        }
        if (rank.perms.add(perm)) {
            player.func_145747_a(CommandManager.makeFormattedComponent("thutessentials.team.rank.perm.set", null, false, rankName, perm));
        } else {
            player.func_145747_a(CommandManager.makeFormattedComponent("thutessentials.team.rank.perm.had", null, false, rankName));
        }
        LandSaveHandler.saveTeam(landTeam.teamName);
        return 0;
    }

    private static int del_perm(CommandSource source, String rankName, String perm) throws CommandSyntaxException {
        ServerPlayerEntity player = source.func_197035_h();
        LandManager.LandTeam landTeam = LandManager.getTeam((Entity)player);
        LandManager.PlayerRank rank = landTeam.rankMap.get(rankName);
        if (rank == null) {
            Essentials.config.sendError(source, "thutessentials.team.rank.notfound", rankName);
            return 1;
        }
        if (rank.perms.remove(perm)) {
            player.func_145747_a(CommandManager.makeFormattedComponent("thutessentials.team.rank.perm.unset", null, false, rankName));
        } else {
            player.func_145747_a(CommandManager.makeFormattedComponent("thutessentials.team.rank.perm.nohad", null, false, rankName));
        }
        LandSaveHandler.saveTeam(landTeam.teamName);
        return 0;
    }

    private static int add_rank(CommandSource source, String rankName) throws CommandSyntaxException {
        ServerPlayerEntity player = source.func_197035_h();
        LandManager.LandTeam landTeam = LandManager.getTeam((Entity)player);
        LandManager.PlayerRank rank = landTeam.rankMap.get(rankName);
        if (rank != null) {
            Essentials.config.sendError(source, "thutessentials.team.rank.alreadyexists", rankName);
            return 1;
        }
        landTeam.rankMap.put(rankName, new LandManager.PlayerRank());
        player.func_145747_a(CommandManager.makeFormattedComponent("thutessentials.team.rank.added", null, false, rankName));
        LandSaveHandler.saveTeam(landTeam.teamName);
        return 0;
    }

    private static int del_rank(CommandSource source, String rankName) throws CommandSyntaxException {
        ServerPlayerEntity player = source.func_197035_h();
        LandManager.LandTeam landTeam = LandManager.getTeam((Entity)player);
        LandManager.PlayerRank rank = landTeam.rankMap.get(rankName);
        if (rank == null) {
            Essentials.config.sendError(source, "thutessentials.team.rank.notfound", rankName);
            return 1;
        }
        landTeam.rankMap.remove(rankName);
        player.func_145747_a(CommandManager.makeFormattedComponent("thutessentials.team.rank.deleted", null, false, rankName));
        LandSaveHandler.saveTeam(landTeam.teamName);
        return 0;
    }

    private static int list_members(CommandSource source, String rankName) throws CommandSyntaxException {
        ServerPlayerEntity player = source.func_197035_h();
        LandManager.LandTeam landTeam = LandManager.getTeam((Entity)player);
        LandManager.PlayerRank rank = landTeam.rankMap.get(rankName);
        if (rank == null) {
            Essentials.config.sendError(source, "thutessentials.team.rank.notfound", rankName);
            return 1;
        }
        Set<UUID> c = rank.members;
        player.func_145747_a(CommandManager.makeFormattedComponent("thutessentials.team.rank.memheader", null, false, rankName));
        ITextComponent list = Members.getMembers(source.func_197028_i(), c, false);
        player.func_145747_a(list);
        return 0;
    }
}

