/*
 * Decompiled with CFR 0.152.
 */
package thut.essentials.commands.land.management;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.suggestion.SuggestionProvider;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import net.minecraft.command.CommandSource;
import net.minecraft.command.Commands;
import net.minecraft.command.ISuggestionProvider;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraftforge.server.permission.DefaultPermissionLevel;
import net.minecraftforge.server.permission.PermissionAPI;
import thut.essentials.Essentials;
import thut.essentials.commands.CommandManager;
import thut.essentials.commands.land.management.Edit;
import thut.essentials.land.LandManager;

public class Relations {
    public static List<String> perms = Lists.newArrayList();
    public static Map<String, String> perm_info = Maps.newHashMap();

    public static SuggestionProvider<CommandSource> suggestTeams() {
        ArrayList values = Lists.newArrayList();
        for (String s : LandManager.getInstance()._teamMap.keySet()) {
            values.add(s);
        }
        Collections.sort(values);
        return (ctx, sb) -> ISuggestionProvider.func_197005_b((Iterable)values, (SuggestionsBuilder)sb);
    }

    public static SuggestionProvider<CommandSource> suggestPerms() {
        return (ctx, sb) -> ISuggestionProvider.func_197005_b(perms, (SuggestionsBuilder)sb);
    }

    public static void register(CommandDispatcher<CommandSource> commandDispatcher) {
        String name = "team_relations";
        if (Essentials.config.commandBlacklist.contains("team_relations")) {
            return;
        }
        String perm = "command.team_relations";
        PermissionAPI.registerNode((String)"command.team_relations", (DefaultPermissionLevel)DefaultPermissionLevel.ALL, (String)"Can the player use /team_relations");
        LiteralArgumentBuilder base = (LiteralArgumentBuilder)Commands.func_197057_a((String)"team_relations").requires(cs -> Edit.adminUse(cs, perm));
        LiteralArgumentBuilder command = (LiteralArgumentBuilder)base.then(Commands.func_197057_a((String)"list").executes(ctx -> Relations.list((CommandSource)ctx.getSource())));
        commandDispatcher.register(command);
        base = (LiteralArgumentBuilder)Commands.func_197057_a((String)"team_relations").requires(cs -> Edit.adminUse(cs, perm));
        command = (LiteralArgumentBuilder)base.then(Commands.func_197057_a((String)"relations").then(Commands.func_197056_a((String)"team", (ArgumentType)StringArgumentType.string()).suggests(Relations.suggestTeams()).executes(ctx -> Relations.relations((CommandSource)ctx.getSource(), StringArgumentType.getString((CommandContext)ctx, (String)"team")))));
        commandDispatcher.register(command);
        base = (LiteralArgumentBuilder)Commands.func_197057_a((String)"team_relations").requires(cs -> Edit.adminUse(cs, perm));
        command = (LiteralArgumentBuilder)base.then(Commands.func_197057_a((String)"relations_all").executes(ctx -> Relations.relations_all((CommandSource)ctx.getSource())));
        commandDispatcher.register(command);
        base = (LiteralArgumentBuilder)Commands.func_197057_a((String)"team_relations").requires(cs -> Edit.adminUse(cs, perm));
        command = (LiteralArgumentBuilder)base.then(Commands.func_197057_a((String)"set").then(Commands.func_197056_a((String)"team", (ArgumentType)StringArgumentType.string()).suggests(Relations.suggestTeams()).then(Commands.func_197056_a((String)"perm", (ArgumentType)StringArgumentType.string()).suggests(Relations.suggestPerms()).executes(ctx -> Relations.set((CommandSource)ctx.getSource(), StringArgumentType.getString((CommandContext)ctx, (String)"team"), StringArgumentType.getString((CommandContext)ctx, (String)"perm"))))));
        commandDispatcher.register(command);
        base = (LiteralArgumentBuilder)Commands.func_197057_a((String)"team_relations").requires(cs -> Edit.adminUse(cs, perm));
        command = (LiteralArgumentBuilder)base.then(Commands.func_197057_a((String)"unset").then(Commands.func_197056_a((String)"team", (ArgumentType)StringArgumentType.string()).suggests(Relations.suggestTeams()).then(Commands.func_197056_a((String)"perm", (ArgumentType)StringArgumentType.string()).suggests(Relations.suggestPerms()).executes(ctx -> Relations.unset((CommandSource)ctx.getSource(), StringArgumentType.getString((CommandContext)ctx, (String)"team"), StringArgumentType.getString((CommandContext)ctx, (String)"perm"))))));
        commandDispatcher.register(command);
    }

    private static int list(CommandSource source) {
        Essentials.config.sendFeedback(source, "thutessentials.team.relations.header", false, new Object[0]);
        for (String s : perms) {
            Essentials.config.sendFeedback(source, perm_info.get(s), false, s);
        }
        return 0;
    }

    private static int relations_all(CommandSource source) throws CommandSyntaxException {
        ServerPlayerEntity player = source.func_197035_h();
        LandManager.LandTeam landTeam = LandManager.getTeam((Entity)player);
        ArrayList keys = Lists.newArrayList(landTeam.relations.keySet());
        if (keys.isEmpty()) {
            player.func_145747_a(CommandManager.makeFormattedComponent("thutessentials.team.relations.none"));
        }
        for (String team : keys) {
            Relations.relations(source, team);
        }
        return 0;
    }

    private static int relations(CommandSource source, String team) throws CommandSyntaxException {
        ServerPlayerEntity player = source.func_197035_h();
        LandManager.LandTeam landTeam = LandManager.getTeam((Entity)player);
        LandManager.Relation relate = landTeam.relations.get(team);
        if (relate == null) {
            Essentials.config.sendError(source, "thutessentials.team.relations.notfound", team);
            return 1;
        }
        player.func_145747_a(CommandManager.makeFormattedComponent("thutessentials.team.relations.with", null, false, team));
        for (String s : relate.perms) {
            player.func_145747_a(CommandManager.makeFormattedComponent("thutessentials.team.relations.entry", null, false, s));
        }
        return 0;
    }

    private static int set(CommandSource source, String other, String perm) throws CommandSyntaxException {
        ServerPlayerEntity player = source.func_197035_h();
        LandManager.LandTeam landTeam = LandManager.getTeam((Entity)player);
        if (!perms.contains(perm)) {
            Essentials.config.sendError(source, "thutessentials.team.relations.noperm", new Object[0]);
            return 1;
        }
        LandManager.LandTeam team = LandManager.getInstance().getTeam(other, false);
        if (team == null) {
            Essentials.config.sendError(source, "thutessentials.team.notfound", new Object[0]);
            return 1;
        }
        LandManager.Relation relation = landTeam.relations.get(other);
        if (relation == null) {
            relation = new LandManager.Relation();
            landTeam.relations.put(other, relation);
        }
        if (relation.perms.add(perm)) {
            player.func_145747_a(CommandManager.makeFormattedComponent("thutessentials.team.relations.set", null, false, perm));
        } else {
            player.func_145747_a(CommandManager.makeFormattedComponent("thutessentials.team.relations.had", null, false, other));
        }
        return 0;
    }

    private static int unset(CommandSource source, String other, String perm) throws CommandSyntaxException {
        ServerPlayerEntity player = source.func_197035_h();
        LandManager.LandTeam landTeam = LandManager.getTeam((Entity)player);
        if (!perms.contains(perm)) {
            Essentials.config.sendError(source, "thutessentials.team.relations.noperm", new Object[0]);
            return 1;
        }
        LandManager.LandTeam team = LandManager.getInstance().getTeam(other, false);
        if (team == null) {
            Essentials.config.sendError(source, "thutessentials.team.notfound", new Object[0]);
            return 1;
        }
        LandManager.Relation relation = landTeam.relations.get(other);
        if (relation == null) {
            relation = new LandManager.Relation();
            landTeam.relations.put(other, relation);
        }
        if (relation.perms.remove(perm)) {
            player.func_145747_a(CommandManager.makeFormattedComponent("thutessentials.team.relations.unset", null, false, perm, other));
        } else {
            player.func_145747_a(CommandManager.makeFormattedComponent("thutessentials.team.relations.nohad", null, false, other));
        }
        return 0;
    }

    static {
        perms.add("break");
        perms.add("place");
        perms.add("public");
        perms.add("ally");
        for (String s : perms) {
            perm_info.put(s, "thutessentials.team.info." + s);
        }
        Collections.sort(perms);
    }
}

