/*
 * Decompiled with CFR 0.152.
 */
package thut.essentials.commands.land.management;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import net.minecraft.command.CommandSource;
import net.minecraft.command.Commands;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.ServerPlayerEntity;
import thut.essentials.Essentials;
import thut.essentials.commands.CommandManager;
import thut.essentials.commands.land.management.Edit;
import thut.essentials.land.LandManager;

public class Rename {
    public static void register(CommandDispatcher<CommandSource> commandDispatcher) {
        String name = "rename_team";
        if (Essentials.config.commandBlacklist.contains("rename_team")) {
            return;
        }
        String perm = "thutessentials.teams.create";
        LiteralArgumentBuilder command = (LiteralArgumentBuilder)Commands.func_197057_a((String)"rename_team").requires(cs -> Edit.adminUse(cs, "thutessentials.teams.create"));
        command = (LiteralArgumentBuilder)command.then(Commands.func_197056_a((String)"team_name", (ArgumentType)StringArgumentType.string()).executes(ctx -> Rename.execute((CommandSource)ctx.getSource(), StringArgumentType.getString((CommandContext)ctx, (String)"team_name"))));
        commandDispatcher.register(command);
    }

    private static int execute(CommandSource source, String teamname) throws CommandSyntaxException {
        ServerPlayerEntity player = source.func_197035_h();
        LandManager.LandTeam team = LandManager.getTeam((Entity)player);
        if (team == null || team == LandManager.getDefaultTeam()) {
            source.func_197021_a(CommandManager.makeFormattedComponent("thutessentials.team.notinateam"));
            return 1;
        }
        String oldname = team.teamName;
        try {
            LandManager.getInstance().renameTeam(oldname, teamname);
        }
        catch (IllegalArgumentException e) {
            Essentials.config.sendError(source, e.getMessage(), oldname);
            return 1;
        }
        Essentials.config.sendFeedback(source, "thutessentials.team.renamed", false, oldname, teamname);
        return 0;
    }
}

