/*
 * Decompiled with CFR 0.152.
 */
package thut.essentials.commands.land.util;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.util.UUID;
import net.minecraft.command.CommandSource;
import net.minecraft.command.Commands;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.server.permission.DefaultPermissionLevel;
import net.minecraftforge.server.permission.PermissionAPI;
import thut.essentials.Essentials;
import thut.essentials.commands.CommandManager;
import thut.essentials.land.LandManager;
import thut.essentials.util.RuleManager;

public class Chat {
    public static void register(CommandDispatcher<CommandSource> commandDispatcher) {
        String name = "team_chat";
        if (Essentials.config.commandBlacklist.contains("team_chat")) {
            return;
        }
        String perm = "command.team_chat";
        PermissionAPI.registerNode((String)"command.team_chat", (DefaultPermissionLevel)DefaultPermissionLevel.ALL, (String)"Can the player use their team chat.");
        LiteralArgumentBuilder command = (LiteralArgumentBuilder)Commands.func_197057_a((String)"team_chat").requires(cs -> CommandManager.hasPerm(cs, perm));
        command = (LiteralArgumentBuilder)command.then(Commands.func_197056_a((String)"message", (ArgumentType)StringArgumentType.greedyString()).executes(ctx -> Chat.execute((CommandSource)ctx.getSource(), StringArgumentType.getString((CommandContext)ctx, (String)"message"))));
        commandDispatcher.register(command);
    }

    private static int execute(CommandSource source, String message) throws CommandSyntaxException {
        ServerPlayerEntity sender = source.func_197035_h();
        MinecraftServer server = source.func_197028_i();
        LandManager.LandTeam team = LandManager.getTeam((Entity)sender);
        StringTextComponent mess = new StringTextComponent("[Team]" + sender.func_145748_c_().func_150254_d() + ": ");
        mess.func_150256_b().func_150238_a(TextFormatting.YELLOW);
        mess.func_150257_a(CommandManager.makeFormattedComponent(RuleManager.format(message), TextFormatting.AQUA, false));
        if (Essentials.config.logTeamChat) {
            server.func_145747_a((ITextComponent)mess);
        }
        for (UUID id : team.member) {
            try {
                ServerPlayerEntity player = server.func_184103_al().func_177451_a(id);
                if (player == null) continue;
                player.func_145747_a((ITextComponent)mess);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return 0;
    }
}

