/*
 * Decompiled with CFR 0.152.
 */
package thut.essentials.commands.land.util;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import net.minecraft.command.CommandSource;
import net.minecraft.command.Commands;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.dimension.DimensionType;
import net.minecraftforge.server.permission.DefaultPermissionLevel;
import net.minecraftforge.server.permission.PermissionAPI;
import thut.essentials.Essentials;
import thut.essentials.commands.CommandManager;
import thut.essentials.land.LandManager;
import thut.essentials.util.PlayerDataHandler;
import thut.essentials.util.PlayerMover;

public class Home {
    public static void register(CommandDispatcher<CommandSource> commandDispatcher) {
        String name = "team_home";
        if (Essentials.config.commandBlacklist.contains("team_home")) {
            return;
        }
        String perm = "command.team_home";
        PermissionAPI.registerNode((String)"command.team_home", (DefaultPermissionLevel)DefaultPermissionLevel.ALL, (String)"Can the player use the team_home commant.");
        LiteralArgumentBuilder command = (LiteralArgumentBuilder)Commands.func_197057_a((String)"team_home").requires(cs -> CommandManager.hasPerm(cs, perm));
        command = (LiteralArgumentBuilder)command.executes(ctx -> Home.execute((CommandSource)ctx.getSource()));
        commandDispatcher.register(command);
    }

    private static int execute(CommandSource source) throws CommandSyntaxException {
        long time;
        ServerPlayerEntity player = source.func_197035_h();
        LandManager.LandTeam team = LandManager.getTeam((Entity)player);
        if (team.home == null) {
            source.func_197021_a(Essentials.config.getMessage("thutessentials.team.nohomeset", new Object[0]));
            return 1;
        }
        int[] home = new int[]{team.home.x, team.home.y, team.home.z, team.home.dim};
        CompoundNBT tag = PlayerDataHandler.getCustomDataTag((PlayerEntity)player);
        CompoundNBT tptag = tag.func_74775_l("tp");
        long last = tptag.func_74763_f("homeDelay");
        if (last > (time = player.func_184102_h().func_71218_a(DimensionType.field_223227_a_).func_82737_E()) && Essentials.config.homeReUseDelay > 0) {
            player.func_145747_a(Essentials.config.getMessage("thutessentials.tp.tosoon", new Object[0]));
            return 1;
        }
        ITextComponent teleMess = Essentials.config.getMessage("Warping to your Team's Home", new Object[0]);
        tptag.func_74772_a("homeDelay", time + (long)Essentials.config.homeReUseDelay);
        tag.func_218657_a("tp", (INBT)tptag);
        PlayerDataHandler.saveCustomData((PlayerEntity)player);
        PlayerMover.setMove((PlayerEntity)player, Essentials.config.homeActivateDelay, home[3], new BlockPos(home[0], home[1], home[2]), teleMess, PlayerMover.INTERUPTED);
        return 0;
    }
}

