/*
 * Decompiled with CFR 0.152.
 */
package thut.essentials.commands.land.util;

import com.google.common.collect.Lists;
import com.mojang.authlib.GameProfile;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Set;
import java.util.UUID;
import net.minecraft.command.CommandSource;
import net.minecraft.command.Commands;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraftforge.server.permission.DefaultPermissionLevel;
import net.minecraftforge.server.permission.PermissionAPI;
import thut.essentials.Essentials;
import thut.essentials.commands.CommandManager;
import thut.essentials.land.LandManager;

public class Members {
    public static void register(CommandDispatcher<CommandSource> commandDispatcher) {
        String name = "team_members";
        if (Essentials.config.commandBlacklist.contains("team_members")) {
            return;
        }
        String perm = "command.team_members";
        PermissionAPI.registerNode((String)"command.team_members", (DefaultPermissionLevel)DefaultPermissionLevel.ALL, (String)"Can the player see the list members of a team.");
        LiteralArgumentBuilder command = (LiteralArgumentBuilder)Commands.func_197057_a((String)"team_members").requires(cs -> CommandManager.hasPerm(cs, perm));
        command = (LiteralArgumentBuilder)command.then(Commands.func_197056_a((String)"team_name", (ArgumentType)StringArgumentType.string()).executes(ctx -> Members.execute((CommandSource)ctx.getSource(), StringArgumentType.getString((CommandContext)ctx, (String)"team_name"))));
        commandDispatcher.register(command);
    }

    private static int execute(CommandSource source, String teamname) {
        LandManager.LandTeam team = LandManager.getInstance().getTeam(teamname, false);
        if (team == null) {
            Essentials.config.sendError(source, "thutessentials.team.notfound", new Object[0]);
            return 1;
        }
        Essentials.config.sendFeedback(source, "thutessentials.team.members", false, teamname);
        source.func_197030_a(Members.getMembers(source.func_197028_i(), team, true), false);
        return 0;
    }

    public static ITextComponent getMembers(MinecraftServer server, LandManager.LandTeam team, boolean tabbed) {
        Set<UUID> c = team.member;
        return Members.getMembers(server, c, tabbed);
    }

    public static ITextComponent getMembers(MinecraftServer server, Collection<UUID> c, boolean tabbed) {
        StringTextComponent mess = new StringTextComponent("");
        ArrayList ids = Lists.newArrayList(c);
        for (int i = 0; i < ids.size(); ++i) {
            UUID o = (UUID)ids.get(i);
            if (o == null) continue;
            GameProfile profile = CommandManager.getProfile(server, o);
            if (tabbed) {
                mess.func_150258_a("    ");
            }
            if (profile.getName() != null) {
                mess.func_150258_a(profile.getName());
            } else {
                mess.func_150258_a("<unknown> " + o);
            }
            if (i >= ids.size() - 1) continue;
            mess.func_150258_a("\n");
        }
        return mess;
    }
}

