/*
 * Decompiled with CFR 0.152.
 */
package thut.essentials.commands.land.util;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import net.minecraft.command.CommandSource;
import net.minecraft.command.Commands;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraftforge.server.permission.DefaultPermissionLevel;
import net.minecraftforge.server.permission.PermissionAPI;
import thut.essentials.Essentials;
import thut.essentials.commands.CommandManager;
import thut.essentials.land.LandEventsHandler;

public class Show {
    public static void register(CommandDispatcher<CommandSource> commandDispatcher) {
        String name = "show_land";
        if (Essentials.config.commandBlacklist.contains("show_land")) {
            return;
        }
        String perm = "command.show_land";
        PermissionAPI.registerNode((String)"command.show_land", (DefaultPermissionLevel)DefaultPermissionLevel.ALL, (String)"Can the player see the ownership status of land nearby.");
        LiteralArgumentBuilder command = (LiteralArgumentBuilder)Commands.func_197057_a((String)"show_land").requires(cs -> CommandManager.hasPerm(cs, perm));
        command = (LiteralArgumentBuilder)command.executes(ctx -> Show.execute((CommandSource)ctx.getSource()));
        commandDispatcher.register(command);
    }

    private static int execute(CommandSource source) throws CommandSyntaxException {
        ServerPlayerEntity player = source.func_197035_h();
        if (LandEventsHandler.EntityEventHandler.showLandSet.remove(player.func_110124_au())) {
            Essentials.config.sendFeedback(source, "thutessentials.team.landdisplay.unset", false, new Object[0]);
        } else if (LandEventsHandler.EntityEventHandler.showLandSet.add(player.func_110124_au())) {
            Essentials.config.sendFeedback(source, "thutessentials.team.landdisplay.set", false, new Object[0]);
        }
        return 0;
    }
}

