/*
 * Decompiled with CFR 0.152.
 */
package thut.essentials.commands.land.util;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import java.util.Map;
import net.minecraft.command.CommandSource;
import net.minecraft.command.Commands;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.event.ClickEvent;
import net.minecraft.util.text.event.HoverEvent;
import net.minecraftforge.server.permission.DefaultPermissionLevel;
import net.minecraftforge.server.permission.PermissionAPI;
import thut.essentials.Essentials;
import thut.essentials.commands.CommandManager;
import thut.essentials.commands.land.util.Members;
import thut.essentials.land.LandManager;

public class Teams {
    public static void register(CommandDispatcher<CommandSource> commandDispatcher) {
        String name = "team_teams";
        if (Essentials.config.commandBlacklist.contains("team_teams")) {
            return;
        }
        String perm = "command.team_teams";
        PermissionAPI.registerNode((String)"command.team_teams", (DefaultPermissionLevel)DefaultPermissionLevel.ALL, (String)"Can the player see the list of teams.");
        LiteralArgumentBuilder command = (LiteralArgumentBuilder)Commands.func_197057_a((String)"team_teams").requires(cs -> CommandManager.hasPerm(cs, perm));
        command = (LiteralArgumentBuilder)command.executes(ctx -> Teams.execute((CommandSource)ctx.getSource()));
        commandDispatcher.register(command);
    }

    private static int execute(CommandSource source) {
        Essentials.config.sendFeedback(source, "thutessentials.team.teams", false, new Object[0]);
        Map<String, LandManager.LandTeam> teamMap = LandManager.getInstance()._teamMap;
        for (String s : teamMap.keySet()) {
            LandManager.LandTeam team = teamMap.get(s);
            String emptyTip = "";
            String lastSeenTip = "[" + (source.func_197028_i().func_211150_az() - team.lastSeen) / 1000L * 3600L + "h]";
            if (team.member.size() == 0) {
                emptyTip = "(EMPTY)";
            }
            StringTextComponent message = new StringTextComponent(TextFormatting.AQUA + "[" + TextFormatting.YELLOW + s + TextFormatting.AQUA + "] " + emptyTip + " " + lastSeenTip);
            ClickEvent event = new ClickEvent(ClickEvent.Action.RUN_COMMAND, "/team_members " + s);
            ITextComponent tooltip = Members.getMembers(source.func_197028_i(), team, false);
            HoverEvent event2 = new HoverEvent(HoverEvent.Action.SHOW_TEXT, tooltip);
            message.func_150255_a(new Style());
            message.func_150256_b().func_150241_a(event);
            message.func_150256_b().func_150209_a(event2);
            source.func_197030_a((ITextComponent)message, false);
        }
        return 0;
    }
}

