/*
 * Decompiled with CFR 0.152.
 */
package thut.essentials.commands.misc;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.util.function.Predicate;
import net.minecraft.block.BlockState;
import net.minecraft.command.CommandSource;
import net.minecraft.command.Commands;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.World;
import net.minecraft.world.dimension.DimensionType;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.fml.LogicalSidedProvider;
import net.minecraftforge.server.permission.DefaultPermissionLevel;
import net.minecraftforge.server.permission.PermissionAPI;
import thut.essentials.Essentials;
import thut.essentials.commands.CommandManager;
import thut.essentials.events.MoveEvent;
import thut.essentials.util.Coordinate;
import thut.essentials.util.PlayerDataHandler;
import thut.essentials.util.PlayerMover;

public class Back {
    private static boolean registered = false;

    @SubscribeEvent
    public static void move(MoveEvent event) {
        if (Essentials.config.back_on_tp) {
            PlayerDataHandler.getCustomDataTag(event.getEntityLiving().func_189512_bd()).func_74783_a("prevPos", event.getPos());
        }
    }

    @SubscribeEvent
    public static void death(LivingDeathEvent event) {
        if (event.getEntityLiving() instanceof ServerPlayerEntity && Essentials.config.back_on_death) {
            BlockPos pos = event.getEntityLiving().func_180425_c();
            int[] loc = new int[]{pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p(), event.getEntityLiving().field_71093_bK.func_186068_a()};
            PlayerDataHandler.getCustomDataTag(event.getEntityLiving().func_189512_bd()).func_74783_a("prevPos", loc);
            PlayerDataHandler.saveCustomData(event.getEntityLiving().func_189512_bd());
        }
    }

    public static void register(CommandDispatcher<CommandSource> commandDispatcher) {
        String name = "back";
        if (Essentials.config.commandBlacklist.contains("back")) {
            return;
        }
        String perm = "command.back";
        PermissionAPI.registerNode((String)"command.back", (DefaultPermissionLevel)DefaultPermissionLevel.ALL, (String)"Can the player use /back");
        if (!registered) {
            MinecraftForge.EVENT_BUS.register(Back.class);
        }
        registered = true;
        LiteralArgumentBuilder command = (LiteralArgumentBuilder)Commands.func_197057_a((String)"back").requires(cs -> CommandManager.hasPerm(cs, perm));
        command = (LiteralArgumentBuilder)command.executes(ctx -> Back.execute((CommandSource)ctx.getSource()));
        commandDispatcher.register(command);
    }

    private static int execute(CommandSource source) throws CommandSyntaxException {
        long time;
        ServerPlayerEntity player = source.func_197035_h();
        CompoundNBT tag = PlayerDataHandler.getCustomDataTag((PlayerEntity)player);
        CompoundNBT tptag = tag.func_74775_l("tp");
        long last = tptag.func_74763_f("backDelay");
        if (last > (time = player.func_184102_h().func_71218_a(DimensionType.field_223227_a_).func_82737_E()) && Essentials.config.backReUseDelay > 0) {
            player.func_145747_a(Essentials.config.getMessage("thutessentials.tp.tosoon", new Object[0]));
            return 1;
        }
        if (tag.func_74764_b("prevPos")) {
            int[] pos = tag.func_74759_k("prevPos");
            Coordinate spot = Back.getBackSpot(pos);
            if (spot == null) {
                player.func_145747_a(Essentials.config.getMessage("thutessentials.back.noroom", new Object[0]));
                return 1;
            }
            Predicate<Entity> callback = t -> {
                if (!(t instanceof PlayerEntity)) {
                    return false;
                }
                PlayerDataHandler.getCustomDataTag(t.func_189512_bd()).func_82580_o("prevPos");
                tptag.func_74772_a("backDelay", time + (long)Essentials.config.backReUseDelay);
                tag.func_218657_a("tp", (INBT)tptag);
                PlayerDataHandler.saveCustomData((PlayerEntity)t);
                return true;
            };
            ITextComponent teleMess = Essentials.config.getMessage("thutessentials.back.succeed", new Object[0]);
            PlayerMover.setMove((PlayerEntity)player, Essentials.config.backActivateDelay, spot.dim, new BlockPos(spot.x, spot.y, spot.z), teleMess, PlayerMover.INTERUPTED, callback, false);
            return 0;
        }
        player.func_145747_a(Essentials.config.getMessage("thutessentials.back.noback", new Object[0]));
        return 1;
    }

    private static Coordinate getBackSpot(int[] pos) {
        Coordinate spot = new Coordinate(pos[0], pos[1], pos[2], pos[3]);
        MinecraftServer server = (MinecraftServer)LogicalSidedProvider.INSTANCE.get(LogicalSide.SERVER);
        ServerWorld world = server.func_71218_a(DimensionType.func_186069_a((int)pos[3]));
        if (world == null) {
            return null;
        }
        BlockPos check = new BlockPos(spot.x, spot.y, spot.z);
        if (Back.valid(check, (World)world)) {
            return spot;
        }
        int r = Essentials.config.backRangeCheck;
        for (int j = 0; j < r; ++j) {
            for (int i = 0; i < r; ++i) {
                for (int k = 0; k < r; ++k) {
                    spot = new Coordinate(pos[0] + i, pos[1] + j, pos[2] + k, pos[3]);
                    check = new BlockPos(spot.x, spot.y, spot.z);
                    if (Back.valid(check, (World)world)) {
                        return spot;
                    }
                    spot = new Coordinate(pos[0] - i, pos[1] + j, pos[2] - k, pos[3]);
                    check = new BlockPos(spot.x, spot.y, spot.z);
                    if (!Back.valid(check, (World)world)) continue;
                    return spot;
                }
            }
        }
        return null;
    }

    private static boolean valid(BlockPos pos, World world) {
        BlockState state1 = world.func_180495_p(pos);
        BlockState state2 = world.func_180495_p(pos.func_177984_a());
        boolean valid1 = state1 == null || !state1.func_185904_a().func_76220_a();
        boolean valid2 = state2 == null || !state2.func_185904_a().func_76220_a();
        return valid1 && valid2;
    }
}

