/*
 * Decompiled with CFR 0.152.
 */
package thut.essentials.commands.misc;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.util.function.Predicate;
import net.minecraft.block.BlockState;
import net.minecraft.command.CommandSource;
import net.minecraft.command.Commands;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.World;
import net.minecraft.world.dimension.DimensionType;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.fml.LogicalSidedProvider;
import net.minecraftforge.server.permission.DefaultPermissionLevel;
import net.minecraftforge.server.permission.PermissionAPI;
import thut.essentials.Essentials;
import thut.essentials.commands.CommandManager;
import thut.essentials.util.Coordinate;
import thut.essentials.util.PlayerDataHandler;
import thut.essentials.util.PlayerMover;

public class Bed {
    public static void register(CommandDispatcher<CommandSource> commandDispatcher) {
        String name = "bed";
        if (Essentials.config.commandBlacklist.contains("bed")) {
            return;
        }
        String perm = "command.bed";
        PermissionAPI.registerNode((String)"command.bed", (DefaultPermissionLevel)DefaultPermissionLevel.ALL, (String)"Can the player use /bed");
        LiteralArgumentBuilder command = (LiteralArgumentBuilder)Commands.func_197057_a((String)"bed").requires(cs -> CommandManager.hasPerm(cs, perm));
        command = (LiteralArgumentBuilder)command.executes(ctx -> Bed.execute((CommandSource)ctx.getSource()));
        commandDispatcher.register(command);
    }

    private static int execute(CommandSource source) throws CommandSyntaxException {
        long time;
        ServerPlayerEntity player = source.func_197035_h();
        CompoundNBT tag = PlayerDataHandler.getCustomDataTag((PlayerEntity)player);
        CompoundNBT tptag = tag.func_74775_l("tp");
        long last = tptag.func_74763_f("bedDelay");
        if (last > (time = player.func_184102_h().func_71218_a(DimensionType.field_223227_a_).func_82737_E()) && Essentials.config.bedReUseDelay > 0) {
            player.func_145747_a(Essentials.config.getMessage("thutessentials.tp.tosoon", new Object[0]));
            return 1;
        }
        Coordinate spot = Bed.getBedSpot((PlayerEntity)player);
        if (spot != null) {
            Predicate<Entity> callback = t -> {
                if (!(t instanceof PlayerEntity)) {
                    return false;
                }
                tptag.func_74772_a("bedDelay", time + (long)Essentials.config.bedReUseDelay);
                tag.func_218657_a("tp", (INBT)tptag);
                PlayerDataHandler.saveCustomData((PlayerEntity)t);
                return true;
            };
            ITextComponent teleMess = Essentials.config.getMessage("thutessentials.bed.succeed", new Object[0]);
            PlayerMover.setMove((PlayerEntity)player, Essentials.config.bedActivateDelay, spot.dim, new BlockPos(spot.x, spot.y, spot.z), teleMess, PlayerMover.INTERUPTED, callback, false);
            return 0;
        }
        player.func_145747_a(Essentials.config.getMessage("thutessentials.bed.nobed", new Object[0]));
        return 1;
    }

    private static Coordinate getBedSpot(PlayerEntity player) {
        DimensionType dim = player.field_71093_bK;
        BlockPos bed = player.getBedLocation(dim);
        if (bed == null) {
            dim = player.getSpawnDimension();
            bed = player.getBedLocation(dim);
        }
        if (bed == null) {
            return null;
        }
        Coordinate spot = new Coordinate(bed.func_177958_n(), bed.func_177956_o(), bed.func_177952_p(), dim.func_186068_a());
        MinecraftServer server = (MinecraftServer)LogicalSidedProvider.INSTANCE.get(LogicalSide.SERVER);
        ServerWorld world = server.func_71218_a(dim);
        if (world == null) {
            return null;
        }
        BlockPos check = new BlockPos(spot.x, spot.y, spot.z);
        if (Bed.valid(check, (World)world)) {
            return spot;
        }
        int r = Essentials.config.backRangeCheck;
        for (int j = 0; j < r; ++j) {
            for (int i = 0; i < r; ++i) {
                for (int k = 0; k < r; ++k) {
                    spot = new Coordinate(bed.func_177958_n() + i, bed.func_177956_o() + j, bed.func_177952_p() + k, dim.func_186068_a());
                    check = new BlockPos(spot.x, spot.y, spot.z);
                    if (Bed.valid(check, (World)world)) {
                        return spot;
                    }
                    spot = new Coordinate(bed.func_177958_n() - i, bed.func_177956_o() + j, bed.func_177952_p() - k, dim.func_186068_a());
                    check = new BlockPos(spot.x, spot.y, spot.z);
                    if (!Bed.valid(check, (World)world)) continue;
                    return spot;
                }
            }
        }
        return null;
    }

    private static boolean valid(BlockPos pos, World world) {
        BlockState state1 = world.func_180495_p(pos);
        BlockState state2 = world.func_180495_p(pos.func_177984_a());
        boolean valid1 = state1 == null || !state1.func_185904_a().func_76220_a();
        boolean valid2 = state2 == null || !state2.func_185904_a().func_76220_a();
        return valid1 && valid2;
    }
}

