/*
 * Decompiled with CFR 0.152.
 */
package thut.essentials.commands.misc;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.util.List;
import net.minecraft.command.CommandSource;
import net.minecraft.command.Commands;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.dimension.DimensionType;
import net.minecraftforge.server.permission.DefaultPermissionLevel;
import net.minecraftforge.server.permission.IPermissionHandler;
import net.minecraftforge.server.permission.PermissionAPI;
import net.minecraftforge.server.permission.context.IContext;
import net.minecraftforge.server.permission.context.PlayerContext;
import thut.essentials.Essentials;
import thut.essentials.commands.CommandManager;
import thut.essentials.economy.EconomyManager;
import thut.essentials.util.KitManager;
import thut.essentials.util.PlayerDataHandler;

public class Kits {
    public static void register(CommandDispatcher<CommandSource> commandDispatcher) {
        LiteralArgumentBuilder command;
        String perm;
        String name = "kits";
        if (!Essentials.config.commandBlacklist.contains(name)) {
            perm = "command." + name;
            PermissionAPI.registerNode((String)perm, (DefaultPermissionLevel)DefaultPermissionLevel.ALL, (String)("Can the player use /" + name));
            command = (LiteralArgumentBuilder)Commands.func_197057_a((String)name).requires(cs -> CommandManager.hasPerm(cs, perm));
            command = (LiteralArgumentBuilder)command.executes(ctx -> Kits.kits((CommandSource)ctx.getSource()));
            commandDispatcher.register(command);
        }
        if (!Essentials.config.commandBlacklist.contains(name = "kit")) {
            perm = "command." + name;
            PermissionAPI.registerNode((String)perm, (DefaultPermissionLevel)DefaultPermissionLevel.ALL, (String)("Can the player use /" + name));
            command = (LiteralArgumentBuilder)Commands.func_197057_a((String)name).requires(cs -> CommandManager.hasPerm(cs, perm));
            command = (LiteralArgumentBuilder)command.then(Commands.func_197056_a((String)"kit_name", (ArgumentType)StringArgumentType.string()).executes(ctx -> Kits.execute((CommandSource)ctx.getSource(), StringArgumentType.getString((CommandContext)ctx, (String)"kit_name"))));
            commandDispatcher.register(command);
            command = (LiteralArgumentBuilder)command.executes(ctx -> Kits.execute((CommandSource)ctx.getSource(), null));
            commandDispatcher.register(command);
        }
        if (!Essentials.config.commandBlacklist.contains(name = "reload_kits")) {
            perm = "command." + name;
            PermissionAPI.registerNode((String)perm, (DefaultPermissionLevel)DefaultPermissionLevel.OP, (String)("Can the player use /" + name));
            command = (LiteralArgumentBuilder)Commands.func_197057_a((String)name).requires(cs -> CommandManager.hasPerm(cs, perm));
            command = (LiteralArgumentBuilder)command.executes(ctx -> Kits.reload((CommandSource)ctx.getSource()));
            commandDispatcher.register(command);
        }
    }

    private static int reload(CommandSource source) throws CommandSyntaxException {
        KitManager.init();
        Essentials.config.sendFeedback(source, "thutessentials.kits.reloaded", true, new Object[0]);
        return 0;
    }

    private static int kits(CommandSource source) throws CommandSyntaxException {
        ServerPlayerEntity player = source.func_197035_h();
        KitManager.sendKitsList(player);
        return 0;
    }

    private static int execute(CommandSource source, String warpName) throws CommandSyntaxException {
        List<ItemStack> stacks;
        ServerPlayerEntity player = source.func_197035_h();
        MinecraftServer server = player.func_184102_h();
        int delay = Essentials.config.kitReuseDelay;
        String kitTag = "kitTime";
        String perm = "thutessentials.kit.default";
        if (warpName != null) {
            KitManager.KitSet kit = KitManager.kits.get(warpName);
            if (kit == null) {
                Essentials.config.sendError(source, "thutessentials.kits.no_kit", new Object[0]);
                return 1;
            }
            perm = "thutessentials.kit." + warpName;
            kitTag = "kitTime_" + warpName;
            delay = kit.cooldown;
            stacks = kit.stacks;
        } else {
            stacks = KitManager.kit;
        }
        IPermissionHandler manager = PermissionAPI.getPermissionHandler();
        PlayerContext context = new PlayerContext((PlayerEntity)player);
        if (!manager.hasPermission(player.func_146103_bH(), perm, (IContext)context)) {
            Essentials.config.sendError(source, "thutessentials.kits.noperms", new Object[0]);
            return 1;
        }
        long kitTime = PlayerDataHandler.getCustomDataTag((PlayerEntity)player).func_74763_f(kitTag);
        if (delay <= 0 && kitTime != 0L || server.func_71218_a(DimensionType.field_223227_a_).func_82737_E() < kitTime) {
            Essentials.config.sendError(source, "thutessentials.kits.too_soon", new Object[0]);
            return 1;
        }
        for (ItemStack stack : stacks) {
            EconomyManager.giveItem(player, stack.func_77946_l());
            PlayerDataHandler.getCustomDataTag((PlayerEntity)player).func_74772_a(kitTag, server.func_71218_a(DimensionType.field_223227_a_).func_82737_E() + (long)delay);
            PlayerDataHandler.saveCustomData((PlayerEntity)player);
        }
        return 0;
    }
}

