/*
 * Decompiled with CFR 0.152.
 */
package thut.essentials.commands.misc;

import com.mojang.authlib.GameProfile;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import java.util.Collection;
import net.minecraft.command.CommandSource;
import net.minecraft.command.Commands;
import net.minecraft.command.arguments.GameProfileArgument;
import net.minecraft.server.MinecraftServer;
import net.minecraftforge.server.permission.DefaultPermissionLevel;
import net.minecraftforge.server.permission.PermissionAPI;
import thut.essentials.Essentials;
import thut.essentials.commands.CommandManager;
import thut.essentials.util.NameManager;

public class Nick {
    public static void register(CommandDispatcher<CommandSource> commandDispatcher, MinecraftServer server) {
        String name = "nick";
        String perm = "command.nick";
        PermissionAPI.registerNode((String)"command.nick", (DefaultPermissionLevel)DefaultPermissionLevel.OP, (String)"Can the player use /nick");
        if (Essentials.config.commandBlacklist.contains("nick")) {
            return;
        }
        LiteralArgumentBuilder command = (LiteralArgumentBuilder)Commands.func_197057_a((String)"nick").requires(cs -> CommandManager.hasPerm(cs, perm));
        command = (LiteralArgumentBuilder)command.then(Commands.func_197056_a((String)"player", (ArgumentType)GameProfileArgument.func_197108_a()).then(Commands.func_197056_a((String)"nick", (ArgumentType)StringArgumentType.greedyString()).executes(ctx -> Nick.execute((CommandSource)ctx.getSource(), GameProfileArgument.func_197109_a((CommandContext)ctx, (String)"player"), StringArgumentType.getString((CommandContext)ctx, (String)"nick")))));
        commandDispatcher.register(command);
        NameManager.init(server);
    }

    private static int execute(CommandSource source, Collection<GameProfile> target, String nick) {
        if (nick.length() > 16) {
            nick = nick.substring(0, 16);
        }
        for (GameProfile p : target) {
            NameManager.setName(nick, p, source.func_197028_i());
        }
        return 0;
    }
}

