/*
 * Decompiled with CFR 0.152.
 */
package thut.essentials.commands.misc;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.util.Random;
import java.util.function.Predicate;
import net.minecraft.block.BlockState;
import net.minecraft.command.CommandSource;
import net.minecraft.command.Commands;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.World;
import net.minecraft.world.dimension.DimensionType;
import net.minecraft.world.gen.Heightmap;
import net.minecraftforge.server.permission.DefaultPermissionLevel;
import net.minecraftforge.server.permission.PermissionAPI;
import thut.essentials.Essentials;
import thut.essentials.commands.CommandManager;
import thut.essentials.util.Coordinate;
import thut.essentials.util.PlayerDataHandler;
import thut.essentials.util.PlayerMover;

public class RTP {
    public static BlockPos centre = null;

    public static void register(CommandDispatcher<CommandSource> commandDispatcher) {
        String name = "rtp";
        if (Essentials.config.commandBlacklist.contains("rtp")) {
            return;
        }
        String perm = "command.rtp";
        PermissionAPI.registerNode((String)"command.rtp", (DefaultPermissionLevel)DefaultPermissionLevel.ALL, (String)"Can the player use /rtp");
        LiteralArgumentBuilder command = (LiteralArgumentBuilder)Commands.func_197057_a((String)"rtp").requires(cs -> CommandManager.hasPerm(cs, perm));
        command = (LiteralArgumentBuilder)command.executes(ctx -> RTP.execute((CommandSource)ctx.getSource()));
        commandDispatcher.register(command);
    }

    private static int execute(CommandSource source) throws CommandSyntaxException {
        long time;
        ServerPlayerEntity player = source.func_197035_h();
        CompoundNBT tag = PlayerDataHandler.getCustomDataTag((PlayerEntity)player);
        CompoundNBT tptag = tag.func_74775_l("tp");
        long last = tptag.func_74763_f("rtpDelay");
        if (last > (time = player.func_184102_h().func_71218_a(DimensionType.field_223227_a_).func_82737_E()) && Essentials.config.rtpReUseDelay > 0) {
            player.func_145747_a(Essentials.config.getMessage("thutessentials.tp.tosoon", new Object[0]));
            return 1;
        }
        Coordinate spot = RTP.getRTPSpot((PlayerEntity)player);
        if (spot != null) {
            Predicate<Entity> callback = t -> {
                if (!(t instanceof PlayerEntity)) {
                    return false;
                }
                tptag.func_74772_a("bedDelay", time + (long)Essentials.config.rtpReUseDelay);
                tag.func_218657_a("tp", (INBT)tptag);
                PlayerDataHandler.saveCustomData((PlayerEntity)t);
                return true;
            };
            ITextComponent teleMess = Essentials.config.getMessage("thutessentials.rtp.succeed", new Object[0]);
            PlayerMover.setMove((PlayerEntity)player, Essentials.config.rtpActivateDelay, spot.dim, new BlockPos(spot.x, spot.y, spot.z), teleMess, PlayerMover.INTERUPTED, callback, false);
            return 0;
        }
        player.func_145747_a(Essentials.config.getMessage("thutessentials.rtp.fail", new Object[0]));
        return 1;
    }

    private static Coordinate getRTPSpot(PlayerEntity player) {
        int z0;
        World world = player.func_130014_f_();
        Random rand = new Random();
        int dx = rand.nextInt(Essentials.config.rtpDistance) * (rand.nextBoolean() ? 1 : -1);
        int dz = rand.nextInt(Essentials.config.rtpDistance) * (rand.nextBoolean() ? 1 : -1);
        int x0 = centre == null ? world.func_175694_M().func_177958_n() : centre.func_177958_n();
        int n = z0 = centre == null ? world.func_175694_M().func_177952_p() : centre.func_177952_p();
        if (Essentials.config.rtpPlayerCentred) {
            x0 = player.func_180425_c().func_177958_n();
            z0 = player.func_180425_c().func_177952_p();
        }
        int x = x0 + dx;
        int z = z0 + dz;
        world.func_217349_x(new BlockPos(x, 0, z));
        int y = world.func_201676_a(Heightmap.Type.MOTION_BLOCKING, x, z);
        DimensionType dim = player.field_71093_bK;
        Coordinate spot = new Coordinate(x, y + 1, z, dim.func_186068_a());
        BlockPos check = new BlockPos(spot.x, spot.y, spot.z);
        if (RTP.valid(check, world)) {
            return spot;
        }
        int r = Essentials.config.backRangeCheck;
        for (int j = 0; j < r; ++j) {
            for (int i = 0; i < r; ++i) {
                for (int k = 0; k < r; ++k) {
                    spot = new Coordinate(x + i, y + j, z + k, dim.func_186068_a());
                    check = new BlockPos(spot.x, spot.y, spot.z);
                    if (RTP.valid(check, world)) {
                        return spot;
                    }
                    spot = new Coordinate(x - i, y + j, z - k, dim.func_186068_a());
                    check = new BlockPos(spot.x, spot.y, spot.z);
                    if (!RTP.valid(check, world)) continue;
                    return spot;
                }
            }
        }
        return null;
    }

    private static boolean valid(BlockPos pos, World world) {
        BlockState state1 = world.func_180495_p(pos);
        BlockState state2 = world.func_180495_p(pos.func_177984_a());
        boolean valid1 = state1 == null || !state1.func_185904_a().func_76220_a();
        boolean valid2 = state2 == null || !state2.func_185904_a().func_76220_a();
        return valid1 && valid2;
    }
}

