/*
 * Decompiled with CFR 0.152.
 */
package thut.essentials.commands.misc;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import net.minecraft.command.CommandSource;
import net.minecraft.command.Commands;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.dimension.DimensionType;
import net.minecraftforge.server.permission.DefaultPermissionLevel;
import net.minecraftforge.server.permission.PermissionAPI;
import thut.essentials.Essentials;
import thut.essentials.commands.CommandManager;
import thut.essentials.util.PlayerDataHandler;
import thut.essentials.util.PlayerMover;

public class Spawn {
    public static void register(CommandDispatcher<CommandSource> commandDispatcher) {
        String name = "spawn";
        if (Essentials.config.commandBlacklist.contains("spawn")) {
            return;
        }
        String perm = "command.spawn";
        PermissionAPI.registerNode((String)"command.spawn", (DefaultPermissionLevel)DefaultPermissionLevel.ALL, (String)"Can the player use /spawn");
        LiteralArgumentBuilder command = (LiteralArgumentBuilder)Commands.func_197057_a((String)"spawn").requires(cs -> CommandManager.hasPerm(cs, perm));
        command = (LiteralArgumentBuilder)command.executes(ctx -> Spawn.execute((CommandSource)ctx.getSource()));
        commandDispatcher.register(command);
    }

    private static int execute(CommandSource source) throws CommandSyntaxException {
        long time;
        ServerPlayerEntity player = source.func_197035_h();
        CompoundNBT tag = PlayerDataHandler.getCustomDataTag((PlayerEntity)player);
        CompoundNBT tptag = tag.func_74775_l("tp");
        long last = tptag.func_74763_f("spawnDelay");
        if (last > (time = player.func_184102_h().func_71218_a(DimensionType.field_223227_a_).func_82737_E()) && Essentials.config.spawnReUseDelay > 0L) {
            player.func_145747_a(CommandManager.makeFormattedComponent("thutessentials.tp.tosoon", TextFormatting.RED, false));
            return 1;
        }
        MinecraftServer server = player.func_184102_h();
        BlockPos spawn = server.func_71218_a(Essentials.config.spawnDimension).func_175694_M();
        ITextComponent teleMess = CommandManager.makeFormattedComponent("thutessentials.spawn.succeed");
        PlayerMover.setMove((PlayerEntity)player, Essentials.config.spawnActivateDelay, Essentials.config.spawnDimension.func_186068_a(), spawn, teleMess, PlayerMover.INTERUPTED);
        tptag.func_74772_a("spawnDelay", time + Essentials.config.spawnReUseDelay);
        tag.func_218657_a("tp", (INBT)tptag);
        PlayerDataHandler.saveCustomData((PlayerEntity)player);
        return 0;
    }
}

