/*
 * Decompiled with CFR 0.152.
 */
package thut.essentials.commands.structures;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.suggestion.SuggestionProvider;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import net.minecraft.block.BlockState;
import net.minecraft.command.CommandSource;
import net.minecraft.command.Commands;
import net.minecraft.command.ISuggestionProvider;
import net.minecraft.crash.CrashReport;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SharedSeedRandom;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.MutableBoundingBox;
import net.minecraft.util.palette.UpgradeData;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.BiomeManager;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.chunk.ChunkPrimer;
import net.minecraft.world.chunk.ChunkStatus;
import net.minecraft.world.chunk.IChunk;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.GenerationStage;
import net.minecraft.world.gen.Heightmap;
import net.minecraft.world.gen.WorldGenRegion;
import net.minecraft.world.gen.feature.ConfiguredFeature;
import net.minecraft.world.gen.feature.Feature;
import net.minecraft.world.gen.feature.structure.Structure;
import net.minecraft.world.gen.feature.structure.StructurePiece;
import net.minecraft.world.gen.feature.structure.StructureStart;
import net.minecraft.world.gen.feature.template.TemplateManager;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistryEntry;
import net.minecraftforge.server.permission.DefaultPermissionLevel;
import net.minecraftforge.server.permission.PermissionAPI;
import thut.essentials.Essentials;
import thut.essentials.commands.CommandManager;
import thut.essentials.util.world.WorldGenRegionWrapper;
import thut.essentials.util.world.WorldStructures;

public class Structuregen {
    private static SuggestionProvider<CommandSource> SUGGEST_NAMES = (ctx, sb) -> {
        ArrayList opts = Lists.newArrayList();
        for (Map.Entry loc : ForgeRegistries.FEATURES.getEntries()) {
            if (!(loc.getValue() instanceof Structure)) continue;
            opts.add(((ResourceLocation)loc.getKey()).toString());
        }
        return ISuggestionProvider.func_197005_b((Iterable)opts, (SuggestionsBuilder)sb);
    };

    public static void register(CommandDispatcher<CommandSource> commandDispatcher) {
        String name = "gen_structure";
        String perm = "command.gen_structure";
        PermissionAPI.registerNode((String)"command.gen_structure", (DefaultPermissionLevel)DefaultPermissionLevel.OP, (String)"Can the player use /gen_structure");
        if (Essentials.config.commandBlacklist.contains("gen_structure")) {
            return;
        }
        LiteralArgumentBuilder command = (LiteralArgumentBuilder)Commands.func_197057_a((String)"gen_structure").requires(cs -> CommandManager.hasPerm(cs, perm));
        command.then(Commands.func_197057_a((String)"reset").executes(ctx -> Structuregen.execute_reset((CommandSource)ctx.getSource(), 1)));
        commandDispatcher.register(command);
        command = (LiteralArgumentBuilder)Commands.func_197057_a((String)"gen_structure").requires(cs -> CommandManager.hasPerm(cs, perm));
        command.then(Commands.func_197057_a((String)"reset").then(Commands.func_197056_a((String)"radius", (ArgumentType)IntegerArgumentType.integer()).executes(ctx -> Structuregen.execute_reset((CommandSource)ctx.getSource(), IntegerArgumentType.getInteger((CommandContext)ctx, (String)"radius")))));
        commandDispatcher.register(command);
        command = (LiteralArgumentBuilder)Commands.func_197057_a((String)"gen_structure").requires(cs -> CommandManager.hasPerm(cs, perm));
        command.then(Commands.func_197056_a((String)"structure", (ArgumentType)StringArgumentType.greedyString()).suggests(SUGGEST_NAMES).executes(ctx -> Structuregen.execute_generate((CommandSource)ctx.getSource(), StringArgumentType.getString((CommandContext)ctx, (String)"structure"))));
        commandDispatcher.register(command);
    }

    public static void regenerateChunks(CommandSource source, List<IChunk> primers, List<Chunk> originals, WorldGenRegionWrapper worldRegion, int minY, int maxY, boolean doStructures) {
        BlockPos pos;
        ServerWorld worldIn = worldRegion.field_201689_f;
        TemplateManager templateManager = worldIn.func_217485_w().func_186340_h();
        ChunkGenerator generator = worldIn.func_72863_F().field_186029_c;
        BiomeManager bman = worldIn.func_225523_d_();
        int s = 0;
        source.func_197030_a((ITextComponent)new StringTextComponent("Initializing Chunks " + s++), false);
        for (IChunk c : primers) {
            generator.func_227058_a_(bman, c, generator, templateManager);
        }
        source.func_197030_a((ITextComponent)new StringTextComponent("Initializing Chunks " + s++), false);
        for (IChunk c : primers) {
            generator.func_222528_a((IWorld)worldRegion, c);
        }
        source.func_197030_a((ITextComponent)new StringTextComponent("Initializing Chunks " + s++), false);
        for (IChunk c : primers) {
            generator.func_222539_a(c);
        }
        source.func_197030_a((ITextComponent)new StringTextComponent("Initializing Chunks " + s++), false);
        for (IChunk c : primers) {
            generator.func_222537_b((IWorld)worldRegion, c);
        }
        source.func_197030_a((ITextComponent)new StringTextComponent("Initializing Chunks " + s++), false);
        for (IChunk c : primers) {
            generator.func_225551_a_((WorldGenRegion)worldRegion, c);
        }
        source.func_197030_a((ITextComponent)new StringTextComponent("Initializing Chunks " + s++), false);
        for (IChunk c : primers) {
            generator.func_225550_a_(bman, c, GenerationStage.Carving.AIR);
        }
        source.func_197030_a((ITextComponent)new StringTextComponent("Initializing Chunks " + s++), false);
        for (IChunk c : primers) {
            generator.func_225550_a_(bman, c, GenerationStage.Carving.LIQUID);
        }
        source.func_197030_a((ITextComponent)new StringTextComponent("Initializing Chunks " + s++), false);
        MutableBoundingBox box = MutableBoundingBox.func_78887_a();
        box.field_78895_b = minY;
        box.field_78894_e = maxY;
        LazyOptional structs = worldIn.getCapability(WorldStructures.CAPABILITY);
        for (int i = 0; i < primers.size(); ++i) {
            ChunkPrimer chunkPrimer = (ChunkPrimer)primers.get(i);
            Chunk o = originals.get(i);
            ChunkPos p = o.func_76632_l();
            box.field_78897_a = p.func_180334_c();
            box.field_78896_c = p.func_180333_d();
            box.field_78893_d = p.func_180332_e();
            box.field_78892_f = p.func_180330_f();
            structs.ifPresent(holder -> holder.removeStructures(null, box));
            for (int y = minY; y < maxY; ++y) {
                for (int x = box.field_78897_a; x <= box.field_78893_d; ++x) {
                    for (int z = box.field_78896_c; z <= box.field_78892_f; ++z) {
                        pos = new BlockPos(x, y, z);
                        BlockState newstate = chunkPrimer.func_180495_p(pos);
                        worldIn.func_180501_a(pos, newstate, 35);
                    }
                }
            }
            for (CompoundNBT compoundnbt : chunkPrimer.func_201652_l()) {
                EntityType.func_220335_a((CompoundNBT)compoundnbt, (World)worldIn, p_217325_1_ -> {
                    o.func_76612_a(p_217325_1_);
                    return p_217325_1_;
                });
            }
            for (TileEntity tileentity : chunkPrimer.func_201627_k().values()) {
                o.func_150813_a(tileentity);
            }
            o.func_201612_a(chunkPrimer.func_201609_c());
            o.func_201606_b(chunkPrimer.func_201604_d());
            for (Map.Entry entry : chunkPrimer.func_217311_f()) {
                if (!ChunkStatus.field_222617_m.func_222595_h().contains(entry.getKey())) continue;
                o.func_217303_b((Heightmap.Type)entry.getKey()).func_202268_a(((Heightmap)entry.getValue()).func_202269_a());
            }
            o.func_217305_b(chunkPrimer.func_217310_r());
            o.func_76630_e();
        }
        source.func_197030_a((ITextComponent)new StringTextComponent("Regenerating Features and Structures"), false);
        for (IChunk iChunk : primers) {
            ChunkPos cpos = iChunk.func_76632_l();
            int cx = cpos.field_77276_a;
            int cj = cpos.field_77275_b;
            int k = cx * 16;
            int l = cj * 16;
            pos = new BlockPos(k, 0, l);
            Biome biome = bman.func_226836_a_(pos.func_177982_a(8, 8, 8));
            SharedSeedRandom random = new SharedSeedRandom();
            long seed = random.func_202424_a(worldRegion.func_72905_C(), k, l);
            for (GenerationStage.Decoration stage : GenerationStage.Decoration.values()) {
                try {
                    int i = 0;
                    for (ConfiguredFeature feature : biome.func_203607_a(stage)) {
                        if (!doStructures && feature.field_222737_a instanceof Structure) {
                            ++i;
                            continue;
                        }
                        random.func_202426_b(seed, i, stage.ordinal());
                        try {
                            feature.func_222734_a((IWorld)worldRegion, generator, (Random)random, pos);
                        }
                        catch (Exception exception) {
                            CrashReport crashreport = CrashReport.func_85055_a((Throwable)exception, (String)"Feature placement");
                            crashreport.func_85058_a("Feature").func_71507_a("Id", (Object)ForgeRegistries.FEATURES.getKey((IForgeRegistryEntry)feature.field_222737_a)).func_189529_a("Description", () -> feature.field_222737_a.toString());
                            Essentials.LOGGER.error(crashreport.func_71502_e());
                        }
                        ++i;
                    }
                }
                catch (Exception exception) {
                    Essentials.LOGGER.error((Object)exception);
                }
            }
        }
    }

    private static int execute_reset(CommandSource source, int radius) throws CommandSyntaxException {
        ServerPlayerEntity player = source.func_197035_h();
        Chunk chunk = player.func_130014_f_().func_175726_f(player.func_180425_c());
        ServerWorld worldIn = player.func_71121_q();
        int ds = radius;
        ChunkPos chunkpos = chunk.func_76632_l();
        ArrayList primers_for_starts = Lists.newArrayList();
        HashMap all_primers = Maps.newHashMap();
        ArrayList primers = Lists.newArrayList();
        ArrayList originals = Lists.newArrayList();
        int mx = chunkpos.field_77276_a;
        int mz = chunkpos.field_77275_b;
        int pad = Math.max(10, ds);
        for (int x = mx - ds - pad; x <= mx + ds + pad; ++x) {
            for (int z = mz - ds - pad; z <= mz + ds + pad; ++z) {
                ChunkPos pos = new ChunkPos(x, z);
                ChunkPrimer chunk2 = new ChunkPrimer(pos, UpgradeData.field_196994_a);
                primers_for_starts.add(chunk2);
                all_primers.put(pos, chunk2);
                if (x < mx - ds || x > mx + ds || z < mz - ds || z > mz + ds) continue;
                chunk = worldIn.func_212866_a_(x, z);
                primers.add(chunk2);
                originals.add(chunk);
            }
        }
        WorldGenRegionWrapper worldRegion = new WorldGenRegionWrapper(worldIn, primers_for_starts);
        Structuregen.regenerateChunks(source, primers, originals, worldRegion, 0, chunk.func_217301_I(), true);
        source.func_197030_a((ITextComponent)new StringTextComponent("Done"), false);
        return 0;
    }

    private static int execute_generate(CommandSource source, String structname) throws CommandSyntaxException {
        ServerPlayerEntity player = source.func_197035_h();
        Chunk chunk = player.func_130014_f_().func_175726_f(player.func_180425_c());
        ServerWorld worldIn = player.func_71121_q();
        TemplateManager templateManager = worldIn.func_217485_w().func_186340_h();
        ResourceLocation key = new ResourceLocation(structname);
        Feature feat = (Feature)ForgeRegistries.FEATURES.getValue(key);
        if (feat instanceof Structure) {
            Structure structure = (Structure)feat;
            ChunkGenerator generator = worldIn.func_72863_F().field_186029_c;
            ChunkPos chunkpos = chunk.func_76632_l();
            StructureStart start = structure.func_214557_a().create(structure, chunkpos.field_77276_a, chunkpos.field_77275_b, MutableBoundingBox.func_78887_a(), 0, generator.func_202089_c());
            Biome biome = worldIn.func_226691_t_(player.func_180425_c());
            ArrayList primers = Lists.newArrayList();
            ArrayList originals = Lists.newArrayList();
            start.func_214625_a(generator, templateManager, chunkpos.field_77276_a, chunkpos.field_77275_b, biome);
            SharedSeedRandom rand = new SharedSeedRandom(generator.func_202089_c());
            rand.func_202425_c(generator.func_202089_c(), chunkpos.field_77276_a, chunkpos.field_77275_b);
            MutableBoundingBox box = start.func_75071_a();
            int dx = box.field_78893_d - box.field_78897_a;
            int dz = box.field_78892_f - box.field_78896_c;
            int mx = dx / 2 + box.field_78897_a >> 4;
            int mz = dz / 2 + box.field_78896_c >> 4;
            int ds = Math.max(dx, dz) >> 4;
            ArrayList primers_for_starts = Lists.newArrayList();
            HashMap all_primers = Maps.newHashMap();
            chunkpos = new ChunkPos(mx, mz);
            int pad = Math.max(10, ds);
            for (int x = mx - ds - pad; x <= mx + ds + pad; ++x) {
                for (int z = mz - ds - pad; z <= mz + ds + pad; ++z) {
                    ChunkPos pos = new ChunkPos(x, z);
                    ChunkPrimer chunk2 = new ChunkPrimer(pos, UpgradeData.field_196994_a);
                    primers_for_starts.add(chunk2);
                    all_primers.put(pos, chunk2);
                    if (x < mx - ds || x > mx + ds || z < mz - ds || z > mz + ds) continue;
                    chunk = worldIn.func_212866_a_(x, z);
                    primers.add(chunk2);
                    originals.add(chunk);
                }
            }
            WorldGenRegionWrapper worldRegion = new WorldGenRegionWrapper(worldIn, primers_for_starts);
            Structuregen.regenerateChunks(source, primers, originals, worldRegion, box.field_78895_b, box.field_78894_e + 1, true);
            source.func_197030_a((ITextComponent)new StringTextComponent("Generating Requested Structure"), false);
            LazyOptional structs = worldIn.getCapability(WorldStructures.CAPABILITY);
            structs.ifPresent(holder -> {
                for (StructurePiece p : start.func_186161_c()) {
                    holder.putStructure(key, p.func_74874_b());
                }
            });
            start.func_225565_a_((IWorld)worldRegion, generator, (Random)rand, box, chunkpos);
            source.func_197030_a((ITextComponent)new StringTextComponent("Done"), false);
            return 0;
        }
        return 0;
    }
}

