/*
 * Decompiled with CFR 0.152.
 */
package thut.essentials.commands.tpa;

import com.google.common.collect.Lists;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.suggestion.SuggestionProvider;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import java.util.UUID;
import net.minecraft.command.CommandSource;
import net.minecraft.command.Commands;
import net.minecraft.command.ISuggestionProvider;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.server.permission.DefaultPermissionLevel;
import net.minecraftforge.server.permission.PermissionAPI;
import thut.essentials.Essentials;
import thut.essentials.commands.CommandManager;
import thut.essentials.util.PlayerDataHandler;
import thut.essentials.util.PlayerMover;

public class TpAccept {
    private static SuggestionProvider<CommandSource> SUGGEST = (ctx, sb) -> ISuggestionProvider.func_197005_b((Iterable)Lists.newArrayList((Object[])new String[]{"accept", "deny"}), (SuggestionsBuilder)sb);

    public static void register(CommandDispatcher<CommandSource> commandDispatcher) {
        String name = "tpaccept";
        if (Essentials.config.commandBlacklist.contains("tpaccept")) {
            return;
        }
        String perm = "command.tpaccept";
        PermissionAPI.registerNode((String)"command.tpaccept", (DefaultPermissionLevel)DefaultPermissionLevel.ALL, (String)"Can the player use /tpaccept");
        LiteralArgumentBuilder command = (LiteralArgumentBuilder)Commands.func_197057_a((String)"tpaccept").requires(cs -> CommandManager.hasPerm(cs, perm));
        command = (LiteralArgumentBuilder)command.then(Commands.func_197056_a((String)"uuid", (ArgumentType)StringArgumentType.string()).then(Commands.func_197056_a((String)"accept/deny", (ArgumentType)StringArgumentType.string()).suggests(SUGGEST).executes(ctx -> TpAccept.execute((CommandSource)ctx.getSource(), StringArgumentType.getString((CommandContext)ctx, (String)"uuid"), StringArgumentType.getString((CommandContext)ctx, (String)"accept/deny")))));
        commandDispatcher.register(command);
    }

    private static int execute(CommandSource source, String uuid, String option) throws CommandSyntaxException {
        ServerPlayerEntity player = source.func_197035_h();
        CompoundNBT tag = PlayerDataHandler.getCustomDataTag((PlayerEntity)player);
        CompoundNBT tpaTag = tag.func_74775_l("tpa");
        String requestor = tpaTag.func_74779_i("R");
        if (!requestor.equals(uuid)) {
            return 1;
        }
        tpaTag.func_82580_o("R");
        tag.func_218657_a("tpa", (INBT)tpaTag);
        MinecraftServer server = player.func_184102_h();
        PlayerDataHandler.saveCustomData((PlayerEntity)player);
        ServerPlayerEntity target = server.func_184103_al().func_177451_a(UUID.fromString(uuid));
        if (option.equals("accept")) {
            target.func_145747_a(CommandManager.makeFormattedComponent("thutessentials.tpa.accepted_user", TextFormatting.GREEN, true));
            player.func_145747_a(CommandManager.makeFormattedComponent("thutessentials.tpa.accepted_target", TextFormatting.GREEN, true));
            PlayerMover.setMove((PlayerEntity)target, Essentials.config.tpaActivateDelay, player.field_71093_bK.func_186068_a(), player.func_180425_c(), null, PlayerMover.INTERUPTED);
        } else if (option.equals("deny")) {
            target.func_145747_a(CommandManager.makeFormattedComponent("thutessentials.tpa.denied_user", TextFormatting.RED, true));
            player.func_145747_a(CommandManager.makeFormattedComponent("thutessentials.tpa.denied_target", TextFormatting.RED, true));
        }
        return 0;
    }
}

