/*
 * Decompiled with CFR 0.152.
 */
package thut.essentials.commands.tpa;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import net.minecraft.command.CommandSource;
import net.minecraft.command.Commands;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.server.permission.DefaultPermissionLevel;
import net.minecraftforge.server.permission.PermissionAPI;
import thut.essentials.Essentials;
import thut.essentials.commands.CommandManager;
import thut.essentials.util.PlayerDataHandler;

public class TpToggle {
    public static void register(CommandDispatcher<CommandSource> commandDispatcher) {
        String name = "tptoggle";
        if (Essentials.config.commandBlacklist.contains("tptoggle")) {
            return;
        }
        String perm = "command.tptoggle";
        PermissionAPI.registerNode((String)"command.tptoggle", (DefaultPermissionLevel)DefaultPermissionLevel.ALL, (String)"Can the player use /tptoggle");
        LiteralArgumentBuilder command = (LiteralArgumentBuilder)Commands.func_197057_a((String)"tptoggle").requires(cs -> CommandManager.hasPerm(cs, perm));
        command = (LiteralArgumentBuilder)command.executes(ctx -> TpToggle.execute((CommandSource)ctx.getSource()));
        commandDispatcher.register(command);
    }

    private static int execute(CommandSource source) throws CommandSyntaxException {
        ServerPlayerEntity player = source.func_197035_h();
        CompoundNBT tag = PlayerDataHandler.getCustomDataTag((PlayerEntity)player);
        CompoundNBT tpaTag = tag.func_74775_l("tpa");
        boolean ignore = !tpaTag.func_74767_n("ignore");
        tpaTag.func_74757_a("ignore", ignore);
        tag.func_218657_a("tpa", (INBT)tpaTag);
        PlayerDataHandler.saveCustomData((PlayerEntity)player);
        player.func_145747_a(CommandManager.makeFormattedComponent("thutessentials.tpa.ignoreset" + ignore, TextFormatting.DARK_GREEN, true));
        return 0;
    }
}

