/*
 * Decompiled with CFR 0.152.
 */
package thut.essentials.commands.tpa;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import net.minecraft.command.CommandSource;
import net.minecraft.command.Commands;
import net.minecraft.command.arguments.EntityArgument;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.dimension.DimensionType;
import net.minecraftforge.server.permission.DefaultPermissionLevel;
import net.minecraftforge.server.permission.PermissionAPI;
import thut.essentials.Essentials;
import thut.essentials.commands.CommandManager;
import thut.essentials.util.PlayerDataHandler;

public class Tpa {
    public static void register(CommandDispatcher<CommandSource> commandDispatcher) {
        String name = "tpa";
        if (Essentials.config.commandBlacklist.contains("tpa")) {
            return;
        }
        String perm = "command.tpa";
        PermissionAPI.registerNode((String)"command.tpa", (DefaultPermissionLevel)DefaultPermissionLevel.ALL, (String)"Can the player use /tpa");
        LiteralArgumentBuilder command = (LiteralArgumentBuilder)Commands.func_197057_a((String)"tpa").requires(cs -> CommandManager.hasPerm(cs, perm));
        command = (LiteralArgumentBuilder)command.then(Commands.func_197056_a((String)"target_player", (ArgumentType)EntityArgument.func_197096_c()).executes(ctx -> Tpa.execute((CommandSource)ctx.getSource(), EntityArgument.func_197089_d((CommandContext)ctx, (String)"target_player"))));
        commandDispatcher.register(command);
    }

    private static int execute(CommandSource source, ServerPlayerEntity target) throws CommandSyntaxException {
        long time;
        ServerPlayerEntity player = source.func_197035_h();
        if (!Essentials.config.tpaCrossDim && target.field_71093_bK != player.field_71093_bK) {
            player.func_145747_a(Essentials.config.getMessage("thutessentials.tp.wrongdim", new Object[0]));
            return 1;
        }
        CompoundNBT tag = PlayerDataHandler.getCustomDataTag((PlayerEntity)player);
        CompoundNBT tpaTag = tag.func_74775_l("tpa");
        long last = tag.func_74763_f("tpaDelay");
        if (last > (time = player.func_184102_h().func_71218_a(DimensionType.field_223227_a_).func_82737_E()) && Essentials.config.tpaReUseDelay > 0) {
            player.func_145747_a(Essentials.config.getMessage("thutessentials.tp.tosoon", new Object[0]));
            return 1;
        }
        tpaTag.func_74772_a("tpaDelay", time + (long)Essentials.config.tpaReUseDelay);
        tag.func_218657_a("tpa", (INBT)tpaTag);
        PlayerDataHandler.saveCustomData((PlayerEntity)player);
        tag = PlayerDataHandler.getCustomDataTag((PlayerEntity)target);
        tpaTag = tag.func_74775_l("tpa");
        if (tpaTag.func_74767_n("ignore")) {
            return 1;
        }
        ITextComponent header = player.func_145748_c_().func_150257_a(CommandManager.makeFormattedComponent("thutessentials.tpa.requested"));
        target.func_145747_a(header);
        String tpaccept = "tpaccept";
        ITextComponent accept = CommandManager.makeFormattedCommandLink("thutessentials.tpa.accept", "/tpaccept " + player.func_189512_bd() + " accept");
        ITextComponent deny = CommandManager.makeFormattedCommandLink("thutessentials.tpa.deny", "/tpaccept " + player.func_189512_bd() + " deny");
        ITextComponent tpMessage = accept.func_150257_a((ITextComponent)new StringTextComponent("      /      ")).func_150257_a(deny);
        target.func_145747_a(tpMessage);
        tpaTag.func_74778_a("R", player.func_189512_bd());
        tag.func_218657_a("tpa", (INBT)tpaTag);
        PlayerDataHandler.saveCustomData((PlayerEntity)target);
        player.func_145747_a(CommandManager.makeFormattedComponent("thutessentials.tpa.requestsent", TextFormatting.DARK_GREEN, true, target.func_145748_c_()));
        return 0;
    }
}

