/*
 * Decompiled with CFR 0.152.
 */
package thut.essentials.commands.util;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.text.NumberFormat;
import net.minecraft.command.CommandSource;
import net.minecraft.command.Commands;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraftforge.server.permission.DefaultPermissionLevel;
import net.minecraftforge.server.permission.PermissionAPI;
import thut.essentials.Essentials;
import thut.essentials.commands.CommandManager;

public class RAM {
    public static void register(CommandDispatcher<CommandSource> commandDispatcher) {
        String name = "ram";
        if (Essentials.config.commandBlacklist.contains("ram")) {
            return;
        }
        String perm = "command.ram";
        PermissionAPI.registerNode((String)"command.ram", (DefaultPermissionLevel)DefaultPermissionLevel.OP, (String)"Can the player use /ram");
        LiteralArgumentBuilder command = (LiteralArgumentBuilder)Commands.func_197057_a((String)"ram").requires(cs -> CommandManager.hasPerm(cs, perm));
        command = (LiteralArgumentBuilder)command.executes(ctx -> RAM.execute((CommandSource)ctx.getSource()));
        commandDispatcher.register(command);
    }

    private static String memInfo() {
        Runtime runtime = Runtime.getRuntime();
        NumberFormat format = NumberFormat.getInstance();
        StringBuilder sb = new StringBuilder();
        long maxMemory = runtime.maxMemory();
        long allocatedMemory = runtime.totalMemory();
        long freeMemory = runtime.freeMemory();
        sb.append("Free memory: ");
        sb.append(format.format(freeMemory / 1024L));
        sb.append("\n");
        sb.append("Allocated memory: ");
        sb.append(format.format(allocatedMemory / 1024L));
        sb.append("\n");
        sb.append("Max memory: ");
        sb.append(format.format(maxMemory / 1024L));
        sb.append("\n");
        sb.append("Total free memory: ");
        sb.append(format.format((freeMemory + maxMemory - allocatedMemory) / 1024L));
        sb.append("\n");
        return sb.toString();
    }

    private static int execute(CommandSource source) throws CommandSyntaxException {
        source.func_197030_a((ITextComponent)new StringTextComponent(RAM.memInfo()), false);
        return 0;
    }
}

