/*
 * Decompiled with CFR 0.152.
 */
package thut.essentials.commands.util;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.FloatArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import net.minecraft.command.CommandSource;
import net.minecraft.command.Commands;
import net.minecraft.command.arguments.EntityArgument;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraftforge.server.permission.DefaultPermissionLevel;
import net.minecraftforge.server.permission.PermissionAPI;
import thut.essentials.Essentials;
import thut.essentials.commands.CommandManager;
import thut.essentials.util.PlayerDataHandler;

public class Speed {
    public static void register(CommandDispatcher<CommandSource> commandDispatcher) {
        String name = "speed";
        if (Essentials.config.commandBlacklist.contains("speed")) {
            return;
        }
        String perm = "command.speed";
        PermissionAPI.registerNode((String)"command.speed", (DefaultPermissionLevel)DefaultPermissionLevel.OP, (String)"Can the player use /speed");
        LiteralArgumentBuilder command = (LiteralArgumentBuilder)Commands.func_197057_a((String)"speed").requires(cs -> CommandManager.hasPerm(cs, perm));
        command.then(((RequiredArgumentBuilder)Commands.func_197056_a((String)"speed", (ArgumentType)FloatArgumentType.floatArg((float)0.0f, (float)((float)Essentials.config.maxSpeed))).executes(ctx -> Speed.execute((CommandSource)ctx.getSource(), FloatArgumentType.getFloat((CommandContext)ctx, (String)"speed")))).then(Commands.func_197056_a((String)"player", (ArgumentType)EntityArgument.func_197096_c()).executes(ctx -> Speed.execute((CommandSource)ctx.getSource(), EntityArgument.func_197089_d((CommandContext)ctx, (String)"player"), FloatArgumentType.getFloat((CommandContext)ctx, (String)"speed")))));
        commandDispatcher.register(command);
    }

    private static int execute(CommandSource source, float value) throws CommandSyntaxException {
        return Speed.execute(source, source.func_197035_h(), value);
    }

    private static int execute(CommandSource source, ServerPlayerEntity player, float value) {
        CompoundNBT tag = PlayerDataHandler.getCustomDataTag((PlayerEntity)player);
        CompoundNBT speed = tag.func_74775_l("speed");
        if (!speed.func_74764_b("defaultWalk")) {
            speed.func_74780_a("defaultWalk", (double)player.field_71075_bZ.func_75094_b());
            speed.func_74780_a("defaultFly", (double)player.field_71075_bZ.func_75093_a());
        }
        CompoundNBT cap = new CompoundNBT();
        player.field_71075_bZ.func_75091_a(cap);
        CompoundNBT ab = cap.func_74775_l("abilities");
        ab.func_74776_a("flySpeed", (float)(speed.func_74769_h("defaultFly") * (double)value));
        ab.func_74776_a("walkSpeed", (float)(speed.func_74769_h("defaultWalk") * (double)value));
        cap.func_218657_a("abilities", (INBT)ab);
        player.field_71075_bZ.func_75095_b(cap);
        player.func_71016_p();
        tag.func_218657_a("speed", (INBT)speed);
        PlayerDataHandler.saveCustomData((PlayerEntity)player);
        return 0;
    }
}

