/*
 * Decompiled with CFR 0.152.
 */
package thut.essentials.commands.warps;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import net.minecraft.command.CommandSource;
import net.minecraft.command.Commands;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.dimension.DimensionType;
import net.minecraftforge.server.permission.DefaultPermissionLevel;
import net.minecraftforge.server.permission.PermissionAPI;
import thut.essentials.Essentials;
import thut.essentials.commands.CommandManager;
import thut.essentials.util.WarpManager;

public class Create {
    public static void register(CommandDispatcher<CommandSource> commandDispatcher) {
        String name = "set_warp";
        if (!Essentials.config.commandBlacklist.contains("set_warp")) {
            String perm = "command.set_warp";
            PermissionAPI.registerNode((String)"command.set_warp", (DefaultPermissionLevel)DefaultPermissionLevel.OP, (String)"Can the player use /set_warp");
            LiteralArgumentBuilder command = (LiteralArgumentBuilder)Commands.func_197057_a((String)"set_warp").requires(cs -> CommandManager.hasPerm(cs, perm));
            command = (LiteralArgumentBuilder)command.then(Commands.func_197056_a((String)"warp_name", (ArgumentType)StringArgumentType.string()).executes(ctx -> Create.execute((CommandSource)ctx.getSource(), StringArgumentType.getString((CommandContext)ctx, (String)"warp_name"))));
            commandDispatcher.register(command);
        }
    }

    private static int execute(CommandSource source, String warpName, BlockPos center, DimensionType dimension) throws CommandSyntaxException {
        ServerPlayerEntity player = source.func_197035_h();
        int ret = WarpManager.setWarp(center, dimension.func_186068_a(), warpName);
        switch (ret) {
            case 0: {
                ITextComponent message = CommandManager.makeFormattedComponent("thutessentials.warps.added", null, false, warpName);
                player.func_145747_a(message);
                break;
            }
            case 1: {
                ITextComponent message = CommandManager.makeFormattedComponent("thutessentials.warps.exists", null, false, warpName);
                player.func_145747_a(message);
            }
        }
        return ret;
    }

    private static int execute(CommandSource source, String warpName) throws CommandSyntaxException {
        return Create.execute(source, warpName, new BlockPos(source.func_197036_d()), source.func_197023_e().func_201675_m().func_186058_p());
    }
}

