/*
 * Decompiled with CFR 0.152.
 */
package thut.essentials.commands.warps;

import com.google.common.collect.Lists;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.suggestion.SuggestionProvider;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import java.util.ArrayList;
import net.minecraft.command.CommandSource;
import net.minecraft.command.Commands;
import net.minecraft.command.ISuggestionProvider;
import net.minecraft.util.text.ITextComponent;
import net.minecraftforge.server.permission.DefaultPermissionLevel;
import net.minecraftforge.server.permission.PermissionAPI;
import thut.essentials.Essentials;
import thut.essentials.commands.CommandManager;
import thut.essentials.util.WarpManager;

public class Delete {
    private static SuggestionProvider<CommandSource> SUGGEST_NAMES = (ctx, sb) -> {
        ArrayList opts = Lists.newArrayList();
        opts.addAll(WarpManager.warpLocs.keySet());
        opts.replaceAll(s -> s.contains(" ") ? "\"" + s + "\"" : s);
        return ISuggestionProvider.func_197005_b((Iterable)opts, (SuggestionsBuilder)sb);
    };

    public static void register(CommandDispatcher<CommandSource> commandDispatcher) {
        String name = "del_warp";
        if (!Essentials.config.commandBlacklist.contains("del_warp")) {
            String perm = "command.del_warp";
            PermissionAPI.registerNode((String)"command.del_warp", (DefaultPermissionLevel)DefaultPermissionLevel.OP, (String)"Can the player use /del_warp");
            LiteralArgumentBuilder command = (LiteralArgumentBuilder)Commands.func_197057_a((String)"del_warp").requires(cs -> CommandManager.hasPerm(cs, perm));
            command = (LiteralArgumentBuilder)command.then(Commands.func_197056_a((String)"warp", (ArgumentType)StringArgumentType.string()).suggests(SUGGEST_NAMES).executes(ctx -> Delete.execute((CommandSource)ctx.getSource(), StringArgumentType.getString((CommandContext)ctx, (String)"warp"))));
            commandDispatcher.register(command);
        }
    }

    private static int execute(CommandSource source, String homeName) throws CommandSyntaxException {
        int ret = WarpManager.delWarp(homeName);
        switch (ret) {
            case 0: {
                ITextComponent message = CommandManager.makeFormattedComponent("thutessentials.warps.removed", null, false, homeName);
                source.func_197030_a(message, true);
                break;
            }
            case 1: {
                ITextComponent message = CommandManager.makeFormattedComponent("thutessentials.warps.noexists_use", null, false, homeName);
                source.func_197030_a(message, true);
            }
        }
        return ret;
    }
}

