/*
 * Decompiled with CFR 0.152.
 */
package thut.essentials.commands.warps;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import net.minecraft.command.CommandSource;
import net.minecraft.command.Commands;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.util.text.ITextComponent;
import net.minecraftforge.server.permission.DefaultPermissionLevel;
import net.minecraftforge.server.permission.PermissionAPI;
import thut.essentials.Essentials;
import thut.essentials.commands.CommandManager;
import thut.essentials.util.WarpManager;

public class Warps {
    public static void register(CommandDispatcher<CommandSource> commandDispatcher) {
        LiteralArgumentBuilder command;
        String perm;
        String name = "warps";
        if (!Essentials.config.commandBlacklist.contains(name)) {
            perm = "command." + name;
            PermissionAPI.registerNode((String)perm, (DefaultPermissionLevel)DefaultPermissionLevel.ALL, (String)("Can the player use /" + name));
            command = (LiteralArgumentBuilder)Commands.func_197057_a((String)name).requires(cs -> CommandManager.hasPerm(cs, perm));
            command = (LiteralArgumentBuilder)command.executes(ctx -> Warps.execute((CommandSource)ctx.getSource()));
            commandDispatcher.register(command);
        }
        if (!Essentials.config.commandBlacklist.contains(name = "warp")) {
            perm = "command." + name;
            PermissionAPI.registerNode((String)perm, (DefaultPermissionLevel)DefaultPermissionLevel.ALL, (String)("Can the player use /" + name));
            command = (LiteralArgumentBuilder)Commands.func_197057_a((String)name).requires(cs -> CommandManager.hasPerm(cs, perm));
            command = (LiteralArgumentBuilder)command.then(Commands.func_197056_a((String)"warp_name", (ArgumentType)StringArgumentType.string()).executes(ctx -> Warps.execute((CommandSource)ctx.getSource(), StringArgumentType.getString((CommandContext)ctx, (String)"warp_name"))));
            commandDispatcher.register(command);
        }
    }

    private static int execute(CommandSource source) throws CommandSyntaxException {
        ServerPlayerEntity player = source.func_197035_h();
        WarpManager.sendWarpsList(player);
        return 0;
    }

    private static int execute(CommandSource source, String warpName) throws CommandSyntaxException {
        ServerPlayerEntity player = source.func_197035_h();
        int ret = WarpManager.attemptWarp(player, warpName);
        switch (ret) {
            case 0: {
                ITextComponent message = CommandManager.makeFormattedComponent("thutessentials.warps.warping", null, false, warpName);
                player.func_145747_a(message);
                break;
            }
            case 1: {
                ITextComponent message = CommandManager.makeFormattedComponent("thutessentials.tp.tosoon");
                player.func_145747_a(message);
                break;
            }
            case 2: {
                ITextComponent message = CommandManager.makeFormattedComponent("thutessentials.warps.noperms");
                player.func_145747_a(message);
                break;
            }
            case 3: {
                ITextComponent message = CommandManager.makeFormattedComponent("thutessentials.homes.noexists_use");
                player.func_145747_a(message);
            }
        }
        return ret;
    }
}

