/*
 * Decompiled with CFR 0.152.
 */
package thut.essentials.economy;

import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.function.Predicate;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.item.ItemFrameEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.tileentity.SignTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.EntityRayTraceResult;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.text.StringTextComponent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.ProjectileImpactEvent;
import net.minecraftforge.event.entity.player.AttackEntityEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.server.permission.DefaultPermissionLevel;
import net.minecraftforge.server.permission.PermissionAPI;
import thut.essentials.Essentials;
import thut.essentials.commands.CommandManager;
import thut.essentials.economy.EconomySaveHandler;
import thut.essentials.land.LandSaveHandler;
import thut.essentials.util.Coordinate;

public class EconomyManager {
    public static final int VERSION = 1;
    public static final String PERMMAKESHOP = "thutessentials.economy.make_shop";
    public static final String PERMMAKEINFSHOP = "thutessentials.economy.make_infinite_shop";
    public static final String PERMKILLSHOP = "thutessentials.economy.kill_shop";
    public static final String PERMKILLSHOPOTHER = "thutessentials.economy.kill_shop_other";
    public static final UUID DEFAULT_ID = new UUID(0L, 0L);
    public static EconomyManager instance;
    private static boolean init;
    public int version = 1;
    public int initial = 1000;
    public Map<UUID, Account> bank = Maps.newHashMap();
    public Map<Coordinate, Account> _shopMap = Maps.newHashMap();
    public Map<Account, UUID> _revBank = Maps.newHashMap();

    public static void clearInstance() {
        if (instance != null) {
            LandSaveHandler.saveGlobalData();
            MinecraftForge.EVENT_BUS.unregister((Object)instance);
        }
        instance = null;
    }

    public static EconomyManager getInstance() {
        if (instance == null) {
            EconomySaveHandler.loadGlobalData();
            EconomyManager.instance.initial = Essentials.config.initialBalance;
            if (!init) {
                init = true;
                PermissionAPI.registerNode((String)PERMMAKESHOP, (DefaultPermissionLevel)DefaultPermissionLevel.ALL, (String)"Allowed to make a shop that sells from a chest.");
                PermissionAPI.registerNode((String)PERMMAKEINFSHOP, (DefaultPermissionLevel)DefaultPermissionLevel.OP, (String)"Allowed to make a shop that sells infinite items.");
                PermissionAPI.registerNode((String)PERMKILLSHOP, (DefaultPermissionLevel)DefaultPermissionLevel.ALL, (String)"Allowed to remove a shop made by this player.");
                PermissionAPI.registerNode((String)PERMKILLSHOPOTHER, (DefaultPermissionLevel)DefaultPermissionLevel.OP, (String)"Allowed to remove a shop made by another player.");
            }
            MinecraftForge.EVENT_BUS.register((Object)instance);
        }
        return instance;
    }

    public EconomyManager() {
        MinecraftForge.EVENT_BUS.register((Object)this);
        Account master = new Account();
        master.balance = Integer.MAX_VALUE;
        this.bank.put(DEFAULT_ID, master);
    }

    @SubscribeEvent(receiveCanceled=true)
    public void interactRightClickEntity(PlayerInteractEvent.EntityInteract evt) {
        if (!(evt.getPlayer() instanceof ServerPlayerEntity)) {
            return;
        }
        if (!Essentials.config.shopsEnabled) {
            return;
        }
        if (evt.getTarget() instanceof ItemFrameEntity) {
            Coordinate c = new Coordinate(evt.getPos().func_177977_b(), evt.getPlayer().field_71093_bK);
            Shop shop = EconomyManager.getShop(c);
            TileEntity tile = evt.getWorld().func_175625_s(new BlockPos(c.x, c.y, c.z));
            if (evt.getItemStack() != null && tile instanceof SignTileEntity && shop == null && (evt.getItemStack().func_200301_q().func_150261_e().contains("Shop") || evt.getItemStack().func_200301_q().func_150261_e().contains("InfShop"))) {
                String permission;
                boolean infinite = evt.getItemStack().func_200301_q().func_150261_e().contains("InfShop");
                String string = permission = infinite ? PERMMAKEINFSHOP : PERMMAKESHOP;
                if (!PermissionAPI.hasPermission((PlayerEntity)evt.getPlayer(), (String)permission)) {
                    evt.getPlayer().func_145747_a(CommandManager.makeFormattedComponent("thutessentials.econ.not_allowed"));
                    return;
                }
                try {
                    boolean noTag = evt.getItemStack().func_200301_q().func_150261_e().contains("noTag");
                    shop = EconomyManager.addShop((ServerPlayerEntity)evt.getPlayer(), (ItemFrameEntity)evt.getTarget(), c, infinite, noTag);
                    evt.getPlayer().func_145747_a(CommandManager.makeFormattedComponent("thutessentials.econ.made"));
                }
                catch (Exception e) {
                    evt.getPlayer().func_145747_a(CommandManager.makeFormattedComponent("thutessentials.econ.errored"));
                    Essentials.LOGGER.error((Object)e);
                }
            }
            if (shop != null) {
                evt.setCanceled(true);
            }
        }
    }

    @SubscribeEvent
    public void projectileImpact(ProjectileImpactEvent evt) {
        Coordinate c;
        Shop shop;
        if (evt.getEntity().func_130014_f_().field_72995_K) {
            return;
        }
        if (!Essentials.config.shopsEnabled) {
            return;
        }
        if (evt.getRayTraceResult().func_216346_c() == RayTraceResult.Type.MISS) {
            return;
        }
        if (!(evt.getRayTraceResult() instanceof EntityRayTraceResult)) {
            return;
        }
        EntityRayTraceResult hit = (EntityRayTraceResult)evt.getRayTraceResult();
        Entity target = hit.func_216348_a();
        if (target instanceof ItemFrameEntity && (shop = EconomyManager.getShop(c = new Coordinate(target.func_180425_c().func_177977_b(), target.field_71093_bK))) != null) {
            evt.setCanceled(true);
        }
    }

    @SubscribeEvent(receiveCanceled=true)
    public void interactLeftClickEntity(AttackEntityEvent evt) {
        Coordinate c;
        Shop shop;
        if (evt.getPlayer().func_130014_f_().field_72995_K) {
            return;
        }
        if (!Essentials.config.shopsEnabled) {
            return;
        }
        if (evt.getTarget() instanceof ItemFrameEntity && (shop = EconomyManager.getShop(c = new Coordinate(evt.getTarget().func_180425_c().func_177977_b(), evt.getTarget().field_71093_bK))) != null) {
            String perm;
            evt.setCanceled(true);
            Account account = this._shopMap.get(c);
            UUID owner = this._revBank.get(account);
            String string = perm = evt.getPlayer().func_110124_au().equals(owner) ? PERMKILLSHOP : PERMKILLSHOPOTHER;
            if (PermissionAPI.hasPermission((PlayerEntity)evt.getPlayer(), (String)perm)) {
                EconomyManager.removeShop(c);
                evt.getPlayer().func_145747_a(CommandManager.makeFormattedComponent("thutessentials.econ.remove"));
            } else {
                evt.getPlayer().func_145747_a(CommandManager.makeFormattedComponent("thutessentials.econ.not_allowed_remove"));
            }
        }
    }

    @SubscribeEvent(receiveCanceled=true, priority=EventPriority.HIGH)
    public void interactRightClickBlock(PlayerInteractEvent.RightClickBlock evt) {
        if (!(evt.getPlayer() instanceof ServerPlayerEntity) || !Essentials.config.shopsEnabled) {
            return;
        }
        Coordinate c = new Coordinate(evt.getPos(), evt.getPlayer().field_71093_bK);
        Shop shop = EconomyManager.getShop(c);
        if (shop != null) {
            shop.transact((ServerPlayerEntity)evt.getPlayer(), evt.getItemStack(), this._shopMap.get(c));
            evt.setCanceled(true);
        }
    }

    public Account getAccount(UUID player) {
        Account account = this.bank.get(player);
        if (account == null) {
            account = new Account();
            this.bank.put(player, account);
            account._id = player;
            account.balance = this.initial;
            EconomySaveHandler.saveGlobalData();
        }
        return account;
    }

    public Account getAccount(ServerPlayerEntity player) {
        return this.getAccount(player.func_110124_au());
    }

    public static Shop addShop(ServerPlayerEntity owner, ItemFrameEntity frame, Coordinate location, boolean infinite, boolean noTag) {
        Shop shop = new Shop();
        shop.infinite = infinite;
        shop.frameId = frame.func_110124_au();
        shop.location = location;
        shop.ignoreTag = noTag;
        Account account = EconomyManager.getInstance().getAccount(infinite ? DEFAULT_ID : owner.func_110124_au());
        account.shops.add(shop);
        account._shopMap.put(location, shop);
        EconomyManager.getInstance()._shopMap.put(location, account);
        if (!shop.infinite) {
            TileEntity down = owner.func_130014_f_().func_175625_s(new BlockPos(location.x, location.y - 1, location.z));
            if (down instanceof SignTileEntity) {
                String[] var = ((SignTileEntity)down).field_145915_a[0].func_150261_e().split(",");
                int dx = Integer.parseInt(var[0]);
                int dy = Integer.parseInt(var[1]);
                int dz = Integer.parseInt(var[2]);
                BlockPos pos = new BlockPos(location.x + dx, location.y + dy, location.z + dz);
                BlockEvent.BreakEvent event = new BlockEvent.BreakEvent(owner.func_130014_f_(), pos, owner.func_130014_f_().func_180495_p(pos), (PlayerEntity)owner);
                MinecraftForge.EVENT_BUS.post((Event)event);
                if (event.isCanceled()) {
                    owner.func_145747_a(CommandManager.makeFormattedComponent("thutessentials.econ.not_allowed_link"));
                    return null;
                }
                shop.storage = new Coordinate(location.x + dx, location.y - 1 + dy, location.z + dz, location.dim);
            } else {
                shop.storage = new Coordinate(location.x, location.y - 1, location.z, location.dim);
            }
        }
        EconomySaveHandler.saveGlobalData();
        return shop;
    }

    public static void removeShop(Coordinate location) {
        Account account = EconomyManager.getInstance()._shopMap.remove(location);
        if (account != null) {
            account.shops.remove(account._shopMap.remove(location));
            EconomySaveHandler.saveGlobalData();
        }
    }

    public static Shop getShop(Coordinate location) {
        Account account = EconomyManager.getInstance()._shopMap.get(location);
        if (account == null) {
            return null;
        }
        return account._shopMap.get(location);
    }

    public static int getBalance(ServerPlayerEntity player) {
        return EconomyManager.getBalance(player.func_110124_au());
    }

    public static void setBalance(ServerPlayerEntity player, int amount) {
        EconomyManager.setBalance(player.func_110124_au(), amount);
    }

    public static void addBalance(ServerPlayerEntity player, int amount) {
        EconomyManager.addBalance(player.func_110124_au(), amount);
    }

    public static int getBalance(UUID player) {
        return EconomyManager.getInstance().getAccount((UUID)player).balance;
    }

    public static void setBalance(UUID player, int amount) {
        Account account = EconomyManager.getInstance().getAccount(player);
        account.balance = amount;
        EconomySaveHandler.saveGlobalData();
    }

    public static void addBalance(UUID player, int amount) {
        Account account = EconomyManager.getInstance().getAccount(player);
        account.balance += amount;
        EconomySaveHandler.saveGlobalData();
    }

    public static void giveItem(ServerPlayerEntity entityplayer, ItemStack itemstack) {
        boolean flag = entityplayer.field_71071_by.func_70441_a(itemstack);
        if (flag) {
            entityplayer.field_70170_p.func_184148_a((PlayerEntity)((ServerPlayerEntity)null), entityplayer.func_226277_ct_(), entityplayer.func_226278_cu_(), entityplayer.func_226281_cx_(), SoundEvents.field_187638_cR, SoundCategory.PLAYERS, 0.2f, ((entityplayer.func_70681_au().nextFloat() - entityplayer.func_70681_au().nextFloat()) * 0.7f + 1.0f) * 2.0f);
            entityplayer.field_71069_bz.func_75142_b();
        } else {
            ItemEntity entityitem = entityplayer.func_71019_a(itemstack, false);
            if (entityitem != null) {
                entityitem.func_174868_q();
                entityitem.func_200217_b(entityplayer.func_110124_au());
            }
        }
    }

    static {
        init = false;
    }

    public static class Shop {
        Coordinate location;
        Coordinate storage;
        UUID frameId;
        boolean infinite = false;
        boolean ignoreTag = false;
        boolean recycle = false;
        boolean sell;
        int cost;
        int number;

        public boolean transact(ServerPlayerEntity player, ItemStack heldStack, Account shopAccount) {
            TileEntity tile;
            ItemStack stack = ItemStack.field_190927_a;
            Entity ent = player.func_184102_h().func_71218_a(player.field_71093_bK).func_217461_a(this.frameId);
            if (ent instanceof ItemFrameEntity) {
                stack = ((ItemFrameEntity)ent).func_82335_i();
            }
            if (!((tile = player.field_70170_p.func_175625_s(new BlockPos(this.location.x, this.location.y, this.location.z))) instanceof SignTileEntity)) {
                EconomyManager.removeShop(this.location);
                return false;
            }
            SignTileEntity sign = (SignTileEntity)tile;
            this.sell = Essentials.config.sellTags.contains(sign.field_145915_a[0].func_150261_e());
            this.recycle = Essentials.config.recycleTags.contains(sign.field_145915_a[0].func_150261_e());
            try {
                this.number = Integer.parseInt(sign.field_145915_a[1].func_150261_e());
                if (this.ignoreTag) {
                    if (this.number != 1) {
                        sign.field_145915_a[1] = new StringTextComponent("1");
                    }
                    this.number = 1;
                }
            }
            catch (NumberFormatException e) {
                e.printStackTrace();
                return false;
            }
            try {
                this.cost = Integer.parseInt(sign.field_145915_a[3].func_150261_e());
            }
            catch (NumberFormatException e) {
                e.printStackTrace();
                return false;
            }
            if (this.recycle && heldStack.func_190926_b()) {
                player.func_145747_a(CommandManager.makeFormattedComponent("thutessentials.econ.no_recycle"));
                return false;
            }
            if (stack.func_190926_b()) {
                EconomyManager.removeShop(this.location);
                return false;
            }
            if (this.sell) {
                int balance = EconomyManager.getBalance(player);
                if (balance < this.cost) {
                    player.func_145747_a(CommandManager.makeFormattedComponent("thutessentials.econ.no_funds_you"));
                    return false;
                }
                stack = stack.func_77946_l();
                stack.func_190920_e(this.number);
                if (!this.infinite) {
                    TileEntity inventory;
                    int count = 0;
                    IInventory inv = null;
                    ItemStack test2 = stack.func_77946_l();
                    if (this.storage != null && (inventory = player.field_70170_p.func_175625_s(new BlockPos(this.storage.x, this.storage.y, this.storage.z))) instanceof IInventory) {
                        inv = (IInventory)inventory;
                        if (this.ignoreTag) {
                            test2.func_77982_d(new CompoundNBT());
                        }
                        for (int i2 = 0; i2 < inv.func_70302_i_(); ++i2) {
                            ItemStack item = inv.func_70301_a(i2);
                            if (item.func_190926_b()) continue;
                            ItemStack test = item.func_77946_l();
                            if (this.ignoreTag) {
                                test.func_77982_d(new CompoundNBT());
                            }
                            test.func_190920_e(this.number);
                            if (!ItemStack.func_77989_b((ItemStack)test, (ItemStack)test2)) continue;
                            count += item.func_190916_E();
                        }
                    }
                    if (count < this.number || inv == null) {
                        Essentials.LOGGER.debug(this.number + " " + count + " " + this.storage);
                        player.func_145747_a(CommandManager.makeFormattedComponent("thutessentials.econ.no_items_shop"));
                        return false;
                    }
                    int i3 = 0;
                    Item itemIn = test2.func_77973_b();
                    int removeCount = this.number;
                    CompoundNBT itemNBT = this.ignoreTag ? null : test2.func_77978_p();
                    for (int j = 0; j < inv.func_70302_i_(); ++j) {
                        ItemStack itemstack = inv.func_70301_a(j);
                        if (itemstack.func_190926_b() || itemstack.func_77973_b() != itemIn || itemNBT != null && !NBTUtil.func_181123_a((INBT)itemNBT, (INBT)itemstack.func_77978_p(), (boolean)true)) continue;
                        int k = removeCount <= 0 ? itemstack.func_190916_E() : Math.min(removeCount - i3, itemstack.func_190916_E());
                        i3 += k;
                        if (this.number == 1) {
                            stack.func_77982_d(itemstack.func_77978_p());
                        }
                        if (removeCount == 0) continue;
                        itemstack.func_190918_g(k);
                        if (itemstack.func_190926_b()) {
                            inv.func_70299_a(j, ItemStack.field_190927_a);
                        }
                        if (removeCount > 0 && i3 >= removeCount) break;
                    }
                }
                EconomyManager.giveItem(player, stack);
                EconomyManager.addBalance(shopAccount._id, this.cost);
                EconomyManager.addBalance(player, -this.cost);
                player.func_145747_a(CommandManager.makeFormattedComponent("thutessentials.econ.balance.remaining", null, false, EconomyManager.getBalance(player)));
            } else {
                int balance;
                int n = balance = this.infinite ? Integer.MAX_VALUE : shopAccount.balance;
                if (balance < this.cost) {
                    player.func_145747_a(CommandManager.makeFormattedComponent("thutessentials.econ.no_funds_shop"));
                    return false;
                }
                int count = 0;
                ItemStack toTest = stack.func_77946_l();
                toTest.func_190920_e(1);
                Predicate<ItemStack> valid = i -> {
                    ItemStack temp = i.func_77946_l();
                    temp.func_190920_e(1);
                    return ItemStack.func_77989_b((ItemStack)temp, (ItemStack)toTest);
                };
                if (this.recycle) {
                    count = heldStack.func_190916_E();
                    if (count < this.number) {
                        player.func_145747_a(CommandManager.makeFormattedComponent("thutessentials.econ.no_items_you"));
                        return false;
                    }
                    stack = heldStack;
                } else {
                    stack = stack.func_77946_l();
                    stack.func_190920_e(this.number);
                    for (ItemStack item : player.field_71071_by.field_70462_a) {
                        if (item.func_190926_b() || !valid.test(item)) continue;
                        count += item.func_190916_E();
                    }
                    if (count < this.number) {
                        player.func_145747_a(CommandManager.makeFormattedComponent("thutessentials.econ.no_items_you"));
                        return false;
                    }
                }
                if (!this.infinite) {
                    if (this.storage == null) {
                        player.func_145747_a(CommandManager.makeFormattedComponent("thutessentials.econ.no_storage"));
                        return false;
                    }
                    TileEntity te = player.field_70170_p.func_175625_s(new BlockPos(this.storage.x, this.storage.y, this.storage.z));
                    if (te instanceof IInventory) {
                        IInventory inv = (IInventory)te;
                        count = 0;
                        ItemStack a = stack;
                        count = stack.func_190916_E();
                        for (int i4 = 0; i4 < inv.func_70302_i_(); ++i4) {
                            if (inv.func_70301_a(i4).func_190926_b() || a.func_77969_a(inv.func_70301_a(i4))) {
                                int n2 = 0;
                                if (!inv.func_70301_a(i4).func_190926_b() && (n2 = inv.func_70301_a(i4).func_190916_E() + a.func_190916_E()) < 65) {
                                    a.func_190920_e(n2);
                                    count = 0;
                                    inv.func_70299_a(i4, a.func_77946_l());
                                } else if (inv.func_70301_a(i4).func_190926_b()) {
                                    count = 0;
                                    inv.func_70299_a(i4, a.func_77946_l());
                                }
                            }
                            if (count == 0) break;
                        }
                    }
                }
                player.field_71071_by.func_195408_a(valid, this.number);
                player.field_71069_bz.func_75142_b();
                EconomyManager.addBalance(shopAccount._id, -this.cost);
                EconomyManager.addBalance(player, this.cost);
                player.func_145747_a(CommandManager.makeFormattedComponent("thutessentials.econ.balance.remaining", null, false, EconomyManager.getBalance(player)));
            }
            return false;
        }
    }

    public static class Account {
        int balance;
        Set<Shop> shops = Sets.newHashSet();
        UUID _id;
        Map<Coordinate, Shop> _shopMap = Maps.newHashMap();
    }
}

