/*
 * Decompiled with CFR 0.152.
 */
package thut.essentials.economy;

import com.google.gson.ExclusionStrategy;
import com.google.gson.FieldAttributes;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.File;
import java.io.IOException;
import java.util.Map;
import java.util.UUID;
import net.minecraft.server.MinecraftServer;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.fml.LogicalSidedProvider;
import org.apache.commons.io.FileUtils;
import thut.essentials.economy.EconomyManager;

public class EconomySaveHandler {
    static ExclusionStrategy exclusion = new ExclusionStrategy(){

        public boolean shouldSkipField(FieldAttributes f) {
            String name = f.getName();
            return name.startsWith("_");
        }

        public boolean shouldSkipClass(Class<?> clazz) {
            return false;
        }
    };

    public static File getGlobalFolder() {
        MinecraftServer server = (MinecraftServer)LogicalSidedProvider.INSTANCE.get(LogicalSide.SERVER);
        String folder = server.func_71270_I();
        File file = server.func_71254_M().func_186352_b(folder, "economy");
        if (!file.exists()) {
            file.mkdirs();
        }
        return file;
    }

    public static void saveGlobalData() {
        MinecraftServer server = (MinecraftServer)LogicalSidedProvider.INSTANCE.get(LogicalSide.SERVER);
        if (server == null) {
            return;
        }
        Gson gson = new GsonBuilder().addSerializationExclusionStrategy(exclusion).setPrettyPrinting().create();
        EconomyManager.getInstance().version = 1;
        String json = gson.toJson((Object)EconomyManager.getInstance());
        File teamsFile = new File(EconomySaveHandler.getGlobalFolder(), "economy.json");
        try {
            FileUtils.writeStringToFile((File)teamsFile, (String)json, (String)"UTF-8");
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void loadGlobalData() {
        File teamsFile;
        MinecraftServer server = (MinecraftServer)LogicalSidedProvider.INSTANCE.get(LogicalSide.SERVER);
        if (server != null && (teamsFile = new File(EconomySaveHandler.getGlobalFolder(), "economy.json")).exists()) {
            try {
                Gson gson = new GsonBuilder().addDeserializationExclusionStrategy(exclusion).setPrettyPrinting().create();
                String json = FileUtils.readFileToString((File)teamsFile, (String)"UTF-8");
                EconomyManager.instance = (EconomyManager)gson.fromJson(json, EconomyManager.class);
                for (Map.Entry<UUID, EconomyManager.Account> entry : EconomyManager.instance.bank.entrySet()) {
                    UUID id;
                    EconomyManager.Account account = entry.getValue();
                    account._id = id = entry.getKey();
                    EconomyManager.instance._revBank.put(account, id);
                    for (EconomyManager.Shop shop : account.shops) {
                        account._shopMap.put(shop.location, shop);
                        EconomyManager.instance._shopMap.put(shop.location, account);
                    }
                }
                return;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        if (EconomyManager.instance == null) {
            EconomyManager.instance = new EconomyManager();
        }
        EconomySaveHandler.saveGlobalData();
    }
}

