/*
 * Decompiled with CFR 0.152.
 */
package thut.essentials.land;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.mojang.authlib.GameProfile;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import net.minecraft.block.BlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.INPC;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.item.ItemFrameEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.container.Container;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.network.IPacket;
import net.minecraft.network.play.server.SSpawnParticlePacket;
import net.minecraft.particles.BasicParticleType;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.concurrent.TickDelayedTask;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.EntityRayTraceResult;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.world.dimension.Dimension;
import net.minecraft.world.dimension.DimensionType;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.EntityMobGriefingEvent;
import net.minecraftforge.event.entity.ProjectileImpactEvent;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.event.entity.living.LivingSpawnEvent;
import net.minecraftforge.event.entity.player.AttackEntityEvent;
import net.minecraftforge.event.entity.player.FillBucketEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.event.world.ExplosionEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.fml.LogicalSidedProvider;
import net.minecraftforge.fml.event.server.FMLServerStartedEvent;
import net.minecraftforge.server.permission.DefaultPermissionLevel;
import net.minecraftforge.server.permission.PermissionAPI;
import thut.essentials.Essentials;
import thut.essentials.commands.CommandManager;
import thut.essentials.events.DenyItemUseEvent;
import thut.essentials.land.LandManager;
import thut.essentials.land.LandSaveHandler;
import thut.essentials.util.Coordinate;
import thut.essentials.util.ItemList;
import thut.essentials.util.MobManager;
import thut.essentials.util.OwnerManager;
import thut.essentials.util.PlayerDataHandler;

public class LandEventsHandler {
    public static final LandEventsHandler TEAMMANAGER = new LandEventsHandler();
    public static Set<ResourceLocation> mobUseWhitelist = Sets.newHashSet();
    public static Set<ResourceLocation> itemUseWhitelist = Sets.newHashSet();
    public static Set<ResourceLocation> blockUseWhiteList = Sets.newHashSet();
    public static Set<ResourceLocation> blockBreakWhiteList = Sets.newHashSet();
    public static Set<ResourceLocation> blockPlaceWhiteList = Sets.newHashSet();
    public static Set<ResourceLocation> invuln = Sets.newHashSet();
    public static Map<ResourceLocation, String[]> customMobPerms = Maps.newHashMap();
    public static final String[] defaultMobPerms = new String[]{"thutessentials.land.usemob.unowned", "thutessentials.land.usemob.owned.self", "thutessentials.land.usemob.owned.other"};
    public static final ResourceLocation ITEMUSEWHTETAG = new ResourceLocation("thutessentials", "land_whitelist");
    public static final String PERMBREAKWILD = "thutessentials.land.break.unowned";
    public static final String PERMBREAKOWN = "thutessentials.land.break.owned.self";
    public static final String PERMBREAKOTHER = "thutessentials.land.break.owned.other";
    public static final String PERMPLACEWILD = "thutessentials.land.place.unowned";
    public static final String PERMPLACEOWN = "thutessentials.land.place.owned.self";
    public static final String PERMPLACEOTHER = "thutessentials.land.place.owned.other";
    public static final String PERMUSEITEMWILD = "thutessentials.land.useitem.unowned";
    public static final String PERMUSEITEMOWN = "thutessentials.land.useitem.owned.self";
    public static final String PERMUSEITEMOTHER = "thutessentials.land.useitem.owned.other";
    public static final String PERMUSEBLOCKWILD = "thutessentials.land.useblock.unowned";
    public static final String PERMUSEBLOCKOWN = "thutessentials.land.useblock.owned.self";
    public static final String PERMUSEBLOCKOTHER = "thutessentials.land.useblock.owned.other";
    public static final String PERMUSEMOBWILD = "thutessentials.land.usemob.unowned";
    public static final String PERMUSEMOBOWN = "thutessentials.land.usemob.owned.self";
    public static final String PERMUSEMOBOTHER = "thutessentials.land.usemob.owned.other";
    public static final String PERMENTERWILD = "thutessentials.land.enter.unowned";
    public static final String PERMENTEROWN = "thutessentials.land.enter.owned.self";
    public static final String PERMENTEROTHER = "thutessentials.land.enter.owned.other";
    public static final String PERMCREATETEAM = "thutessentials.teams.create";
    public static final String PERMJOINTEAMINVITED = "thutessentials.teams.join.invite";
    public static final String PERMJOINTEAMNOINVITE = "thutessentials.teams.join.force";
    public static final String PERMPROTECTMOB = "thutessentials.teams.protect.mob";
    public static final String PERMUNCLAIMOTHER = "thutessentials.land.unclaim.owned.other";
    static Map<UUID, Long> lastLeaveMessage = Maps.newHashMap();
    static Map<UUID, Long> lastEnterMessage = Maps.newHashMap();
    private boolean registered = false;
    protected InteractEventHandler interact_handler = new InteractEventHandler();
    protected EntityEventHandler entity_handler = new EntityEventHandler();
    protected BlockEventHandler block_handler = new BlockEventHandler();
    public Set<UUID> checked = Sets.newHashSet();
    public List<GameProfile> toCheck = Lists.newArrayList();
    private static final byte DENY = 0;
    private static final byte ENTER = 1;
    private static final byte EXIT = 2;
    private static Map<UUID, Long> denyFloodControl = Maps.newHashMap();
    private static Map<UUID, Long> enterFloodControl = Maps.newHashMap();
    private static Map<UUID, Long> exitFloodControl = Maps.newHashMap();

    public static void init() {
        MinecraftForge.EVENT_BUS.unregister((Object)TEAMMANAGER);
        MinecraftForge.EVENT_BUS.unregister((Object)LandEventsHandler.TEAMMANAGER.interact_handler);
        MinecraftForge.EVENT_BUS.unregister((Object)LandEventsHandler.TEAMMANAGER.entity_handler);
        MinecraftForge.EVENT_BUS.unregister((Object)LandEventsHandler.TEAMMANAGER.block_handler);
        if (!Essentials.config.landEnabled) {
            return;
        }
        customMobPerms.clear();
        for (String s : Essentials.config.customMobUsePerms) {
            String[] args = s.split("->");
            String[] perms = args[1].split(",");
            customMobPerms.put(new ResourceLocation(args[0]), perms);
        }
        itemUseWhitelist.clear();
        for (String s : Essentials.config.itemUseWhitelist) {
            itemUseWhitelist.add(new ResourceLocation(s));
        }
        blockUseWhiteList.clear();
        for (String s : Essentials.config.blockUseWhitelist) {
            blockUseWhiteList.add(new ResourceLocation(s));
        }
        blockBreakWhiteList.clear();
        for (String s : Essentials.config.blockBreakWhitelist) {
            blockBreakWhiteList.add(new ResourceLocation(s));
        }
        blockPlaceWhiteList.clear();
        for (String s : Essentials.config.blockPlaceWhitelist) {
            blockPlaceWhiteList.add(new ResourceLocation(s));
        }
        for (String s : Essentials.config.mobUseWhitelist) {
            mobUseWhitelist.add(new ResourceLocation(s));
        }
        MinecraftForge.EVENT_BUS.register((Object)TEAMMANAGER);
        MinecraftForge.EVENT_BUS.register((Object)LandEventsHandler.TEAMMANAGER.interact_handler);
        MinecraftForge.EVENT_BUS.register((Object)LandEventsHandler.TEAMMANAGER.entity_handler);
        MinecraftForge.EVENT_BUS.register((Object)LandEventsHandler.TEAMMANAGER.block_handler);
        invuln.clear();
        for (String s : Essentials.config.invulnMobs) {
            invuln.add(new ResourceLocation(s));
        }
    }

    private static boolean isPublicToggle(ItemStack stack) {
        return stack.func_200301_q().func_150261_e().equalsIgnoreCase("public toggle");
    }

    private static boolean isProtectToggle(ItemStack stack) {
        return stack.func_200301_q().func_150261_e().equalsIgnoreCase("protect toggle");
    }

    private static boolean isBreakToggle(ItemStack stack) {
        return stack.func_200301_q().func_150261_e().equalsIgnoreCase("break toggle");
    }

    private static boolean isPlaceToggle(ItemStack stack) {
        return stack.func_200301_q().func_150261_e().equalsIgnoreCase("place toggle");
    }

    public static boolean sameTeam(Entity a, Entity b) {
        return LandManager.getTeam(a) == LandManager.getTeam(b);
    }

    public void registerPerms() {
        if (this.registered) {
            return;
        }
        this.registered = true;
        PermissionAPI.registerNode((String)PERMBREAKWILD, (DefaultPermissionLevel)DefaultPermissionLevel.ALL, (String)"Can the player break blocks in unowned land.");
        PermissionAPI.registerNode((String)PERMBREAKOWN, (DefaultPermissionLevel)DefaultPermissionLevel.ALL, (String)"Can the player break blocks in their own land.");
        PermissionAPI.registerNode((String)PERMBREAKOTHER, (DefaultPermissionLevel)DefaultPermissionLevel.OP, (String)"Can the player break blocks in other player's land.");
        PermissionAPI.registerNode((String)PERMPLACEWILD, (DefaultPermissionLevel)DefaultPermissionLevel.ALL, (String)"Can the player place blocks in unowned land.");
        PermissionAPI.registerNode((String)PERMPLACEOWN, (DefaultPermissionLevel)DefaultPermissionLevel.ALL, (String)"Can the player place blocks in their own land.");
        PermissionAPI.registerNode((String)PERMPLACEOTHER, (DefaultPermissionLevel)DefaultPermissionLevel.OP, (String)"Can the player place blocks in other player's land.");
        PermissionAPI.registerNode((String)PERMUSEITEMWILD, (DefaultPermissionLevel)DefaultPermissionLevel.ALL, (String)"Can the player use items in unowned land.");
        PermissionAPI.registerNode((String)PERMUSEITEMOWN, (DefaultPermissionLevel)DefaultPermissionLevel.ALL, (String)"Can the player use items in their own land.");
        PermissionAPI.registerNode((String)PERMUSEITEMOTHER, (DefaultPermissionLevel)DefaultPermissionLevel.OP, (String)"Can the player use items in other player's land.");
        PermissionAPI.registerNode((String)PERMUSEBLOCKWILD, (DefaultPermissionLevel)DefaultPermissionLevel.ALL, (String)"Can the player use items in unowned land.");
        PermissionAPI.registerNode((String)PERMUSEBLOCKOWN, (DefaultPermissionLevel)DefaultPermissionLevel.ALL, (String)"Can the player use items in their own land.");
        PermissionAPI.registerNode((String)PERMUSEBLOCKOTHER, (DefaultPermissionLevel)DefaultPermissionLevel.OP, (String)"Can the player use items in other player's land.");
        PermissionAPI.registerNode((String)PERMUSEMOBWILD, (DefaultPermissionLevel)DefaultPermissionLevel.ALL, (String)"Can the player interact with mobs in unowned land.");
        PermissionAPI.registerNode((String)PERMUSEMOBOWN, (DefaultPermissionLevel)DefaultPermissionLevel.ALL, (String)"Can the player interact with mobs in their own land.");
        PermissionAPI.registerNode((String)PERMUSEMOBOTHER, (DefaultPermissionLevel)DefaultPermissionLevel.ALL, (String)"Can the player interact with mobs in other player's land.");
        PermissionAPI.registerNode((String)PERMENTERWILD, (DefaultPermissionLevel)DefaultPermissionLevel.ALL, (String)"Can the player enter unowned land.");
        PermissionAPI.registerNode((String)PERMENTEROWN, (DefaultPermissionLevel)DefaultPermissionLevel.ALL, (String)"Can the player enter their own land.");
        PermissionAPI.registerNode((String)PERMENTEROTHER, (DefaultPermissionLevel)DefaultPermissionLevel.ALL, (String)"Can the player enter other player's land.");
        PermissionAPI.registerNode((String)PERMCREATETEAM, (DefaultPermissionLevel)DefaultPermissionLevel.ALL, (String)"Can the player create a team.");
        PermissionAPI.registerNode((String)PERMJOINTEAMINVITED, (DefaultPermissionLevel)DefaultPermissionLevel.ALL, (String)"Can the player join a team with an invite.");
        PermissionAPI.registerNode((String)PERMJOINTEAMNOINVITE, (DefaultPermissionLevel)DefaultPermissionLevel.OP, (String)"Can the player join a team without an invite.");
        PermissionAPI.registerNode((String)PERMPROTECTMOB, (DefaultPermissionLevel)DefaultPermissionLevel.ALL, (String)"Can the player protect mobs in their team's land.");
        PermissionAPI.registerNode((String)PERMUNCLAIMOTHER, (DefaultPermissionLevel)DefaultPermissionLevel.OP, (String)"Can the player unclaim any land.");
    }

    public void queueUpdate(GameProfile profile) {
        if (profile.getId() == null) {
            return;
        }
        if (this.checked.contains(profile.getId())) {
            return;
        }
        this.toCheck.add(profile);
    }

    @SubscribeEvent
    public void tick(TickEvent.ServerTickEvent event) {
        if (this.toCheck.isEmpty() || event.phase != TickEvent.Phase.END) {
            return;
        }
        MinecraftServer server = (MinecraftServer)LogicalSidedProvider.INSTANCE.get(LogicalSide.SERVER);
        if (server.func_211150_az() % 200L != 0L) {
            return;
        }
        GameProfile profile = this.toCheck.get(0);
        try {
            profile = server.func_147130_as().fillProfileProperties(profile, true);
            if (profile.getName() == null || profile.getId() == null) {
                return;
            }
            server.func_152358_ax().func_152649_a(profile);
        }
        catch (Exception e) {
            return;
        }
        this.toCheck.remove(0);
        if (profile.getId() != null) {
            this.checked.add(profile.getId());
        }
    }

    @SubscribeEvent
    public void login(PlayerEvent.PlayerLoggedInEvent evt) {
        PlayerEntity entityPlayer = evt.getPlayer();
        LandManager.LandTeam team = LandManager.getTeam((Entity)entityPlayer);
        MinecraftServer server = (MinecraftServer)LogicalSidedProvider.INSTANCE.get(LogicalSide.SERVER);
        team.lastSeen = server.func_211150_az();
    }

    @SubscribeEvent
    public void logout(PlayerEvent.PlayerLoggedOutEvent evt) {
        PlayerEntity entityPlayer = evt.getPlayer();
        LandManager.LandTeam team = LandManager.getTeam((Entity)entityPlayer);
        MinecraftServer server = (MinecraftServer)LogicalSidedProvider.INSTANCE.get(LogicalSide.SERVER);
        team.lastSeen = server.func_211150_az();
    }

    @SubscribeEvent
    public void detonate(ExplosionEvent.Detonate evt) {
        if (evt.getWorld().field_72995_K) {
            return;
        }
        ArrayList toRemove = Lists.newArrayList();
        boolean denyBlasts = Essentials.config.denyExplosions;
        if (Essentials.config.landEnabled) {
            Dimension dimension = evt.getWorld().func_201675_m();
            for (BlockPos pos : evt.getAffectedBlocks()) {
                Coordinate c = Coordinate.getChunkCoordFromWorldCoord(pos, dimension);
                LandManager.LandTeam owner = LandManager.getInstance().getLandOwner(c);
                boolean deny = denyBlasts;
                if (owner == null) continue;
                boolean bl = deny = deny || owner.noExplosions;
                if (!deny) continue;
                toRemove.add(pos);
            }
        }
        evt.getAffectedBlocks().removeAll(toRemove);
    }

    public void onServerStarted() {
        LandSaveHandler.loadGlobalData();
    }

    public void onServerStopped() {
        LandManager.clearInstance();
    }

    private static long getTime(Entity player) {
        return player.func_184102_h().func_71218_a(DimensionType.field_223227_a_).func_82737_E();
    }

    private static void sendMessage(PlayerEntity player, LandManager.LandTeam team, byte index) {
        ITextComponent message = null;
        long time = LandEventsHandler.getTime((Entity)player);
        int delay = 10;
        switch (index) {
            case 0: {
                message = LandEventsHandler.getDenyMessage(team);
                if (denyFloodControl.getOrDefault(player.func_110124_au(), 0L) > time) {
                    message = null;
                    break;
                }
                denyFloodControl.put(player.func_110124_au(), time + 10L);
                break;
            }
            case 1: {
                message = LandEventsHandler.getEnterMessage(team);
                if (enterFloodControl.getOrDefault(player.func_110124_au(), 0L) > time) {
                    message = null;
                    break;
                }
                enterFloodControl.put(player.func_110124_au(), time + 10L);
                break;
            }
            case 2: {
                message = LandEventsHandler.getExitMessage(team);
                if (exitFloodControl.getOrDefault(player.func_110124_au(), 0L) > time) {
                    message = null;
                    break;
                }
                exitFloodControl.put(player.func_110124_au(), time + 10L);
            }
        }
        if (message != null) {
            player.func_146105_b(message, true);
        }
    }

    private static ITextComponent getDenyMessage(LandManager.LandTeam team) {
        if (team != null && !team.denyMessage.isEmpty()) {
            return new StringTextComponent(team.denyMessage);
        }
        if (!Essentials.config.defaultMessages) {
            return null;
        }
        return CommandManager.makeFormattedComponent("msg.team.deny", null, false, team.teamName);
    }

    private static ITextComponent getEnterMessage(LandManager.LandTeam team) {
        if (team != null && !team.enterMessage.isEmpty()) {
            return new StringTextComponent(team.enterMessage);
        }
        if (!Essentials.config.defaultMessages) {
            return null;
        }
        return CommandManager.makeFormattedComponent("msg.team.enterLand", null, false, team.teamName);
    }

    private static ITextComponent getExitMessage(LandManager.LandTeam team) {
        if (team != null && !team.exitMessage.isEmpty()) {
            return new StringTextComponent(team.exitMessage);
        }
        if (!Essentials.config.defaultMessages) {
            return null;
        }
        return CommandManager.makeFormattedComponent("msg.team.exitLand", null, false, team.teamName);
    }

    public static class ChunkLoadHandler {
        public static MinecraftServer server;
        public static Set<ServerWorld> worlds;
        public static Set<Coordinate> allLoaded;

        @SubscribeEvent
        public static void ServerLoaded(FMLServerStartedEvent event) {
            if (!Essentials.config.chunkLoading) {
                return;
            }
            server.func_212871_a_((Runnable)new TickDelayedTask(1, () -> LandManager.getInstance()._teamMap.forEach((s, t) -> {
                for (Coordinate c : t.land.getLoaded()) {
                    ChunkLoadHandler.addChunks(c);
                }
            })));
        }

        public static boolean removeChunks(Coordinate location) {
            if (!Essentials.config.chunkLoading) {
                return false;
            }
            DimensionType dim = DimensionType.func_186069_a((int)location.dim);
            if (dim == null) {
                return false;
            }
            ServerWorld world = server.func_71218_a(dim);
            if (world == null) {
                return false;
            }
            if (location.y != 0) {
                location = new Coordinate(location.x, 0, location.z, location.dim);
            }
            if (!allLoaded.remove(location)) {
                return false;
            }
            world.func_72863_F().func_217206_a(new ChunkPos(location.x, location.z), false);
            return true;
        }

        public static boolean addChunks(Coordinate location) {
            if (!Essentials.config.chunkLoading) {
                return false;
            }
            DimensionType dim = DimensionType.func_186069_a((int)location.dim);
            if (dim == null) {
                return false;
            }
            ServerWorld world = server.func_71218_a(dim);
            if (world == null) {
                return false;
            }
            if (location.y != 0) {
                location = new Coordinate(location.x, 0, location.z, location.dim);
            }
            if (!allLoaded.add(location)) {
                return false;
            }
            world.func_72863_F().func_217206_a(new ChunkPos(location.x, location.z), true);
            return true;
        }

        static {
            worlds = Sets.newConcurrentHashSet();
            allLoaded = Sets.newConcurrentHashSet();
        }
    }

    public static class InteractEventHandler {
        private DenyReason canUseBlock(PlayerInteractEvent evt) {
            BlockState state = evt.getWorld().func_180495_p(evt.getPos());
            if (blockUseWhiteList.contains(state.func_177230_c().getRegistryName())) {
                return DenyReason.NONE;
            }
            ServerPlayerEntity player = (ServerPlayerEntity)evt.getPlayer();
            Coordinate c = Coordinate.getChunkCoordFromWorldCoord(evt.getPos(), evt.getPlayer().field_71093_bK.func_186068_a());
            Coordinate b = new Coordinate(evt.getPos(), evt.getPlayer().func_130014_f_().func_201675_m());
            LandManager.LandTeam owner = LandManager.getInstance().getLandOwner(c);
            if (owner == null) {
                if (PermissionAPI.hasPermission((PlayerEntity)player, (String)LandEventsHandler.PERMUSEBLOCKWILD)) {
                    return DenyReason.NONE;
                }
                return DenyReason.WILD;
            }
            boolean isFakePlayer = player instanceof FakePlayer;
            if (owner.fakePlayers && isFakePlayer) {
                return DenyReason.NONE;
            }
            boolean owns = owner.canUseStuff(player.func_110124_au(), b);
            if (owns && !PermissionAPI.hasPermission((PlayerEntity)player, (String)LandEventsHandler.PERMUSEBLOCKOWN)) {
                return DenyReason.OURS;
            }
            if (!owns && !PermissionAPI.hasPermission((PlayerEntity)player, (String)LandEventsHandler.PERMUSEBLOCKOTHER)) {
                return DenyReason.OTHER;
            }
            return DenyReason.NONE;
        }

        private DenyReason canUseItem(PlayerInteractEvent evt) {
            if (itemUseWhitelist.contains(evt.getItemStack().func_77973_b().getRegistryName())) {
                return DenyReason.NONE;
            }
            if (Essentials.config.foodWhitelisted && evt.getItemStack().func_222117_E()) {
                return DenyReason.NONE;
            }
            if (ItemList.is(ITEMUSEWHTETAG, evt.getItemStack())) {
                return DenyReason.NONE;
            }
            if (MinecraftForge.EVENT_BUS.post((Event)new DenyItemUseEvent(evt.getEntity(), evt.getItemStack(), DenyItemUseEvent.UseType.RIGHTCLICKBLOCK))) {
                return DenyReason.NONE;
            }
            ServerPlayerEntity player = (ServerPlayerEntity)evt.getPlayer();
            Coordinate c = Coordinate.getChunkCoordFromWorldCoord(evt.getPos(), evt.getPlayer().field_71093_bK.func_186068_a());
            Coordinate b = new Coordinate(evt.getPos(), evt.getPlayer().func_130014_f_().func_201675_m());
            LandManager.LandTeam owner = LandManager.getInstance().getLandOwner(c);
            if (owner == null) {
                if (PermissionAPI.hasPermission((PlayerEntity)player, (String)LandEventsHandler.PERMUSEITEMWILD)) {
                    return DenyReason.NONE;
                }
                return DenyReason.WILD;
            }
            boolean isFakePlayer = player instanceof FakePlayer;
            if (owner.fakePlayers && isFakePlayer) {
                return DenyReason.NONE;
            }
            boolean owns = owner.canUseStuff(player.func_110124_au(), b);
            if (owns && !PermissionAPI.hasPermission((PlayerEntity)player, (String)LandEventsHandler.PERMUSEITEMOWN)) {
                return DenyReason.OURS;
            }
            if (!owns && !PermissionAPI.hasPermission((PlayerEntity)player, (String)LandEventsHandler.PERMUSEITEMOTHER)) {
                return DenyReason.OTHER;
            }
            return DenyReason.NONE;
        }

        private DenyReason canUseMob(PlayerInteractEvent evt, Entity mob) {
            ResourceLocation reg = mob.func_200600_R().getRegistryName();
            if (mobUseWhitelist.contains(reg)) {
                return DenyReason.NONE;
            }
            String[] perms = customMobPerms.getOrDefault(reg, defaultMobPerms);
            if (MinecraftForge.EVENT_BUS.post((Event)new DenyItemUseEvent(evt.getEntity(), evt.getItemStack(), DenyItemUseEvent.UseType.RIGHTCLICKBLOCK))) {
                return DenyReason.NONE;
            }
            ServerPlayerEntity player = (ServerPlayerEntity)evt.getPlayer();
            Coordinate c = Coordinate.getChunkCoordFromWorldCoord(evt.getPos(), evt.getPlayer().field_71093_bK.func_186068_a());
            Coordinate b = new Coordinate(evt.getPos(), evt.getPlayer().func_130014_f_().func_201675_m());
            LandManager.LandTeam owner = LandManager.getInstance().getLandOwner(c);
            if (owner == null || LandManager.getInstance().isPublicMob(evt.getEntity().func_110124_au())) {
                String wildUse = perms[0];
                if (PermissionAPI.hasPermission((PlayerEntity)player, (String)wildUse)) {
                    return DenyReason.NONE;
                }
                return DenyReason.WILD;
            }
            boolean isFakePlayer = player instanceof FakePlayer;
            if (owner.fakePlayers && isFakePlayer) {
                return DenyReason.NONE;
            }
            boolean owns = owner.canUseStuff(player.func_110124_au(), b);
            if (owns && !PermissionAPI.hasPermission((PlayerEntity)player, (String)perms[1])) {
                return DenyReason.OURS;
            }
            if (!owns && !PermissionAPI.hasPermission((PlayerEntity)player, (String)perms[2])) {
                return DenyReason.OTHER;
            }
            return DenyReason.NONE;
        }

        @SubscribeEvent(priority=EventPriority.HIGHEST)
        public void interact(PlayerInteractEvent.LeftClickBlock evt) {
            if (!(evt.getPlayer() instanceof ServerPlayerEntity)) {
                return;
            }
            if (!Essentials.config.landEnabled) {
                return;
            }
            DenyReason rsult = this.canUseBlock((PlayerInteractEvent)evt);
            if (!rsult.test()) {
                Coordinate c = Coordinate.getChunkCoordFromWorldCoord(evt.getPos(), evt.getPlayer().field_71093_bK.func_186068_a());
                boolean isFakePlayer = evt.getPlayer() instanceof FakePlayer;
                if (!isFakePlayer) {
                    ServerPlayerEntity player = (ServerPlayerEntity)evt.getPlayer();
                    switch (rsult) {
                        case OTHER: 
                        case OURS: {
                            LandManager.LandTeam owner = LandManager.getInstance().getLandOwner(c);
                            LandEventsHandler.sendMessage((PlayerEntity)player, owner, (byte)0);
                            break;
                        }
                        case WILD: {
                            player.func_145747_a(CommandManager.makeFormattedComponent("msg.team.nowildperms.useblock"));
                            break;
                        }
                    }
                    player.func_71110_a((Container)player.field_71069_bz, player.field_71069_bz.func_75138_a());
                }
                if (Essentials.config.log_interactions) {
                    Essentials.LOGGER.trace("Cancelled interact due to not allowed to left click that." + c + " " + evt.getPlayer().func_110124_au() + " " + evt.getPlayer().func_200200_C_().func_150254_d());
                }
                evt.setCanceled(true);
                evt.setUseBlock(Event.Result.DENY);
                evt.setUseItem(Event.Result.DENY);
                return;
            }
        }

        @SubscribeEvent(priority=EventPriority.HIGHEST)
        public void interact(PlayerInteractEvent.EntityInteractSpecific evt) {
            if (evt.getSide() == LogicalSide.CLIENT) {
                return;
            }
            if (!Essentials.config.landEnabled) {
                return;
            }
            DenyReason rsult = this.canUseMob((PlayerInteractEvent)evt, evt.getTarget());
            if (!rsult.test()) {
                Coordinate c = Coordinate.getChunkCoordFromWorldCoord(evt.getPos(), evt.getPlayer().field_71093_bK.func_186068_a());
                boolean isFakePlayer = evt.getPlayer() instanceof FakePlayer;
                if (!isFakePlayer) {
                    ServerPlayerEntity player = (ServerPlayerEntity)evt.getPlayer();
                    switch (rsult) {
                        case OTHER: 
                        case OURS: {
                            LandManager.LandTeam owner = LandManager.getInstance().getLandOwner(c);
                            LandEventsHandler.sendMessage((PlayerEntity)player, owner, (byte)0);
                            break;
                        }
                        case WILD: {
                            player.func_145747_a(CommandManager.makeFormattedComponent("msg.team.nowildperms.usemob"));
                            break;
                        }
                    }
                    player.func_71110_a((Container)player.field_71069_bz, player.field_71069_bz.func_75138_a());
                }
                if (Essentials.config.log_interactions) {
                    Essentials.LOGGER.trace("Cancelled interact due to not allowed to use that mob." + c + " " + evt.getPlayer().func_110124_au() + " " + evt.getPlayer().func_200200_C_().func_150254_d());
                }
                evt.setCanceled(true);
                evt.setCancellationResult(ActionResultType.FAIL);
                return;
            }
        }

        @SubscribeEvent(priority=EventPriority.HIGHEST)
        public void interact(PlayerInteractEvent.EntityInteract evt) {
            if (evt.getSide() == LogicalSide.CLIENT) {
                return;
            }
            if (!Essentials.config.landEnabled) {
                return;
            }
            DenyReason rsult = this.canUseMob((PlayerInteractEvent)evt, evt.getTarget());
            if (!rsult.test()) {
                Coordinate c = Coordinate.getChunkCoordFromWorldCoord(evt.getPos(), evt.getPlayer().field_71093_bK.func_186068_a());
                boolean isFakePlayer = evt.getPlayer() instanceof FakePlayer;
                if (!isFakePlayer) {
                    ServerPlayerEntity player = (ServerPlayerEntity)evt.getPlayer();
                    switch (rsult) {
                        case OTHER: 
                        case OURS: {
                            LandManager.LandTeam owner = LandManager.getInstance().getLandOwner(c);
                            LandEventsHandler.sendMessage((PlayerEntity)player, owner, (byte)0);
                            break;
                        }
                        case WILD: {
                            player.func_145747_a(CommandManager.makeFormattedComponent("msg.team.nowildperms.usemob"));
                            break;
                        }
                    }
                    player.func_71110_a((Container)player.field_71069_bz, player.field_71069_bz.func_75138_a());
                }
                if (Essentials.config.log_interactions) {
                    Essentials.LOGGER.trace("Cancelled interact due to not allowed to use that mob." + c + " " + evt.getPlayer().func_110124_au() + " " + evt.getPlayer().func_200200_C_().func_150254_d());
                }
                evt.setCanceled(true);
                evt.setCancellationResult(ActionResultType.FAIL);
                return;
            }
            Coordinate c = Coordinate.getChunkCoordFromWorldCoord(evt.getPos(), evt.getPlayer().field_71093_bK.func_186068_a());
            LandManager.LandTeam owner = LandManager.getInstance().getLandOwner(c);
            if (owner == null) {
                return;
            }
            if (evt.getPlayer() instanceof FakePlayer) {
                return;
            }
            if (owner.isAdmin((Entity)evt.getPlayer())) {
                if (evt.getTarget() instanceof PlayerEntity) {
                    return;
                }
                if (!evt.getWorld().field_72995_K && LandEventsHandler.isPublicToggle(evt.getItemStack()) && evt.getPlayer().func_213453_ef()) {
                    UUID id = evt.getTarget().func_110124_au();
                    boolean isPublic = owner.public_mobs.contains(id);
                    LandManager.getInstance().toggleMobPublic(id, owner);
                    evt.getPlayer().func_145747_a(Essentials.config.getMessage("msg.team.setmob.public." + !isPublic, new Object[0]));
                    evt.setCanceled(true);
                    if (Essentials.config.log_interactions) {
                        Essentials.LOGGER.trace("Cancelled interact due to toggling public mob." + c + " " + evt.getPlayer().func_110124_au() + " " + evt.getPlayer().func_200200_C_().func_150254_d());
                    }
                    return;
                }
                if (!evt.getWorld().field_72995_K && LandEventsHandler.isProtectToggle(evt.getItemStack()) && evt.getPlayer().func_213453_ef() && PermissionAPI.hasPermission((PlayerEntity)evt.getPlayer(), (String)LandEventsHandler.PERMPROTECTMOB)) {
                    UUID id = evt.getTarget().func_110124_au();
                    boolean isPublic = owner.protected_mobs.contains(id);
                    LandManager.getInstance().toggleMobProtect(id, owner);
                    evt.getPlayer().func_145747_a(Essentials.config.getMessage("msg.team.setmob.protect." + !isPublic, new Object[0]));
                    evt.setCanceled(true);
                    if (Essentials.config.log_interactions) {
                        Essentials.LOGGER.trace("Cancelled interact due to toggling protected mob." + c + " " + evt.getPlayer().func_110124_au() + " " + evt.getPlayer().func_200200_C_().func_150254_d());
                    }
                    return;
                }
            }
        }

        @SubscribeEvent(priority=EventPriority.HIGHEST)
        public void interact(PlayerInteractEvent.RightClickItem evt) {
            if (!(evt.getPlayer() instanceof ServerPlayerEntity)) {
                return;
            }
            DenyReason rsult = this.canUseItem((PlayerInteractEvent)evt);
            if (!rsult.test()) {
                Coordinate c = Coordinate.getChunkCoordFromWorldCoord(evt.getPos(), evt.getPlayer().field_71093_bK.func_186068_a());
                boolean isFakePlayer = evt.getPlayer() instanceof FakePlayer;
                if (!isFakePlayer) {
                    ServerPlayerEntity player = (ServerPlayerEntity)evt.getPlayer();
                    switch (rsult) {
                        case OTHER: 
                        case OURS: {
                            LandManager.LandTeam owner = LandManager.getInstance().getLandOwner(c);
                            LandEventsHandler.sendMessage((PlayerEntity)player, owner, (byte)0);
                            break;
                        }
                        case WILD: {
                            player.func_145747_a(CommandManager.makeFormattedComponent("msg.team.nowildperms.useblock"));
                            break;
                        }
                    }
                    player.func_71110_a((Container)player.field_71069_bz, player.field_71069_bz.func_75138_a());
                }
                if (Essentials.config.log_interactions) {
                    Essentials.LOGGER.trace("Cancelled interact due to not allowed to right click with that." + c + " " + evt.getPlayer().func_110124_au() + " " + evt.getPlayer().func_200200_C_().func_150254_d());
                }
                evt.setCancellationResult(ActionResultType.FAIL);
                evt.setCanceled(true);
                return;
            }
        }

        @SubscribeEvent(priority=EventPriority.HIGHEST)
        public void interact(PlayerInteractEvent.RightClickBlock evt) {
            if (!(evt.getPlayer() instanceof ServerPlayerEntity)) {
                return;
            }
            if (!Essentials.config.landEnabled) {
                return;
            }
            Coordinate c = Coordinate.getChunkCoordFromWorldCoord(evt.getPos(), evt.getPlayer().field_71093_bK.func_186068_a());
            Coordinate b = new Coordinate(evt.getPos(), evt.getPlayer().func_130014_f_().func_201675_m());
            LandManager.LandTeam owner = LandManager.getInstance().getLandOwner(c);
            DenyReason rsult = this.canUseBlock((PlayerInteractEvent)evt);
            if (!rsult.test()) {
                boolean isFakePlayer = evt.getPlayer() instanceof FakePlayer;
                if (!isFakePlayer) {
                    ServerPlayerEntity player = (ServerPlayerEntity)evt.getPlayer();
                    switch (rsult) {
                        case OTHER: 
                        case OURS: {
                            LandEventsHandler.sendMessage((PlayerEntity)player, owner, (byte)0);
                            break;
                        }
                        case WILD: {
                            player.func_145747_a(CommandManager.makeFormattedComponent("msg.team.nowildperms.useblock"));
                            break;
                        }
                    }
                    player.func_71110_a((Container)player.field_71069_bz, player.field_71069_bz.func_75138_a());
                }
                if (Essentials.config.log_interactions) {
                    Essentials.LOGGER.trace("Cancelled interact due to not allowed to right click that." + c + " " + evt.getPlayer().func_110124_au() + " " + evt.getPlayer().func_200200_C_().func_150254_d());
                }
                evt.setCanceled(true);
                evt.setUseBlock(Event.Result.DENY);
                evt.setUseItem(Event.Result.DENY);
                return;
            }
            if (owner == null) {
                return;
            }
            PlayerEntity player = evt.getPlayer();
            if (evt.getPlayer() instanceof FakePlayer) {
                return;
            }
            boolean owns = owner.canUseStuff(player.func_110124_au(), b) || owner.canPlaceBlock(player.func_110124_au(), b);
            Coordinate blockLoc = new Coordinate(evt.getPos(), evt.getPlayer().func_130014_f_().func_201675_m());
            if (owns) {
                boolean isPublic;
                if (!evt.getWorld().field_72995_K && LandEventsHandler.isPublicToggle(evt.getItemStack()) && evt.getPlayer().func_213453_ef() && !owner.allPublic && LandManager.getInstance().isAdmin(evt.getPlayer().func_110124_au())) {
                    blockLoc = new Coordinate(evt.getPos(), evt.getPlayer().func_130014_f_().func_201675_m());
                    isPublic = LandManager.getInstance().isPublic(blockLoc, owner);
                    if (isPublic) {
                        LandManager.getInstance().unsetPublic(blockLoc, owner);
                    } else {
                        LandManager.getInstance().setPublic(blockLoc, owner);
                    }
                    evt.getPlayer().func_145747_a(Essentials.config.getMessage("msg.team.setpublic.block." + !isPublic, new Object[0]));
                    evt.setCanceled(true);
                    if (Essentials.config.log_interactions) {
                        Essentials.LOGGER.trace("Cancelled interact due to public toggling. " + c + " " + evt.getPlayer().func_110124_au() + " " + evt.getPlayer().func_200200_C_().func_150254_d());
                    }
                }
                if (!evt.getWorld().field_72995_K && LandEventsHandler.isBreakToggle(evt.getItemStack()) && evt.getPlayer().func_213453_ef() && LandManager.getInstance().isAdmin(evt.getPlayer().func_110124_au())) {
                    blockLoc = new Coordinate(evt.getPos(), evt.getPlayer().func_130014_f_().func_201675_m());
                    isPublic = owner.anyBreakSet.contains(blockLoc);
                    if (owner.anyBreakSet.contains(blockLoc)) {
                        owner.anyBreakSet.remove(blockLoc);
                    } else {
                        owner.anyBreakSet.add(blockLoc);
                    }
                    evt.getPlayer().func_145747_a(Essentials.config.getMessage("msg.team.setbreak.block." + !isPublic, new Object[0]));
                    LandSaveHandler.saveTeam(owner.teamName);
                    evt.setCanceled(true);
                    if (Essentials.config.log_interactions) {
                        Essentials.LOGGER.trace("Cancelled interact due to break toggling. " + c + " " + evt.getPlayer().func_110124_au() + " " + evt.getPlayer().func_200200_C_().func_150254_d());
                    }
                }
                if (!evt.getWorld().field_72995_K && LandEventsHandler.isPlaceToggle(evt.getItemStack()) && evt.getPlayer().func_213453_ef() && LandManager.getInstance().isAdmin(evt.getPlayer().func_110124_au())) {
                    blockLoc = new Coordinate(evt.getPos(), evt.getPlayer().func_130014_f_().func_201675_m());
                    isPublic = owner.anyPlaceSet.contains(blockLoc);
                    if (owner.anyPlaceSet.contains(blockLoc)) {
                        owner.anyPlaceSet.remove(blockLoc);
                    } else {
                        owner.anyPlaceSet.add(blockLoc);
                    }
                    evt.getPlayer().func_145747_a(Essentials.config.getMessage("msg.team.setplace.block." + !isPublic, new Object[0]));
                    LandSaveHandler.saveTeam(owner.teamName);
                    evt.setCanceled(true);
                    if (Essentials.config.log_interactions) {
                        Essentials.LOGGER.trace("Cancelled interact due to place toggling. " + c + " " + evt.getPlayer().func_110124_au() + " " + evt.getPlayer().func_200200_C_().func_150254_d());
                    }
                }
                return;
            }
        }
    }

    public static class EntityEventHandler {
        public static Set<UUID> showLandSet = Sets.newHashSet();

        private boolean canTakeDamage(Entity in, LandManager.LandTeam land_owner) {
            if (land_owner == null) {
                return in == null || !invuln.contains(in.func_200600_R().getRegistryName());
            }
            if (LandManager.getInstance().isPublicMob(in.func_110124_au())) {
                return false;
            }
            if (LandManager.getInstance().isProtectedMob(in.func_110124_au())) {
                return false;
            }
            if (in instanceof ServerPlayerEntity) {
                return !land_owner.noPlayerDamage;
            }
            if (in instanceof INPC) {
                return !land_owner.noNPCDamage;
            }
            if (in instanceof ItemFrameEntity) {
                return !land_owner.protectFrames;
            }
            return true;
        }

        private void sendNearbyChunks(ServerPlayerEntity player) {
            BasicParticleType otherowned = ParticleTypes.field_197610_c;
            BasicParticleType owned = ParticleTypes.field_197632_y;
            BasicParticleType chunkloaded = ParticleTypes.field_197633_z;
            BasicParticleType show = null;
            LandManager.LandTeam us = LandManager.getTeam((Entity)player);
            int dim = player.field_71093_bK.func_186068_a();
            for (int dx = -3; dx <= 3; ++dx) {
                for (int dz = -3; dz <= 3; ++dz) {
                    int x = player.field_70176_ah + dx;
                    int z = player.field_70164_aj + dz;
                    Coordinate c = new Coordinate(x, 0, z, dim);
                    int y = player.field_70162_ai;
                    boolean cl = ChunkLoadHandler.allLoaded.contains(c);
                    for (int dy = -3; dy <= 3; ++dy) {
                        LandManager.LandTeam team;
                        SSpawnParticlePacket packet;
                        int z1;
                        int y1;
                        int x1;
                        y = player.field_70162_ai + dy;
                        c = new Coordinate(x, y, z, dim);
                        if (cl) {
                            show = chunkloaded;
                            x1 = x * 16;
                            y1 = y * 16;
                            z1 = z * 16;
                            for (int i1 = 3; i1 < 14; i1 += 4) {
                                for (int j1 = 3; j1 < 14; j1 += 4) {
                                    packet = new SSpawnParticlePacket((IParticleData)show, false, (double)(x1 + i1), (double)(y1 + j1), (double)(z1 + 3), 0.0f, 0.0f, 0.0f, 0.0f, 1);
                                    player.field_71135_a.func_147359_a((IPacket)packet);
                                    packet = new SSpawnParticlePacket((IParticleData)show, false, (double)(x1 + i1), (double)(y1 + j1), (double)(z1 + 13), 0.0f, 0.0f, 0.0f, 0.0f, 1);
                                    player.field_71135_a.func_147359_a((IPacket)packet);
                                    packet = new SSpawnParticlePacket((IParticleData)show, false, (double)(x1 + 3), (double)(y1 + j1), (double)(z1 + i1), 0.0f, 0.0f, 0.0f, 0.0f, 1);
                                    player.field_71135_a.func_147359_a((IPacket)packet);
                                    packet = new SSpawnParticlePacket((IParticleData)show, false, (double)(x1 + 13), (double)(y1 + j1), (double)(z1 + i1), 0.0f, 0.0f, 0.0f, 0.0f, 1);
                                    player.field_71135_a.func_147359_a((IPacket)packet);
                                }
                            }
                        }
                        BasicParticleType basicParticleType = (team = LandManager.getInstance().getLandOwner(c)) == null ? null : (show = team == us ? owned : otherowned);
                        if (show == null || y < 0 || y >= 16) continue;
                        x1 = x * 16;
                        y1 = y * 16;
                        z1 = z * 16;
                        for (int i1 = 1; i1 < 16; i1 += 4) {
                            for (int j1 = 1; j1 < 16; j1 += 4) {
                                packet = new SSpawnParticlePacket((IParticleData)show, false, (double)(x1 + i1), (double)(y1 + j1), (double)(z1 + 1), 0.0f, 0.0f, 0.0f, 0.0f, 1);
                                player.field_71135_a.func_147359_a((IPacket)packet);
                                packet = new SSpawnParticlePacket((IParticleData)show, false, (double)(x1 + i1), (double)(y1 + j1), (double)(z1 + 15), 0.0f, 0.0f, 0.0f, 0.0f, 1);
                                player.field_71135_a.func_147359_a((IPacket)packet);
                                packet = new SSpawnParticlePacket((IParticleData)show, false, (double)(x1 + 1), (double)(y1 + j1), (double)(z1 + i1), 0.0f, 0.0f, 0.0f, 0.0f, 1);
                                player.field_71135_a.func_147359_a((IPacket)packet);
                                packet = new SSpawnParticlePacket((IParticleData)show, false, (double)(x1 + 15), (double)(y1 + j1), (double)(z1 + i1), 0.0f, 0.0f, 0.0f, 0.0f, 1);
                                player.field_71135_a.func_147359_a((IPacket)packet);
                            }
                        }
                    }
                }
            }
        }

        @SubscribeEvent(priority=EventPriority.HIGHEST)
        public void death(LivingDeathEvent evt) {
            LandManager.LandTeam team;
            if (evt.getEntity().func_130014_f_().field_72995_K) {
                return;
            }
            if (!Essentials.config.landEnabled) {
                return;
            }
            UUID id = evt.getEntity().func_110124_au();
            if (LandManager.getInstance()._protected_mobs.containsKey(id)) {
                team = LandManager.getInstance()._protected_mobs.remove(id);
                team.protected_mobs.remove(id);
                LandSaveHandler.saveTeam(team.teamName);
            }
            if (LandManager.getInstance()._public_mobs.containsKey(id)) {
                team = LandManager.getInstance()._public_mobs.remove(id);
                team.public_mobs.remove(id);
                LandSaveHandler.saveTeam(team.teamName);
            }
        }

        @SubscribeEvent
        public void update(LivingEvent.LivingUpdateEvent evt) {
            if (evt.getEntity().func_130014_f_().field_72995_K) {
                return;
            }
            if (!Essentials.config.landEnabled) {
                return;
            }
            if (evt.getEntityLiving() instanceof ServerPlayerEntity && evt.getEntityLiving().field_70173_aa > 10) {
                BlockPos here;
                BlockPos old;
                ServerPlayerEntity player = (ServerPlayerEntity)evt.getEntityLiving();
                if (showLandSet.contains(player.func_110124_au()) && player.field_70173_aa % 20 == 0) {
                    this.sendNearbyChunks(player);
                }
                if ((old = new BlockPos(player.field_71091_bM, player.field_71096_bN, player.field_71097_bO)).equals((Object)(here = new BlockPos(player.field_71094_bP, player.field_71095_bQ, player.field_71085_bR)))) {
                    return;
                }
                Coordinate newChunk = Coordinate.getChunkCoordFromWorldCoord(here, player.field_71093_bK.func_186068_a());
                Coordinate oldChunk = Coordinate.getChunkCoordFromWorldCoord(old, player.func_130014_f_().func_201675_m());
                boolean isNewOwned = LandManager.getInstance().isOwned(newChunk);
                boolean isOldOwned = LandManager.getInstance().isOwned(oldChunk);
                CompoundNBT tag = PlayerDataHandler.getCustomDataTag((PlayerEntity)player);
                CompoundNBT entry_log = tag.func_74775_l("last_entered_chunk");
                BlockPos entry_point = old;
                Coordinate last_chunk = oldChunk;
                if (!isNewOwned && !isOldOwned) {
                    entry_point = old;
                    entry_log.func_218657_a("from", (INBT)NBTUtil.func_186859_a((BlockPos)entry_point));
                    BlockPos p = new BlockPos(newChunk.x, newChunk.y, newChunk.z);
                    CompoundNBT prev_chunk = NBTUtil.func_186859_a((BlockPos)p);
                    prev_chunk.func_74768_a("W", newChunk.dim);
                    entry_log.func_218657_a("chunk", (INBT)prev_chunk);
                    tag.func_218657_a("last_entered_chunk", (INBT)entry_log);
                    PlayerDataHandler.saveCustomData((PlayerEntity)player);
                } else {
                    boolean owns;
                    LandManager.LandTeam team = LandManager.getInstance().getLandOwner(newChunk);
                    LandManager.LandTeam team1 = LandManager.getInstance().getLandOwner(oldChunk);
                    if (!entry_log.isEmpty()) {
                        entry_point = NBTUtil.func_186861_c((CompoundNBT)entry_log.func_74775_l("from"));
                        CompoundNBT prev_chunk = entry_log.func_74775_l("chunk");
                        last_chunk = new Coordinate(NBTUtil.func_186861_c((CompoundNBT)prev_chunk), prev_chunk.func_74762_e("W"));
                    }
                    if (!lastLeaveMessage.containsKey(evt.getEntity().func_110124_au())) {
                        lastLeaveMessage.put(evt.getEntity().func_110124_au(), System.currentTimeMillis() - 1L);
                    }
                    if (!lastEnterMessage.containsKey(evt.getEntity().func_110124_au())) {
                        lastEnterMessage.put(evt.getEntity().func_110124_au(), System.currentTimeMillis() - 1L);
                    }
                    ITextComponent message = null;
                    boolean bl = owns = team != null && team.isMember((Entity)player);
                    if (!isNewOwned && !PermissionAPI.hasPermission((PlayerEntity)player, (String)LandEventsHandler.PERMENTERWILD)) {
                        message = CommandManager.makeFormattedComponent("msg.team.nowildperms.noenter");
                    } else if (isNewOwned && owns && !PermissionAPI.hasPermission((PlayerEntity)player, (String)LandEventsHandler.PERMENTEROWN)) {
                        message = CommandManager.makeFormattedComponent("msg.team.owned.noenter");
                    } else if (isNewOwned && !owns && !PermissionAPI.hasPermission((PlayerEntity)player, (String)LandEventsHandler.PERMENTEROTHER)) {
                        message = CommandManager.makeFormattedComponent("msg.team.other.noenter");
                    }
                    if (message != null) {
                        if (!last_chunk.equals(newChunk)) {
                            entry_point = old;
                            entry_log.func_218657_a("from", (INBT)NBTUtil.func_186859_a((BlockPos)entry_point));
                            BlockPos p = new BlockPos(newChunk.x, newChunk.y, newChunk.z);
                            CompoundNBT prev_chunk = NBTUtil.func_186859_a((BlockPos)p);
                            prev_chunk.func_74768_a("W", newChunk.dim);
                            entry_log.func_218657_a("chunk", (INBT)prev_chunk);
                            tag.func_218657_a("last_entered_chunk", (INBT)entry_log);
                            PlayerDataHandler.saveCustomData((PlayerEntity)player);
                        }
                        Vec3d oldV = new Vec3d((Vec3i)entry_point);
                        player.field_71135_a.func_147364_a(oldV.field_72450_a + 0.5, oldV.field_72448_b + 0.5, oldV.field_72449_c + 0.5, player.field_70177_z, player.field_70125_A);
                        player.func_145747_a(message);
                        return;
                    }
                    entry_log.func_218657_a("from", (INBT)NBTUtil.func_186859_a((BlockPos)here));
                    tag.func_218657_a("last_entered_chunk", (INBT)entry_log);
                    PlayerDataHandler.saveCustomData((PlayerEntity)player);
                    if (team != null) {
                        if (!team.equals(team1)) {
                            long last;
                            if (team1 != null && (last = lastLeaveMessage.get(evt.getEntity().func_110124_au()).longValue()) < System.currentTimeMillis()) {
                                LandEventsHandler.sendMessage((PlayerEntity)player, team1, (byte)2);
                                lastLeaveMessage.put(evt.getEntity().func_110124_au(), System.currentTimeMillis() + 100L);
                            }
                            if ((last = lastEnterMessage.get(evt.getEntity().func_110124_au()).longValue()) < System.currentTimeMillis()) {
                                LandEventsHandler.sendMessage((PlayerEntity)player, team, (byte)1);
                                lastLeaveMessage.put(evt.getEntity().func_110124_au(), System.currentTimeMillis() + 100L);
                            }
                        }
                    } else {
                        long last = lastLeaveMessage.get(evt.getEntity().func_110124_au());
                        if (last < System.currentTimeMillis()) {
                            LandEventsHandler.sendMessage((PlayerEntity)player, team1, (byte)2);
                            lastLeaveMessage.put(evt.getEntity().func_110124_au(), System.currentTimeMillis() + 100L);
                        }
                    }
                }
            }
        }

        @SubscribeEvent(priority=EventPriority.HIGHEST)
        public void attack(AttackEntityEvent evt) {
            if (evt.getEntity().func_130014_f_().field_72995_K) {
                return;
            }
            if (!Essentials.config.landEnabled) {
                return;
            }
            Coordinate c = Coordinate.getChunkCoordFromWorldCoord(evt.getTarget().func_180425_c(), evt.getPlayer().field_71093_bK.func_186068_a());
            LandManager.LandTeam owner = LandManager.getInstance().getLandOwner(c);
            if (!this.canTakeDamage(evt.getTarget(), owner)) {
                evt.setCanceled(true);
                return;
            }
            if (owner == null) {
                return;
            }
            PlayerEntity attacker = evt.getPlayer();
            if (owner.fakePlayers && evt.getPlayer() instanceof FakePlayer) {
                return;
            }
            BlockPos pos = evt.getTarget().func_180425_c();
            Coordinate b = Coordinate.getChunkCoordFromWorldCoord(pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p(), attacker.field_71093_bK);
            if (evt.getTarget() instanceof ItemFrameEntity && !owner.canBreakBlock(attacker.func_110124_au(), b)) {
                evt.setCanceled(true);
                return;
            }
            if (owner.protected_mobs.contains(evt.getTarget().func_110124_au())) {
                evt.setCanceled(true);
                return;
            }
        }

        @SubscribeEvent(priority=EventPriority.HIGHEST)
        public void mobGriefing(EntityMobGriefingEvent evt) {
            if (evt.getEntity() == null) {
                return;
            }
            if (evt.getEntity().func_130014_f_().field_72995_K) {
                return;
            }
            if (!Essentials.config.landEnabled) {
                return;
            }
            if (!Essentials.config.noMobGriefing) {
                return;
            }
            if (MobManager.isWhitelistedForGriefing(evt.getEntity())) {
                return;
            }
            Coordinate c = Coordinate.getChunkCoordFromWorldCoord(evt.getEntity().func_180425_c(), evt.getEntity().field_71093_bK.func_186068_a());
            LandManager.LandTeam owner = LandManager.getInstance().getLandOwner(c);
            if (owner == null) {
                return;
            }
            if (owner.fakePlayers && evt.getEntity() instanceof FakePlayer) {
                return;
            }
            evt.setResult(Event.Result.DENY);
        }

        @SubscribeEvent(priority=EventPriority.HIGHEST)
        public void attack(LivingAttackEvent evt) {
            if (evt.getEntity().func_130014_f_().field_72995_K) {
                return;
            }
            if (!Essentials.config.landEnabled) {
                return;
            }
            Coordinate c = Coordinate.getChunkCoordFromWorldCoord(evt.getEntity().func_180425_c(), evt.getEntity().field_71093_bK.func_186068_a());
            LandManager.LandTeam owner = LandManager.getInstance().getLandOwner(c);
            if (!this.canTakeDamage(evt.getEntity(), owner)) {
                evt.setCanceled(true);
                return;
            }
            if (owner == null) {
                return;
            }
            if (evt.getEntity() instanceof PlayerEntity) {
                Entity damageSource;
                LandManager.LandTeam players = LandManager.getTeam(evt.getEntity());
                if (!players.friendlyFire && (damageSource = evt.getSource().func_76346_g()) instanceof PlayerEntity && LandEventsHandler.sameTeam(damageSource, evt.getEntity())) {
                    evt.setCanceled(true);
                    return;
                }
            }
            if (owner.fakePlayers && evt.getSource().func_76346_g() instanceof FakePlayer) {
                return;
            }
            if (owner.protected_mobs.contains(evt.getEntity().func_110124_au())) {
                evt.setCanceled(true);
                return;
            }
        }

        @SubscribeEvent
        public void projectileImpact(ProjectileImpactEvent evt) {
            if (evt.getEntity().func_130014_f_().field_72995_K) {
                return;
            }
            if (!Essentials.config.landEnabled) {
                return;
            }
            if (evt.getRayTraceResult().func_216346_c() == RayTraceResult.Type.MISS) {
                return;
            }
            if (!(evt.getRayTraceResult() instanceof EntityRayTraceResult)) {
                return;
            }
            EntityRayTraceResult hit = (EntityRayTraceResult)evt.getRayTraceResult();
            Entity target = hit.func_216348_a();
            Coordinate c = Coordinate.getChunkCoordFromWorldCoord(target.func_180425_c(), evt.getEntity().field_71093_bK.func_186068_a());
            LandManager.LandTeam owner = LandManager.getInstance().getLandOwner(c);
            if (!this.canTakeDamage(target, owner)) {
                evt.setCanceled(true);
                return;
            }
            if (owner == null) {
                return;
            }
            if (owner.protected_mobs.contains(target.func_110124_au())) {
                evt.setCanceled(true);
                return;
            }
        }

        @SubscribeEvent(priority=EventPriority.HIGHEST)
        public void attack(LivingHurtEvent evt) {
            if (evt.getEntity().func_130014_f_().field_72995_K) {
                return;
            }
            if (!Essentials.config.landEnabled) {
                return;
            }
            Coordinate c = Coordinate.getChunkCoordFromWorldCoord(evt.getEntity().func_180425_c(), evt.getEntity().field_71093_bK.func_186068_a());
            LandManager.LandTeam owner = LandManager.getInstance().getLandOwner(c);
            if (!this.canTakeDamage(evt.getEntity(), owner)) {
                evt.setCanceled(true);
                return;
            }
            if (owner == null) {
                return;
            }
            if (owner.protected_mobs.contains(evt.getEntity().func_110124_au())) {
                evt.setCanceled(true);
                return;
            }
        }

        @SubscribeEvent(priority=EventPriority.HIGHEST)
        public void spawn(LivingSpawnEvent.SpecialSpawn evt) {
            if (!Essentials.config.landEnabled) {
                return;
            }
            if (evt.getEntity().func_130014_f_().field_72995_K) {
                return;
            }
            Coordinate c = Coordinate.getChunkCoordFromWorldCoord(evt.getEntity().func_180425_c(), evt.getEntity().field_71093_bK.func_186068_a());
            LandManager.LandTeam owner = LandManager.getInstance().getLandOwner(c);
            if (owner == null) {
                return;
            }
            if (owner.noMobSpawn) {
                evt.setResult(Event.Result.DENY);
                return;
            }
        }

        @SubscribeEvent(priority=EventPriority.HIGHEST)
        public void spawn(LivingSpawnEvent.CheckSpawn evt) {
            if (!Essentials.config.landEnabled) {
                return;
            }
            if (evt.getEntity().func_130014_f_().field_72995_K) {
                return;
            }
            Coordinate c = Coordinate.getChunkCoordFromWorldCoord(evt.getEntity().func_180425_c(), evt.getEntity().field_71093_bK.func_186068_a());
            LandManager.LandTeam owner = LandManager.getInstance().getLandOwner(c);
            if (owner == null) {
                return;
            }
            if (owner.noMobSpawn) {
                evt.setResult(Event.Result.DENY);
                return;
            }
        }
    }

    public static class BlockEventHandler {
        public void checkPlace(BlockEvent evt, PlayerEntity player) {
            if (!(player instanceof ServerPlayerEntity)) {
                return;
            }
            if (blockPlaceWhiteList.contains(evt.getWorld().func_180495_p(evt.getPos()).func_177230_c().getRegistryName())) {
                return;
            }
            Coordinate c = Coordinate.getChunkCoordFromWorldCoord(evt.getPos(), player.field_71093_bK.func_186068_a());
            Coordinate b = new Coordinate(evt.getPos(), player.field_71093_bK.func_186068_a());
            LandManager.LandTeam team = LandManager.getInstance().getLandOwner(c);
            if (team == null) {
                if (PermissionAPI.hasPermission((PlayerEntity)player, (String)LandEventsHandler.PERMPLACEWILD)) {
                    return;
                }
                player.func_145747_a(CommandManager.makeFormattedComponent("msg.team.nowildperms.placeblock"));
                evt.setCanceled(true);
                ((ServerPlayerEntity)player).func_71110_a((Container)player.field_71069_bz, player.field_71069_bz.func_75138_a());
                return;
            }
            boolean isFakePlayer = player instanceof FakePlayer;
            if (!team.fakePlayers || !isFakePlayer) {
                boolean owns = team.canPlaceBlock(player.func_110124_au(), b);
                if (owns && !PermissionAPI.hasPermission((PlayerEntity)player, (String)LandEventsHandler.PERMPLACEOWN)) {
                    evt.setCanceled(true);
                    if (!isFakePlayer) {
                        LandEventsHandler.sendMessage(player, team, (byte)0);
                        ((ServerPlayerEntity)player).func_71110_a((Container)player.field_71069_bz, player.field_71069_bz.func_75138_a());
                    }
                    return;
                }
                if (!owns && !PermissionAPI.hasPermission((PlayerEntity)player, (String)LandEventsHandler.PERMPLACEOTHER)) {
                    evt.setCanceled(true);
                    if (!isFakePlayer) {
                        LandEventsHandler.sendMessage(player, team, (byte)0);
                        ((ServerPlayerEntity)player).func_71110_a((Container)player.field_71069_bz, player.field_71069_bz.func_75138_a());
                    }
                    return;
                }
            }
        }

        public void checkBreak(BlockEvent evt, PlayerEntity player) {
            if (Essentials.config.landEnabled && player != null) {
                if (blockBreakWhiteList.contains(evt.getWorld().func_180495_p(evt.getPos()).func_177230_c().getRegistryName())) {
                    return;
                }
                Coordinate c = Coordinate.getChunkCoordFromWorldCoord(evt.getPos(), player.field_71093_bK.func_186068_a());
                Coordinate b = new Coordinate(evt.getPos(), player.field_71093_bK.func_186068_a());
                LandManager.LandTeam team = LandManager.getInstance().getLandOwner(c);
                if (team == null) {
                    if (PermissionAPI.hasPermission((PlayerEntity)player, (String)LandEventsHandler.PERMBREAKWILD)) {
                        return;
                    }
                    player.func_145747_a(CommandManager.makeFormattedComponent("msg.team.nowildperms.breakblock"));
                    evt.setCanceled(true);
                    return;
                }
                if (!team.fakePlayers || !(player instanceof FakePlayer)) {
                    boolean owns = team.canBreakBlock(player.func_110124_au(), b);
                    if (owns && !PermissionAPI.hasPermission((PlayerEntity)player, (String)LandEventsHandler.PERMBREAKOWN)) {
                        LandEventsHandler.sendMessage(player, team, (byte)0);
                        evt.setCanceled(true);
                        return;
                    }
                    if (!owns && !PermissionAPI.hasPermission((PlayerEntity)player, (String)LandEventsHandler.PERMBREAKOTHER)) {
                        LandEventsHandler.sendMessage(player, team, (byte)0);
                        evt.setCanceled(true);
                        return;
                    }
                }
            }
        }

        @SubscribeEvent(priority=EventPriority.HIGHEST)
        public void trample(BlockEvent.FarmlandTrampleEvent evt) {
            LivingEntity test;
            if (evt.getEntity().func_130014_f_().field_72995_K) {
                return;
            }
            if (!Essentials.config.landEnabled) {
                return;
            }
            Coordinate c = Coordinate.getChunkCoordFromWorldCoord(evt.getPos(), evt.getWorld().func_201675_m());
            Entity trampler = evt.getEntity();
            LandManager.LandTeam team = LandManager.getInstance().getLandOwner(c);
            if (team == null) {
                return;
            }
            PlayerEntity player = null;
            if (trampler instanceof PlayerEntity) {
                player = (PlayerEntity)trampler;
            }
            if ((test = OwnerManager.OWNERCHECK.getOwner(trampler)) instanceof PlayerEntity) {
                player = (PlayerEntity)test;
            }
            this.checkBreak((BlockEvent)evt, player);
            if (!evt.isCanceled() && Essentials.config.log_interactions) {
                Essentials.LOGGER.trace(c + " trample " + evt.getPos() + " " + trampler.func_110124_au() + " " + trampler.func_200200_C_().func_150254_d());
            }
        }

        @SubscribeEvent(priority=EventPriority.HIGHEST)
        public void placeBlocks(BlockEvent.EntityPlaceEvent evt) {
            if (!(evt.getEntity() instanceof ServerPlayerEntity)) {
                return;
            }
            if (!Essentials.config.landEnabled) {
                return;
            }
            this.checkPlace((BlockEvent)evt, (PlayerEntity)evt.getEntity());
            if (!evt.isCanceled() && Essentials.config.log_interactions) {
                Coordinate c = Coordinate.getChunkCoordFromWorldCoord(evt.getPos(), evt.getWorld().func_201675_m());
                Essentials.LOGGER.trace(c + " place " + evt.getPos() + " " + evt.getPlacedAgainst() + " " + evt.getPlacedBlock() + " " + evt.getEntity().func_110124_au() + " " + evt.getEntity().func_200200_C_().func_150254_d());
            }
        }

        @SubscribeEvent(priority=EventPriority.HIGHEST)
        public void BreakBlock(BlockEvent.BreakEvent evt) {
            if (!(evt.getPlayer() instanceof ServerPlayerEntity)) {
                return;
            }
            if (!Essentials.config.landEnabled) {
                return;
            }
            PlayerEntity player = evt.getPlayer();
            this.checkBreak((BlockEvent)evt, player);
            if (!evt.isCanceled() && Essentials.config.log_interactions) {
                Coordinate c = Coordinate.getChunkCoordFromWorldCoord(evt.getPos(), evt.getWorld().func_201675_m());
                Essentials.LOGGER.trace(c + " break " + evt.getPos() + " " + evt.getState() + " " + evt.getPlayer().func_110124_au() + " " + evt.getPlayer().func_200200_C_().func_150254_d());
            }
        }

        @SubscribeEvent(priority=EventPriority.HIGHEST)
        public void bucket(FillBucketEvent event) {
            if (event.getPlayer().func_130014_f_().field_72995_K) {
                return;
            }
            if (!Essentials.config.landEnabled) {
                return;
            }
            BlockPos pos = event.getPlayer().func_180425_c();
            if (event.getTarget() instanceof BlockRayTraceResult && event.getTarget().func_216346_c() != RayTraceResult.Type.MISS) {
                BlockRayTraceResult trace = (BlockRayTraceResult)event.getTarget();
                pos = trace.func_216350_a().func_177972_a(trace.func_216354_b());
            }
            PlayerEntity player = event.getPlayer();
            BlockEvent.BreakEvent evt = new BlockEvent.BreakEvent(event.getWorld(), pos, event.getWorld().func_180495_p(pos), player);
            this.checkPlace((BlockEvent)evt, player);
            this.checkBreak((BlockEvent)evt, player);
            if (evt.isCanceled()) {
                event.setCanceled(true);
            } else if (Essentials.config.log_interactions) {
                Coordinate c = Coordinate.getChunkCoordFromWorldCoord(evt.getPos(), evt.getWorld().func_201675_m());
                Essentials.LOGGER.trace(c + " bucket " + evt.getPos() + " " + player.func_110124_au() + " " + player.func_200200_C_().func_150254_d() + " " + event.getFilledBucket() + " " + event.getEmptyBucket());
            }
        }
    }

    public static enum DenyReason {
        NONE,
        WILD,
        OTHER,
        OURS;


        public boolean test() {
            return this == NONE;
        }
    }
}

