/*
 * Decompiled with CFR 0.152.
 */
package thut.essentials.land;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.mojang.authlib.GameProfile;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.server.MinecraftServer;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.fml.LogicalSidedProvider;
import thut.essentials.Essentials;
import thut.essentials.land.LandEventsHandler;
import thut.essentials.land.LandSaveHandler;
import thut.essentials.util.Coordinate;

public class LandManager {
    static LandManager instance;
    public static final int VERSION = 1;
    public Map<String, LandTeam> _teamMap = Maps.newConcurrentMap();
    protected Map<Coordinate, LandTeam> _landMap = Maps.newConcurrentMap();
    protected Map<UUID, LandTeam> _playerTeams = Maps.newConcurrentMap();
    protected Map<UUID, Invites> invites = Maps.newHashMap();
    protected Map<UUID, LandTeam> _protected_mobs = Maps.newConcurrentMap();
    protected Map<UUID, LandTeam> _public_mobs = Maps.newConcurrentMap();
    public int version = 1;

    public static void clearInstance() {
        if (instance != null) {
            LandSaveHandler.saveGlobalData();
            for (String s : LandManager.instance._teamMap.keySet()) {
                LandSaveHandler.saveTeam(s);
            }
        }
        instance = null;
    }

    public static LandManager getInstance() {
        if (instance == null) {
            LandSaveHandler.loadGlobalData();
        }
        return instance;
    }

    public static LandTeam getTeam(UUID id) {
        LandTeam playerTeam = LandManager.getInstance()._playerTeams.get(id);
        if (playerTeam == null) {
            return LandManager.getDefaultTeam();
        }
        return playerTeam;
    }

    public static LandTeam getTeam(Entity player) {
        return LandManager.getTeam(player.func_110124_au());
    }

    public static LandTeam getDefaultTeam() {
        return LandManager.getInstance().getTeam(Essentials.config.defaultTeamName, true);
    }

    public static LandTeam getWildTeam() {
        if (!Essentials.config.wildernessTeam) {
            return null;
        }
        LandTeam wilds = LandManager.getInstance().getTeam(Essentials.config.wildernessTeamName, false);
        if (wilds == null) {
            wilds = LandManager.getInstance().getTeam(Essentials.config.wildernessTeamName, true);
            wilds.reserved = true;
            wilds.allPublic = true;
            wilds.enterMessage = " ";
            wilds.exitMessage = " ";
            wilds.denyMessage = " ";
        }
        return wilds;
    }

    public static boolean owns(Entity player, Coordinate chunk) {
        return LandManager.getTeam(player).equals(LandManager.getInstance().getLandOwner(chunk));
    }

    LandManager() {
    }

    public boolean isPublicMob(UUID mobId) {
        return this._public_mobs.containsKey(mobId);
    }

    public boolean isProtectedMob(UUID mobId) {
        return this._protected_mobs.containsKey(mobId);
    }

    public void toggleMobProtect(UUID mob, LandTeam team) {
        if (this._protected_mobs.containsKey(mob)) {
            this._protected_mobs.remove(mob);
            team.protected_mobs.remove(mob);
        } else {
            this._protected_mobs.put(mob, team);
            team.protected_mobs.add(mob);
        }
        LandSaveHandler.saveTeam(team.teamName);
    }

    public void toggleMobPublic(UUID mob, LandTeam team) {
        if (this._public_mobs.containsKey(mob)) {
            this._public_mobs.remove(mob);
            team.public_mobs.remove(mob);
        } else {
            this._public_mobs.put(mob, team);
            team.public_mobs.add(mob);
        }
        LandSaveHandler.saveTeam(team.teamName);
    }

    public void renameTeam(String oldName, String newName) throws IllegalArgumentException {
        if (this._teamMap.containsKey(newName)) {
            throw new IllegalArgumentException("thutessentials.team.teamexists");
        }
        LandTeam team = this._teamMap.remove(oldName);
        if (team == null) {
            throw new IllegalArgumentException("thutessentials.team.notfound");
        }
        this._teamMap.put(newName, team);
        for (Invites i : this.invites.values()) {
            if (!i.teams.remove(oldName)) continue;
            i.teams.add(newName);
        }
        team.teamName = newName;
        LandSaveHandler.saveTeam(newName);
        LandSaveHandler.deleteTeam(oldName);
    }

    public void removeTeam(String teamName) {
        LandTeam _default;
        LandTeam team = this._teamMap.remove(teamName);
        if (team == (_default = LandManager.getDefaultTeam())) {
            return;
        }
        for (Coordinate c : team.land.land) {
            this._landMap.remove(c);
        }
        MinecraftServer server = (MinecraftServer)LogicalSidedProvider.INSTANCE.get(LogicalSide.SERVER);
        for (UUID id : team.member) {
            _default.member.add(id);
            this._playerTeams.put(id, _default);
            try {
                ServerPlayerEntity player = server.func_184103_al().func_177451_a(id);
                if (player == null) continue;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        LandSaveHandler.saveTeam(_default.teamName);
        for (Invites i : this.invites.values()) {
            i.teams.remove(teamName);
        }
        LandSaveHandler.deleteTeam(teamName);
    }

    public void addTeamLand(String team, Coordinate land, boolean sync) {
        LandTeam t = this._teamMap.get(team);
        if (t == null) {
            Thread.dumpStack();
            return;
        }
        Essentials.LOGGER.debug("claim: " + team + " Coord: " + land);
        LandTeam prev = this._landMap.remove(land);
        t.land.addLand(land);
        if (prev != null) {
            prev.land.removeLand(land);
        }
        this._landMap.put(land, t);
        if (sync) {
            if (prev != null) {
                LandSaveHandler.saveTeam(prev.teamName);
            }
            LandSaveHandler.saveTeam(team);
        }
    }

    public void addAdmin(UUID admin, String team) {
        LandTeam t = this.getTeam(team, true);
        t.admin.add(admin);
        LandSaveHandler.saveTeam(team);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void addToTeam(UUID member, String team) {
        LandTeam t = this.getTeam(team, true);
        if (t.admin.isEmpty() && !t.teamName.equals(Essentials.config.defaultTeamName)) {
            t.admin.add(member);
        }
        if (this._playerTeams.containsKey(member)) {
            LandTeam old = this._playerTeams.remove(member);
            old.member.remove(member);
            old.admin.remove(member);
            LandSaveHandler.saveTeam(old.teamName);
        }
        t.member.add(member);
        this._playerTeams.put(member, t);
        Invites invite = this.invites.get(member);
        if (invite != null) {
            invite.teams.remove(team);
        }
        LandSaveHandler.saveTeam(team);
        MinecraftServer server = (MinecraftServer)LogicalSidedProvider.INSTANCE.get(LogicalSide.SERVER);
        try {
            ServerPlayerEntity player = server.func_184103_al().func_177451_a(member);
            if (player == null) return;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public int countLand(String team) {
        LandTeam t = this._teamMap.get(team);
        if (t != null) {
            return t.land.countLand();
        }
        return 0;
    }

    public void createTeam(UUID member, String team) throws IllegalArgumentException {
        if (this._teamMap.containsKey(team)) {
            throw new IllegalArgumentException("thutessentials.team.teamexists");
        }
        LandTeam theTeam = this.getTeam(team, true);
        if (member != null) {
            this.addToTeam(member, team);
            this.addAdmin(member, team);
        } else {
            theTeam.reserved = true;
        }
        LandSaveHandler.saveTeam(team);
    }

    public List<String> getInvites(UUID member) {
        ArrayList<String> ret = new ArrayList<String>();
        Invites invite = this.invites.get(member);
        if (invite == null) {
            return ret;
        }
        return Lists.newArrayList(invite.teams);
    }

    public LandTeam getLandOwner(Coordinate land) {
        LandTeam owner = this._landMap.get(land);
        if (owner == null) {
            return LandManager.getWildTeam();
        }
        return owner;
    }

    public LandTeam getTeam(String name, boolean create) {
        LandTeam team = this._teamMap.get(name);
        if (team == null && create) {
            team = new LandTeam(name);
            this._teamMap.put(name, team);
        }
        return team;
    }

    public List<Coordinate> getTeamLand(String team) {
        ArrayList<Coordinate> ret = new ArrayList<Coordinate>();
        LandTeam t = this._teamMap.get(team);
        if (t != null) {
            ret.addAll(t.land.land);
        }
        return ret;
    }

    public boolean hasInvite(UUID member, String team) {
        Invites invite = this.invites.get(member);
        if (invite != null) {
            return invite.teams.contains(team);
        }
        return false;
    }

    public boolean invite(UUID inviter, UUID invitee) {
        if (!this.isAdmin(inviter)) {
            return false;
        }
        String team = this._playerTeams.get((Object)inviter).teamName;
        if (this.hasInvite(invitee, team)) {
            return false;
        }
        Invites invite = this.invites.get(invitee);
        if (invite == null) {
            invite = new Invites();
            this.invites.put(invitee, invite);
        }
        invite.teams.add(team);
        return true;
    }

    public boolean isAdmin(UUID member) {
        LandTeam team = this._playerTeams.get(member);
        if (team == null) {
            return false;
        }
        return team.isAdmin(member);
    }

    public boolean isOwned(Coordinate land) {
        return this._landMap.containsKey(land);
    }

    public boolean isPublic(Coordinate c, LandTeam team) {
        return team.allPublic || team.anyUse.contains(c);
    }

    public void removeAdmin(UUID member, String teamName) {
        LandTeam t = this._teamMap.get(teamName);
        if (t != null) {
            t.admin.remove(member);
        }
    }

    public void removeFromInvites(UUID member, String team) {
        Invites invite = this.invites.get(member);
        if (invite != null && invite.teams.contains(team)) {
            invite.teams.remove(team);
            LandSaveHandler.saveGlobalData();
        }
    }

    public void removeFromTeam(UUID member) {
        this.addToTeam(member, LandManager.getDefaultTeam().teamName);
    }

    public void removeTeamLand(String team, Coordinate land) {
        LandTeam t = this._teamMap.get(team);
        if (t != null && t.land.removeLand(land)) {
            this._landMap.remove(land);
            Essentials.LOGGER.debug("unclaim: " + team + " Coord: " + land);
            this.unLoadLand(land, t);
            LandSaveHandler.saveTeam(team);
        }
    }

    public void setPublic(Coordinate c, LandTeam owner) {
        owner.anyUse.add(c);
        LandSaveHandler.saveTeam(owner.teamName);
    }

    public void unsetPublic(Coordinate c, LandTeam owner) {
        if (!owner.anyUse.remove(c)) {
            return;
        }
        LandSaveHandler.saveTeam(owner.teamName);
    }

    public boolean loadLand(Coordinate chunk, LandTeam team) {
        if (LandEventsHandler.ChunkLoadHandler.addChunks(chunk)) {
            team.land.getLoaded().add(chunk);
            LandSaveHandler.saveTeam(team.teamName);
            return true;
        }
        return false;
    }

    public boolean unLoadLand(Coordinate chunk, LandTeam team) {
        if (LandEventsHandler.ChunkLoadHandler.removeChunks(chunk)) {
            team.land.getLoaded().remove(chunk);
            LandSaveHandler.saveTeam(team.teamName);
            return true;
        }
        return false;
    }

    public static class TeamLand {
        public HashSet<Coordinate> land = Sets.newHashSet();
        public HashSet<Coordinate> forced = Sets.newHashSet();

        public boolean addLand(Coordinate land) {
            return this.land.add(land);
        }

        public int countLand() {
            return this.land.size();
        }

        public boolean removeLand(Coordinate land) {
            this.forced.remove(land);
            return this.land.remove(land);
        }

        public HashSet<Coordinate> getLoaded() {
            if (this.forced == null) {
                this.forced = Sets.newHashSet();
            }
            return this.forced;
        }
    }

    public static class LandTeam {
        public static final String EDITMESSAGES = "editMessages";
        public static final String CLAIMPERM = "claim";
        public static final String UNCLAIMPERM = "unclaim";
        public static final String SETPREFIX = "prefix";
        public static final String SETHOME = "sethome";
        public static final String INVITE = "invite";
        public static final String KICK = "kick";
        public static final String LOADPERM = "cload";
        public static final String UNLOADPERM = "uncload";
        public static final String PUBLIC = "public";
        public static final String PLACE = "place";
        public static final String BREAK = "break";
        public static final String ALLY = "ally";
        public TeamLand land = new TeamLand();
        public String teamName;
        public Set<UUID> admin = Sets.newHashSet();
        public Set<UUID> member = Sets.newHashSet();
        public Set<UUID> protected_mobs = Sets.newHashSet();
        public Set<UUID> public_mobs = Sets.newHashSet();
        public Map<UUID, PlayerRank> _ranksMembers = Maps.newHashMap();
        public Map<String, PlayerRank> rankMap = Maps.newHashMap();
        public Set<Coordinate> anyUse = Sets.newHashSet();
        public Set<Coordinate> anyBreakSet = Sets.newHashSet();
        public Set<Coordinate> anyPlaceSet = Sets.newHashSet();
        public Coordinate home;
        public String exitMessage = "";
        public String enterMessage = "";
        public String denyMessage = "";
        public String prefix = "";
        public boolean reserved = false;
        public boolean players = false;
        public boolean noPlayerDamage = false;
        public boolean noNPCDamage = false;
        public boolean fakePlayers = false;
        public boolean noMobSpawn = false;
        public boolean friendlyFire = true;
        public boolean noExplosions = false;
        public boolean allPublic = false;
        public boolean anyPlace = false;
        public boolean anyBreak = false;
        public boolean protectFrames = true;
        public Map<String, Relation> relations = Maps.newHashMap();
        public long lastSeen = 0L;
        public int maxLand = -1;
        public int maxLoaded = -1;
        public UUID uuid = UUID.randomUUID();
        private GameProfile _teamprofile;

        public LandTeam() {
        }

        public LandTeam(String name) {
            this.teamName = name;
        }

        public GameProfile getProfile() {
            if (this._teamprofile == null) {
                this._teamprofile = new GameProfile(this.uuid, "team:" + this.teamName);
            }
            return this._teamprofile;
        }

        public boolean isMember(UUID id) {
            return this.member.contains(id);
        }

        public boolean isMember(Entity player) {
            return this.isMember(player.func_110124_au());
        }

        public boolean isAdmin(UUID id) {
            if (this.admin.isEmpty() && !this.teamName.equals(Essentials.config.defaultTeamName)) {
                return true;
            }
            return this.admin.contains(id);
        }

        public boolean isAdmin(Entity player) {
            return this.isAdmin(player.func_110124_au());
        }

        public boolean hasRankPerm(UUID player, String perm) {
            if (this == LandManager.getDefaultTeam()) {
                return false;
            }
            if (this.isAdmin(player)) {
                return true;
            }
            PlayerRank rank = this._ranksMembers.get(player);
            if (rank == null) {
                return false;
            }
            return rank.perms.contains(perm);
        }

        public void setRankPerm(String rankName, String perm) {
            PlayerRank rank = this.rankMap.get(rankName);
            if (rank != null) {
                rank.perms.add(perm);
            }
        }

        public void unsetRankPerm(String rankName, String perm) {
            PlayerRank rank = this.rankMap.get(rankName);
            if (rank != null) {
                rank.perms.remove(perm);
            }
        }

        public boolean canBreakBlock(UUID player, Coordinate location) {
            if (this.anyBreak || this.anyBreakSet.contains(location)) {
                return true;
            }
            LandTeam team = LandManager.getTeam(player);
            Relation relation = this.relations.get(team.teamName);
            if (relation != null) {
                return relation.perms.contains(BREAK);
            }
            return this.member.contains(player);
        }

        public boolean canPlaceBlock(UUID player, Coordinate location) {
            if (this.anyPlace || this.anyPlaceSet.contains(location)) {
                return true;
            }
            LandTeam team = LandManager.getTeam(player);
            Relation relation = this.relations.get(team.teamName);
            if (relation != null) {
                return relation.perms.contains(PLACE);
            }
            return this.member.contains(player);
        }

        public boolean canUseStuff(UUID player, Coordinate location) {
            if (this.allPublic || this.anyUse.contains(location)) {
                return true;
            }
            LandTeam team = LandManager.getTeam(player);
            Relation relation = this.relations.get(team.teamName);
            if (relation != null) {
                return relation.perms.contains(PUBLIC);
            }
            return this.member.contains(player);
        }

        public boolean isAlly(UUID player) {
            LandTeam team = LandManager.getTeam(player);
            if (team != null) {
                return this.isAlly(team);
            }
            return this.member.contains(player);
        }

        public boolean isAlly(LandTeam team) {
            if (team == this) {
                return true;
            }
            Relation relation = this.relations.get(team.teamName);
            if (relation != null) {
                return relation.perms.contains(ALLY);
            }
            return false;
        }

        public void init(MinecraftServer server) {
            HashSet members = Sets.newHashSet(this.member);
            if (!this.teamName.equals(Essentials.config.defaultTeamName)) {
                for (UUID id : members) {
                    LandManager.getInstance()._playerTeams.put(id, this);
                }
            }
            for (UUID id : this.public_mobs) {
                LandManager.getInstance()._public_mobs.put(id, this);
            }
            for (UUID id : this.protected_mobs) {
                LandManager.getInstance()._protected_mobs.put(id, this);
            }
        }

        public boolean equals(Object o) {
            if (o instanceof LandTeam) {
                return ((LandTeam)o).teamName.equals(this.teamName);
            }
            return false;
        }

        public int hashCode() {
            return this.teamName.hashCode();
        }
    }

    public static class Relation {
        public Set<String> perms = Sets.newHashSet();
    }

    public static class PlayerRank {
        public Set<UUID> members = Sets.newHashSet();
        public String prefix;
        public Set<String> perms = Sets.newHashSet();
    }

    public static class Invites {
        public Set<String> teams = Sets.newHashSet();
    }
}

