/*
 * Decompiled with CFR 0.152.
 */
package thut.essentials.land;

import com.google.common.collect.Lists;
import com.google.gson.ExclusionStrategy;
import com.google.gson.FieldAttributes;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Map;
import net.minecraft.server.MinecraftServer;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.fml.LogicalSidedProvider;
import org.apache.commons.io.FileUtils;
import thut.essentials.Essentials;
import thut.essentials.land.LandManager;
import thut.essentials.util.Coordinate;

public class LandSaveHandler {
    public static Gson SAVE_GSON = null;
    public static Gson LOAD_GSON = null;
    static ExclusionStrategy exclusion = new ExclusionStrategy(){

        public boolean shouldSkipField(FieldAttributes f) {
            String name = f.getName();
            return name.startsWith("_");
        }

        public boolean shouldSkipClass(Class<?> clazz) {
            return false;
        }
    };

    public static void removeEmptyTeams() {
        HashSet<String> toRemove = new HashSet<String>();
        Map<String, LandManager.LandTeam> teamMap = LandManager.getInstance()._teamMap;
        for (String s : teamMap.keySet()) {
            LandManager.LandTeam team = teamMap.get(s);
            if (team.member.size() != 0 || team.reserved || team == LandManager.getDefaultTeam()) continue;
            toRemove.add(s);
        }
        for (String s : toRemove) {
            LandManager.getInstance().removeTeam(s);
        }
    }

    public static File getGlobalFolder() {
        MinecraftServer server = (MinecraftServer)LogicalSidedProvider.INSTANCE.get(LogicalSide.SERVER);
        String folder = server.func_71270_I();
        File file = server.func_71254_M().func_186352_b(folder, "land");
        if (!file.exists()) {
            file.mkdirs();
        }
        return file;
    }

    public static File getTeamFolder() {
        File teamFolder = new File(LandSaveHandler.getGlobalFolder(), "teams");
        if (!teamFolder.exists()) {
            teamFolder.mkdirs();
        }
        return teamFolder;
    }

    public static void saveGlobalData() {
        if (SAVE_GSON == null) {
            SAVE_GSON = new GsonBuilder().addSerializationExclusionStrategy(exclusion).setPrettyPrinting().create();
        }
        LandManager.getInstance().version = 1;
        String json = SAVE_GSON.toJson((Object)LandManager.getInstance());
        File teamsFile = new File(LandSaveHandler.getGlobalFolder(), "landData.json");
        try {
            FileUtils.writeStringToFile((File)teamsFile, (String)json, (String)"UTF-8");
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void loadGlobalData() {
        if (LOAD_GSON == null) {
            LOAD_GSON = new GsonBuilder().addDeserializationExclusionStrategy(exclusion).setPrettyPrinting().create();
        }
        File teamsFile = new File(LandSaveHandler.getGlobalFolder(), "landData.json");
        if (Essentials.config.debug) {
            Essentials.LOGGER.info("Starting Loading Land");
        }
        if (teamsFile.exists()) {
            try {
                String json = FileUtils.readFileToString((File)teamsFile, (String)"UTF-8");
                LandManager.instance = (LandManager)LOAD_GSON.fromJson(json, LandManager.class);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            if (LandManager.instance == null) {
                LandManager.instance = new LandManager();
            }
            LandSaveHandler.loadTeams();
        } else {
            if (LandManager.instance == null) {
                LandManager.instance = new LandManager();
            }
            LandSaveHandler.saveGlobalData();
        }
        if (Essentials.config.debug) {
            Essentials.LOGGER.info("Finished Loading Land and Teams");
        }
        LandManager.getDefaultTeam().reserved = true;
    }

    private static void loadTeams() {
        if (LOAD_GSON == null) {
            LOAD_GSON = new GsonBuilder().addDeserializationExclusionStrategy(exclusion).setPrettyPrinting().create();
        }
        File folder = LandSaveHandler.getTeamFolder();
        if (Essentials.config.debug) {
            Essentials.LOGGER.info("Starting Loading Teams");
        }
        MinecraftServer server = (MinecraftServer)LogicalSidedProvider.INSTANCE.get(LogicalSide.SERVER);
        for (File file : folder.listFiles()) {
            try {
                String json = FileUtils.readFileToString((File)file, (String)"UTF-8");
                LandManager.LandTeam team = (LandManager.LandTeam)LOAD_GSON.fromJson(json, LandManager.LandTeam.class);
                LandManager.getInstance()._teamMap.put(team.teamName, team);
                team.init(server);
                ArrayList toAdd = Lists.newArrayList(team.land.land);
                if (Essentials.config.debug) {
                    Essentials.LOGGER.info("Processing " + team.teamName);
                }
                for (Coordinate land : toAdd) {
                    LandManager.getInstance().addTeamLand(team.teamName, land, false);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        if (Essentials.config.debug) {
            Essentials.LOGGER.info("Cleaning Up Teams");
        }
        LandSaveHandler.removeEmptyTeams();
    }

    public static void saveTeam(String team) {
        if (SAVE_GSON == null) {
            SAVE_GSON = new GsonBuilder().addSerializationExclusionStrategy(exclusion).setPrettyPrinting().create();
        }
        File folder = LandSaveHandler.getTeamFolder();
        File teamFile = new File(folder, team + ".json");
        LandManager.LandTeam land = LandManager.getInstance().getTeam(team, false);
        if (land != null) {
            if (land == LandManager.getDefaultTeam()) {
                land.member.clear();
            }
            String json = SAVE_GSON.toJson((Object)land);
            try {
                FileUtils.writeStringToFile((File)teamFile, (String)json, (String)"UTF-8");
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public static void deleteTeam(String team) {
        File folder = LandSaveHandler.getTeamFolder();
        File teamFile = new File(folder, team + ".json");
        if (teamFile.exists()) {
            teamFile.delete();
        }
    }
}

