/*
 * Decompiled with CFR 0.152.
 */
package thut.essentials.util;

import java.util.IllegalFormatException;
import java.util.List;
import java.util.regex.Matcher;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.ServerChatEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.ForgeI18n;
import thut.essentials.Essentials;

public class ChatManager {
    public static void init() {
        MinecraftForge.EVENT_BUS.unregister(ChatManager.class);
        if (Essentials.config.useChatFormat) {
            MinecraftForge.EVENT_BUS.register(ChatManager.class);
        }
    }

    @SubscribeEvent
    public static void onChat(ServerChatEvent event) {
        String format = Essentials.config.chatFormat;
        String raw = event.getMessage();
        StringTextComponent comp = new StringTextComponent("");
        ChatManager.build(comp, format, event.getPlayer().func_145748_c_(), raw);
        event.setComponent((ITextComponent)comp);
    }

    private static void build(StringTextComponent comp, String format, Object ... args) {
        List children = comp.func_150253_a();
        Matcher matcher = TranslationTextComponent.field_150279_c.matcher(format);
        try {
            int i = 0;
            int j = 0;
            while (matcher.find(j)) {
                int k = matcher.start();
                int l = matcher.end();
                if (k > j) {
                    StringTextComponent itextcomponent = new StringTextComponent(String.format(format.substring(j, k), new Object[0]));
                    itextcomponent.func_150256_b().func_150221_a(comp.func_150256_b());
                    children.add(itextcomponent);
                }
                String s2 = matcher.group(2);
                String s = format.substring(k, l);
                if ("%".equals(s2) && "%%".equals(s)) {
                    StringTextComponent itextcomponent2 = new StringTextComponent("%");
                    itextcomponent2.func_150256_b().func_150221_a(comp.func_150256_b());
                    children.add(itextcomponent2);
                } else {
                    int i1;
                    if (!"s".equals(s2)) {
                        Essentials.LOGGER.error("Illegal chat format!");
                        return;
                    }
                    String s1 = matcher.group(1);
                    int n = i1 = s1 != null ? Integer.parseInt(s1) - 1 : i++;
                    if (i1 < args.length) {
                        children.add(ChatManager.getFormatArgumentAsComponent(i1, (TextComponent)comp, args));
                    }
                }
                j = l;
            }
            if (j == 0) {
                j = ChatManager.handle((TextComponent)comp, children, args, format);
            }
            if (j < format.length()) {
                StringTextComponent itextcomponent1 = new StringTextComponent(String.format(format.substring(j), new Object[0]));
                itextcomponent1.func_150256_b().func_150221_a(comp.func_150256_b());
                children.add(itextcomponent1);
            }
        }
        catch (IllegalFormatException illegalformatexception) {
            Essentials.LOGGER.error("Illegal chat format!");
        }
    }

    private static ITextComponent getFormatArgumentAsComponent(int index, TextComponent comp, Object[] args) {
        ITextComponent itextcomponent;
        if (index >= args.length) {
            Essentials.LOGGER.error("Illegal chat format!");
            return new StringTextComponent("");
        }
        Object object = args[index];
        if (object instanceof ITextComponent) {
            itextcomponent = (ITextComponent)object;
        } else {
            itextcomponent = new StringTextComponent(object == null ? "null" : object.toString());
            itextcomponent.func_150256_b().func_150221_a(comp.func_150256_b());
        }
        return itextcomponent;
    }

    public static int handle(TextComponent parent, List<ITextComponent> children, Object[] formatArgs, String format) {
        try {
            StringTextComponent component = new StringTextComponent(ForgeI18n.parseFormat((String)format, (Object[])formatArgs));
            component.func_150256_b().func_150221_a(parent.func_150256_b());
            children.add((ITextComponent)component);
            return format.length();
        }
        catch (IllegalArgumentException ex) {
            return 0;
        }
    }
}

