/*
 * Decompiled with CFR 0.152.
 */
package thut.essentials.util;

import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.event.ClickEvent;
import net.minecraftforge.server.permission.DefaultPermissionLevel;
import net.minecraftforge.server.permission.PermissionAPI;
import thut.essentials.Essentials;
import thut.essentials.commands.CommandManager;
import thut.essentials.util.PlayerDataHandler;

public class HomeManager {
    public static String[] HOMEPERMS = null;

    public static void registerPerms() {
        if (HOMEPERMS != null) {
            return;
        }
        HOMEPERMS = new String[Essentials.config.maxHomes];
        for (int i = 0; i < Essentials.config.maxHomes; ++i) {
            HomeManager.HOMEPERMS[i] = "thutessentials.homes.max." + (i + 1);
            PermissionAPI.registerNode((String)HOMEPERMS[i], (DefaultPermissionLevel)DefaultPermissionLevel.ALL, (String)"Can the player have this many homes (checked when adding a home).");
        }
    }

    public static int[] getHome(ServerPlayerEntity player, String home) {
        CompoundNBT tag;
        CompoundNBT homes;
        if (home == null) {
            home = "Home";
        }
        if ((homes = (tag = PlayerDataHandler.getCustomDataTag((PlayerEntity)player)).func_74775_l("homes")).func_74764_b(home)) {
            return homes.func_74759_k(home);
        }
        return null;
    }

    public static int setHome(ServerPlayerEntity player, String home) {
        CompoundNBT tag;
        CompoundNBT homes;
        int num;
        BlockPos pos = player.func_180425_c();
        if (home == null) {
            home = "Home";
        }
        if ((num = (homes = (tag = PlayerDataHandler.getCustomDataTag((PlayerEntity)player)).func_74775_l("homes")).func_150296_c().size()) >= Essentials.config.maxHomes) {
            return 1;
        }
        String node = HOMEPERMS[num];
        if (!PermissionAPI.hasPermission((PlayerEntity)player, (String)node)) {
            return 2;
        }
        if (homes.func_74764_b(home)) {
            return 3;
        }
        int[] loc = new int[]{pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p(), player.field_71093_bK.func_186068_a()};
        homes.func_74783_a(home, loc);
        tag.func_218657_a("homes", (INBT)homes);
        player.func_145747_a((ITextComponent)new StringTextComponent("set " + home));
        PlayerDataHandler.saveCustomData((PlayerEntity)player);
        return 0;
    }

    public static int removeHome(ServerPlayerEntity player, String home) {
        CompoundNBT tag;
        CompoundNBT homes;
        if (home == null) {
            home = "Home";
        }
        if (!(homes = (tag = PlayerDataHandler.getCustomDataTag((PlayerEntity)player)).func_74775_l("homes")).func_74764_b(home)) {
            return 1;
        }
        homes.func_82580_o(home);
        tag.func_218657_a("homes", (INBT)homes);
        PlayerDataHandler.saveCustomData((PlayerEntity)player);
        return 0;
    }

    public static void sendHomeList(ServerPlayerEntity player) {
        CompoundNBT tag = PlayerDataHandler.getCustomDataTag((PlayerEntity)player);
        CompoundNBT homes = tag.func_74775_l("homes");
        player.func_145747_a(CommandManager.makeFormattedComponent("thutessentials.homes.header"));
        for (String s : homes.func_150296_c()) {
            Style style = new Style();
            if (s.contains(" ")) {
                s = "\"" + s + "\"";
            }
            style.func_150241_a(new ClickEvent(ClickEvent.Action.RUN_COMMAND, "/home " + s));
            ITextComponent message = CommandManager.makeFormattedComponent("thutessentials.homes.entry", null, false, s);
            player.func_145747_a(message.func_150255_a(style));
        }
        player.func_145747_a(CommandManager.makeFormattedComponent("thutessentials.homes.footer"));
    }
}

