/*
 * Decompiled with CFR 0.152.
 */
package thut.essentials.util;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.IContainerListener;
import net.minecraft.item.ItemStack;
import net.minecraft.util.INameable;
import net.minecraft.util.NonNullList;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.player.PlayerContainerEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import thut.essentials.Essentials;
import thut.essentials.util.Coordinate;

public class InventoryLogger {
    private static Set<String> blacklist = Sets.newHashSet();

    public static void enable() {
        blacklist = Sets.newHashSet(Essentials.config.inventory_log_blacklist);
        MinecraftForge.EVENT_BUS.register(InventoryLogger.class);
    }

    public static void disable() {
        blacklist.clear();
        MinecraftForge.EVENT_BUS.unregister(InventoryLogger.class);
    }

    @SubscribeEvent
    public static void PlayerLoggedInEvent(PlayerEvent.PlayerLoggedInEvent event) {
        Coordinate c = Coordinate.getChunkCoordFromWorldCoord(event.getPlayer().func_180425_c(), event.getPlayer().field_71093_bK.func_186068_a());
        Essentials.LOGGER.trace(c + " log-in " + event.getPlayer().func_110124_au() + " " + event.getPlayer().func_200200_C_().func_150254_d());
    }

    @SubscribeEvent
    public static void PlayerLoggedOutEvent(PlayerEvent.PlayerLoggedOutEvent event) {
        Coordinate c = Coordinate.getChunkCoordFromWorldCoord(event.getPlayer().func_180425_c(), event.getPlayer().field_71093_bK.func_186068_a());
        Essentials.LOGGER.trace(c + " log-out " + event.getPlayer().func_110124_au() + " " + event.getPlayer().func_200200_C_().func_150254_d());
    }

    @SubscribeEvent
    public static void openInventory(PlayerContainerEvent.Open event) {
        Coordinate c = Coordinate.getChunkCoordFromWorldCoord(event.getPlayer().func_180425_c(), event.getPlayer().field_71093_bK.func_186068_a());
        Essentials.LOGGER.trace(c + " open " + event.getContainer().getClass() + " " + event.getPlayer().func_110124_au() + " " + event.getPlayer().func_200200_C_().func_150254_d());
        if (!blacklist.contains(event.getContainer().getClass().getName())) {
            event.getContainer().func_75132_a((IContainerListener)new Listener(event.getPlayer(), event.getContainer()));
        }
    }

    private static class Listener
    implements IContainerListener {
        final PlayerEntity player;
        final List<ItemStack> initialList = Lists.newArrayList();

        public Listener(PlayerEntity player, Container opened) {
            this.player = player;
            this.initialList.addAll((Collection<ItemStack>)opened.field_75153_a);
        }

        public void func_71110_a(Container containerToSend, NonNullList<ItemStack> itemsList) {
        }

        public void func_71111_a(Container containerToSend, int slotInd, ItemStack stack) {
            try {
                while (slotInd >= this.initialList.size()) {
                    this.initialList.add(ItemStack.field_190927_a);
                }
                ItemStack oldStack = this.initialList.get(slotInd);
                IInventory inventory = containerToSend.func_75139_a((int)slotInd).field_75224_c;
                String invName = inventory.toString();
                if (inventory instanceof INameable && ((INameable)inventory).func_200200_C_() != null) {
                    invName = ((INameable)inventory).func_200200_C_().func_150254_d();
                }
                if (oldStack.func_190926_b() && !stack.func_190926_b()) {
                    Essentials.LOGGER.trace("slot_place " + containerToSend.getClass() + " " + stack + " " + stack.func_200301_q().func_150254_d() + ", " + invName + " " + this.player.func_110124_au() + " " + this.player.func_200200_C_().func_150254_d());
                } else if (stack.func_190926_b() && !oldStack.func_190926_b()) {
                    Essentials.LOGGER.trace("slot_take " + containerToSend.getClass() + " " + oldStack + " " + oldStack.func_200301_q().func_150254_d() + ", " + invName + " " + this.player.func_110124_au() + " " + this.player.func_200200_C_().func_150254_d());
                } else {
                    Essentials.LOGGER.trace("slot_swap " + containerToSend.getClass() + " " + stack + " " + stack.func_200301_q() + " <-> " + oldStack + " " + oldStack.func_200301_q().func_150254_d() + ", " + invName + " " + this.player.func_110124_au() + " " + this.player.func_200200_C_().func_150254_d());
                }
                this.initialList.set(slotInd, stack);
            }
            catch (Exception e) {
                Essentials.LOGGER.error("Blacklisting Errored Inventory:" + containerToSend.getClass(), (Throwable)e);
                blacklist.add(containerToSend.getClass().getName());
                ArrayList temp = Lists.newArrayList((Iterable)blacklist);
                Collections.sort(temp);
                Essentials.config.inventory_log_blacklist = temp;
            }
        }

        public void func_71112_a(Container containerIn, int varToUpdate, int newValue) {
        }
    }
}

