/*
 * Decompiled with CFR 0.152.
 */
package thut.essentials.util;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.io.File;
import java.io.FileInputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Random;
import javax.xml.namespace.QName;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.JsonToNBT;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.Tag;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.event.ClickEvent;
import net.minecraftforge.fml.loading.FMLPaths;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.server.permission.DefaultPermissionLevel;
import net.minecraftforge.server.permission.IPermissionHandler;
import net.minecraftforge.server.permission.PermissionAPI;
import net.minecraftforge.server.permission.context.IContext;
import net.minecraftforge.server.permission.context.PlayerContext;
import thut.essentials.Essentials;
import thut.essentials.commands.CommandManager;
import thut.essentials.xml.bind.Factory;
import thut.essentials.xml.bind.annotation.XmlAnyAttribute;
import thut.essentials.xml.bind.annotation.XmlElement;
import thut.essentials.xml.bind.annotation.XmlRootElement;

public class KitManager {
    public static List<ItemStack> kit = Lists.newArrayList();
    public static Map<String, KitSet> kits = Maps.newHashMap();

    public static void init() {
        File kitsfile = FMLPaths.CONFIGDIR.get().resolve("thutessentials").resolve("kits.xml").toFile();
        boolean newKits = kitsfile.exists();
        if (!newKits) {
            kitsfile.getParentFile().mkdirs();
        }
        QName ident = new QName("name");
        QName cooldown = new QName("cooldown");
        kits.clear();
        kit.clear();
        if (newKits) {
            try {
                FileInputStream stream = new FileInputStream(kitsfile);
                Kits database = Factory.make(stream, Kits.class);
                try {
                    stream.close();
                }
                catch (Exception e1) {
                    e1.printStackTrace();
                }
                for (XMLStarterItems items : database.kits) {
                    if (items.values.containsKey(ident)) {
                        KitSet set = new KitSet();
                        String name = items.values.get(ident);
                        if (kits.containsKey(name)) {
                            Essentials.LOGGER.warn("Duplicate kit: " + name);
                        }
                        ArrayList list = Lists.newArrayList();
                        for (Drop drop : items.drops) {
                            ItemStack stack = KitManager.getStackFromDrop(drop);
                            if (stack.func_190926_b()) continue;
                            list.add(stack);
                        }
                        try {
                            set.cooldown = Integer.parseInt(items.values.get(cooldown));
                        }
                        catch (Exception e) {
                            set.cooldown = Essentials.config.kitReuseDelay;
                        }
                        IPermissionHandler manager = PermissionAPI.getPermissionHandler();
                        String node = "thutessentials.kit." + name;
                        if (!manager.getRegisteredNodes().contains(node)) {
                            manager.registerNode(node, DefaultPermissionLevel.ALL, "Can get the Kit " + name);
                        }
                        set.stacks = list;
                        kits.put(name, set);
                        continue;
                    }
                    IPermissionHandler manager = PermissionAPI.getPermissionHandler();
                    String node = "thutessentials.kit.default";
                    if (!manager.getRegisteredNodes().contains("thutessentials.kit.default")) {
                        manager.registerNode("thutessentials.kit.default", DefaultPermissionLevel.ALL, "Can get the default Kit");
                    }
                    for (Drop drop : items.drops) {
                        ItemStack stack = KitManager.getStackFromDrop(drop);
                        if (stack.func_190926_b()) continue;
                        kit.add(stack);
                    }
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        if (!newKits) {
            Kits kit = new Kits();
            XMLStarterItems items = new XMLStarterItems();
            Drop init = new Drop();
            init.values.put(new QName("id"), "minecraft:stick");
            init.values.put(new QName("n"), "5");
            items.drops.add(init);
            kit.kits.add(items);
        }
    }

    public static ItemStack getStackFromDrop(Drop d) {
        Map<QName, String> values = d.values;
        if (d.tag != null) {
            QName name = new QName("tag");
            values.put(name, d.tag);
        }
        return KitManager.getStack(d.values);
    }

    public static boolean isSameStack(ItemStack a, ItemStack b) {
        return KitManager.isSameStack(a, b, false);
    }

    public static boolean isSameStack(ItemStack a, ItemStack b, boolean strict) {
        return ItemStack.func_185132_d((ItemStack)a, (ItemStack)b);
    }

    public static ItemStack getStack(Map<QName, String> values) {
        Tag tags;
        String id = "";
        int size = 1;
        String tag = "";
        for (QName key : values.keySet()) {
            if (key.toString().equals("id")) {
                id = values.get(key);
                continue;
            }
            if (key.toString().equals("n")) {
                size = Integer.parseInt(values.get(key));
                continue;
            }
            if (!key.toString().equals("tag")) continue;
            tag = values.get(key).trim();
        }
        if (id.isEmpty()) {
            return ItemStack.field_190927_a;
        }
        ResourceLocation loc = new ResourceLocation(id);
        ItemStack stack = ItemStack.field_190927_a;
        Item item = (Item)ForgeRegistries.ITEMS.getValue(loc);
        if (item == null && (tags = ItemTags.func_199903_a().func_199910_a(loc)) != null && (item = (Item)tags.func_205596_a(new Random(2L))) != null) {
            return new ItemStack((IItemProvider)item);
        }
        if (item == null) {
            return ItemStack.field_190927_a;
        }
        if (stack.func_190926_b()) {
            stack = new ItemStack((IItemProvider)item, 1);
        }
        stack.func_190920_e(size);
        if (!tag.isEmpty()) {
            try {
                stack.func_77982_d(JsonToNBT.func_180713_a((String)tag));
            }
            catch (CommandSyntaxException e) {
                Essentials.LOGGER.error("Error parsing items for " + values, (Throwable)e);
            }
        }
        return stack;
    }

    public static void sendKitsList(ServerPlayerEntity player) {
        IPermissionHandler manager = PermissionAPI.getPermissionHandler();
        PlayerContext context = new PlayerContext((PlayerEntity)player);
        player.func_145747_a(CommandManager.makeFormattedComponent("thutessentials.kits.header"));
        Style style = new Style();
        if (!kit.isEmpty() && manager.hasPermission(player.func_146103_bH(), "thutessentials.kit.default", (IContext)context)) {
            style = new Style();
            style.func_150241_a(new ClickEvent(ClickEvent.Action.RUN_COMMAND, "/kit Default"));
            ITextComponent message = CommandManager.makeFormattedComponent("thutessentials.kits.entry", null, false, "Default");
            player.func_145747_a(message.func_150255_a(style));
        }
        for (String s : kits.keySet()) {
            if (!manager.hasPermission(player.func_146103_bH(), "thutessentials.kit." + s, (IContext)context)) continue;
            style = new Style();
            if (s.contains(" ")) {
                s = "\"" + s + "\"";
            }
            style.func_150241_a(new ClickEvent(ClickEvent.Action.RUN_COMMAND, "/kit " + s));
            ITextComponent message = CommandManager.makeFormattedComponent("thutessentials.kits.entry", null, false, s);
            player.func_145747_a(message.func_150255_a(style));
        }
        player.func_145747_a(CommandManager.makeFormattedComponent("thutessentials.kits.footer"));
    }

    @XmlRootElement(name="Item")
    public static class Drop {
        @XmlAnyAttribute
        public Map<QName, String> values = Maps.newHashMap();
        @XmlElement(name="tag")
        public String tag;
    }

    @XmlRootElement(name="Items")
    public static class XMLStarterItems {
        @XmlAnyAttribute
        public Map<QName, String> values = Maps.newHashMap();
        @XmlElement(name="Item")
        public List<Drop> drops = Lists.newArrayList();
    }

    public static class KitSet {
        public Integer cooldown = null;
        public List<ItemStack> stacks = null;
    }

    @XmlRootElement(name="Kits")
    public static class Kits {
        @XmlElement(name="Kit")
        public List<XMLStarterItems> kits = Lists.newArrayList();
    }
}

