/*
 * Decompiled with CFR 0.152.
 */
package thut.essentials.util;

import com.google.common.collect.Sets;
import java.util.Set;
import net.minecraft.entity.Entity;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.event.entity.EntityMobGriefingEvent;
import net.minecraftforge.event.entity.living.LivingSpawnEvent;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import thut.essentials.Essentials;

public class MobManager {
    private static Set<ResourceLocation> griefWhitelist = Sets.newHashSet();
    private static Set<ResourceLocation> griefBlacklist = Sets.newHashSet();
    private static Set<ResourceLocation> spawnWhitelist = Sets.newHashSet();
    private static Set<ResourceLocation> spawnBlacklist = Sets.newHashSet();

    public static void init() {
        griefWhitelist.clear();
        griefBlacklist.clear();
        spawnWhitelist.clear();
        spawnBlacklist.clear();
        for (String s : Essentials.config.mobGriefAllowWhitelist) {
            griefWhitelist.add(new ResourceLocation(s));
        }
        for (String s : Essentials.config.mobGriefAllowBlacklist) {
            griefBlacklist.add(new ResourceLocation(s));
        }
        for (String s : Essentials.config.mobSpawnWhitelist) {
            spawnWhitelist.add(new ResourceLocation(s));
        }
        for (String s : Essentials.config.mobSpawnBlacklist) {
            spawnBlacklist.add(new ResourceLocation(s));
        }
    }

    public static boolean isWhitelistedForGriefing(Entity mob) {
        if (mob == null) {
            return false;
        }
        return griefWhitelist.contains(mob.func_200600_R().getRegistryName());
    }

    @SubscribeEvent
    public static void mobGriefing(EntityMobGriefingEvent evt) {
        if (Essentials.config.mobGriefAllowUsesWhitelist) {
            boolean valid = evt.getEntity() != null && griefWhitelist.contains(evt.getEntity().func_200600_R().getRegistryName());
            evt.setResult(valid ? Event.Result.ALLOW : Event.Result.DEFAULT);
        } else {
            boolean valid = evt.getEntity() != null && griefBlacklist.contains(evt.getEntity().func_200600_R().getRegistryName());
            evt.setResult(valid ? Event.Result.DENY : Event.Result.DEFAULT);
        }
    }

    @SubscribeEvent
    public static void mobSpawning(LivingSpawnEvent.CheckSpawn evt) {
        if (evt.getResult() != Event.Result.DEFAULT) {
            return;
        }
        if (Essentials.config.mobSpawnUsesWhitelist) {
            boolean valid = spawnWhitelist.contains(evt.getEntity().func_200600_R().getRegistryName());
            evt.setResult(valid ? Event.Result.DEFAULT : Event.Result.DENY);
            return;
        }
        boolean valid = spawnBlacklist.contains(evt.getEntity().func_200600_R().getRegistryName());
        evt.setResult(valid ? Event.Result.DENY : Event.Result.DEFAULT);
    }

    @SubscribeEvent
    public static void mobSpawning(LivingSpawnEvent.SpecialSpawn evt) {
        if (evt.getResult() != Event.Result.DEFAULT) {
            return;
        }
        if (Essentials.config.mobSpawnUsesWhitelist) {
            boolean valid = spawnWhitelist.contains(evt.getEntity().func_200600_R().getRegistryName());
            evt.setResult(valid ? Event.Result.DEFAULT : Event.Result.DENY);
            return;
        }
        boolean valid = spawnBlacklist.contains(evt.getEntity().func_200600_R().getRegistryName());
        evt.setResult(valid ? Event.Result.DENY : Event.Result.DEFAULT);
    }

    @SubscribeEvent
    public static void checkSpawns(WorldEvent.PotentialSpawns evt) {
        evt.getList().removeIf(e -> spawnBlacklist.contains(e.field_200702_b.getRegistryName()));
        if (Essentials.config.mobSpawnUsesWhitelist) {
            evt.getList().removeIf(e -> !spawnWhitelist.contains(e.field_200702_b.getRegistryName()));
        }
    }
}

