/*
 * Decompiled with CFR 0.152.
 */
package thut.essentials.util;

import com.mojang.authlib.GameProfile;
import io.netty.buffer.Unpooled;
import java.lang.reflect.Field;
import java.util.UUID;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.IPacket;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.PacketBuffer;
import net.minecraft.network.play.ServerPlayNetHandler;
import net.minecraft.network.play.server.SCustomPayloadPlayPacket;
import net.minecraft.network.play.server.SHeldItemChangePacket;
import net.minecraft.network.play.server.SJoinGamePacket;
import net.minecraft.network.play.server.SPlayEntityEffectPacket;
import net.minecraft.network.play.server.SPlayerAbilitiesPacket;
import net.minecraft.network.play.server.SPlayerListItemPacket;
import net.minecraft.network.play.server.SServerDifficultyPacket;
import net.minecraft.network.play.server.STagsListPacket;
import net.minecraft.network.play.server.SUpdateRecipesPacket;
import net.minecraft.potion.EffectInstance;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.dedicated.DedicatedPlayerList;
import net.minecraft.server.dedicated.DedicatedServer;
import net.minecraft.server.management.PlayerList;
import net.minecraft.server.management.PlayerProfileCache;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.GameRules;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraft.world.dimension.DimensionType;
import net.minecraft.world.server.ServerWorld;
import net.minecraft.world.storage.WorldInfo;
import net.minecraftforge.fml.hooks.BasicEventHooks;
import net.minecraftforge.fml.network.NetworkHooks;
import thut.essentials.Essentials;
import thut.essentials.util.PlayerDataHandler;
import thut.essentials.util.RuleManager;

public class NameManager
extends DedicatedPlayerList {
    private static Field NAME = null;

    private static void setName(String name, GameProfile profile) {
        try {
            NAME.set(profile, name);
        }
        catch (IllegalAccessException | IllegalArgumentException e) {
            Essentials.LOGGER.warn("Error setting name", (Throwable)e);
        }
    }

    public static void init(MinecraftServer server) {
        if (!(server instanceof DedicatedServer)) {
            return;
        }
        server.func_184105_a((PlayerList)new NameManager((DedicatedServer)server));
        server.func_184103_al().func_212504_a(server.func_71218_a(DimensionType.field_223227_a_));
    }

    public static void onLogin(ServerPlayerEntity player, MinecraftServer server) {
        String name = PlayerDataHandler.getCustomDataTag((PlayerEntity)player).func_74779_i("nick");
        if (!name.isEmpty()) {
            NameManager.setName(name, player.func_146103_bH(), server);
        }
    }

    public static void setName(String name, GameProfile profile, MinecraftServer server) {
        if (NAME == null) {
            Essentials.LOGGER.warn("Setting custom name currently disabled.");
            return;
        }
        name = RuleManager.format(name);
        ServerPlayerEntity player = server.func_184103_al().func_177451_a(profile.getId());
        if ("_".equals(name) && player != null && PlayerDataHandler.getCustomDataTag((PlayerEntity)player).func_74764_b("nick_orig")) {
            name = PlayerDataHandler.getCustomDataTag((PlayerEntity)player).func_74779_i("nick_orig");
        }
        GameProfile newProfile = new GameProfile(profile.getId(), name);
        server.func_152358_ax().func_152649_a(newProfile);
        if (player != null) {
            NameManager.setName(name, player.func_146103_bH());
            PlayerDataHandler.getCustomDataTag((PlayerEntity)player).func_74778_a("nick", name);
            if (!PlayerDataHandler.getCustomDataTag((PlayerEntity)player).func_74764_b("nick_orig")) {
                PlayerDataHandler.getCustomDataTag((PlayerEntity)player).func_74778_a("nick_orig", name);
            }
            PlayerDataHandler.saveCustomData((PlayerEntity)player);
            server.func_184103_al().func_148540_a((IPacket)new SPlayerListItemPacket(SPlayerListItemPacket.Action.UPDATE_DISPLAY_NAME, new ServerPlayerEntity[]{player}));
        } else {
            NameManager.setName(name, profile);
        }
    }

    public NameManager(DedicatedServer p_i1503_1_) {
        super(p_i1503_1_);
    }

    public void func_72355_a(NetworkManager netManager, ServerPlayerEntity playerIn) {
        GameProfile gameprofile = playerIn.func_146103_bH();
        PlayerProfileCache playerprofilecache = this.func_72365_p().func_152358_ax();
        NameManager.onLogin(playerIn, (MinecraftServer)this.func_72365_p());
        GameProfile gameprofile1 = playerprofilecache.func_152652_a(gameprofile.getId());
        String s = gameprofile1 == null ? gameprofile.getName() : gameprofile1.getName();
        playerprofilecache.func_152649_a(gameprofile);
        CompoundNBT compoundnbt = this.func_72380_a(playerIn);
        ServerWorld serverworld = this.func_72365_p().func_71218_a(playerIn.field_71093_bK);
        if (serverworld == null) {
            playerIn.field_71093_bK = DimensionType.field_223227_a_;
            serverworld = this.func_72365_p().func_71218_a(playerIn.field_71093_bK);
            playerIn.func_70107_b((double)serverworld.func_72912_H().func_76079_c(), (double)serverworld.func_72912_H().func_76075_d(), (double)serverworld.func_72912_H().func_76074_e());
        }
        playerIn.func_70029_a((World)serverworld);
        playerIn.field_71134_c.func_73080_a((ServerWorld)playerIn.field_70170_p);
        String s1 = "local";
        if (netManager.func_74430_c() != null) {
            s1 = netManager.func_74430_c().toString();
        }
        Essentials.LOGGER.info("{}[{}] logged in with entity id {} at ({}, {}, {})", (Object)playerIn.func_200200_C_().getString(), (Object)s1, (Object)playerIn.func_145782_y(), (Object)playerIn.func_226277_ct_(), (Object)playerIn.func_226278_cu_(), (Object)playerIn.func_226281_cx_());
        WorldInfo worldinfo = serverworld.func_72912_H();
        this.func_72381_a(playerIn, null, (IWorld)serverworld);
        ServerPlayNetHandler serverplaynethandler = new ServerPlayNetHandler((MinecraftServer)this.func_72365_p(), netManager, playerIn);
        NetworkHooks.sendMCRegistryPackets((NetworkManager)netManager, (String)"PLAY_TO_CLIENT");
        NetworkHooks.sendDimensionDataPacket((NetworkManager)netManager, (ServerPlayerEntity)playerIn);
        GameRules gamerules = serverworld.func_82736_K();
        boolean flag = gamerules.func_223586_b(GameRules.field_226683_z_);
        boolean flag1 = gamerules.func_223586_b(GameRules.field_223612_o);
        serverplaynethandler.func_147359_a((IPacket)new SJoinGamePacket(playerIn.func_145782_y(), playerIn.field_71134_c.func_73081_b(), WorldInfo.func_227498_c_((long)worldinfo.func_76063_b()), worldinfo.func_76093_s(), serverworld.field_73011_w.func_186058_p(), this.func_72352_l(), worldinfo.func_76067_t(), this.func_72395_o(), flag1, !flag));
        serverplaynethandler.func_147359_a((IPacket)new SCustomPayloadPlayPacket(SCustomPayloadPlayPacket.field_209911_b, new PacketBuffer(Unpooled.buffer()).func_180714_a(this.func_72365_p().getServerModName())));
        serverplaynethandler.func_147359_a((IPacket)new SServerDifficultyPacket(worldinfo.func_176130_y(), worldinfo.func_176123_z()));
        serverplaynethandler.func_147359_a((IPacket)new SPlayerAbilitiesPacket(playerIn.field_71075_bZ));
        serverplaynethandler.func_147359_a((IPacket)new SHeldItemChangePacket(playerIn.field_71071_by.field_70461_c));
        serverplaynethandler.func_147359_a((IPacket)new SUpdateRecipesPacket(this.func_72365_p().func_199529_aN().func_199510_b()));
        serverplaynethandler.func_147359_a((IPacket)new STagsListPacket(this.func_72365_p().func_199731_aO()));
        this.func_187243_f(playerIn);
        playerIn.func_147099_x().func_150877_d();
        playerIn.func_192037_E().func_192826_c(playerIn);
        this.func_96456_a(serverworld.func_96441_U(), playerIn);
        this.func_72365_p().func_147132_au();
        ITextComponent itextcomponent = playerIn.func_146103_bH().getName().equalsIgnoreCase(s) ? Essentials.config.getMessage("multiplayer.player.joined", playerIn.func_145748_c_()) : Essentials.config.getMessage("multiplayer.player.joined.renamed", playerIn.func_145748_c_(), s);
        this.func_148539_a(itextcomponent.func_211708_a(TextFormatting.YELLOW));
        serverplaynethandler.func_147364_a(playerIn.func_226277_ct_(), playerIn.func_226278_cu_(), playerIn.func_226281_cx_(), playerIn.field_70177_z, playerIn.field_70125_A);
        this.addPlayer(playerIn);
        this.field_177454_f.put(playerIn.func_110124_au(), playerIn);
        this.func_148540_a((IPacket)new SPlayerListItemPacket(SPlayerListItemPacket.Action.ADD_PLAYER, new ServerPlayerEntity[]{playerIn}));
        for (ServerPlayerEntity element : this.func_181057_v()) {
            playerIn.field_71135_a.func_147359_a((IPacket)new SPlayerListItemPacket(SPlayerListItemPacket.Action.ADD_PLAYER, new ServerPlayerEntity[]{element}));
        }
        serverworld.func_217435_c(playerIn);
        this.func_72365_p().func_201300_aS().func_201383_a(playerIn);
        this.func_72354_b(playerIn, serverworld);
        if (!this.func_72365_p().func_147133_T().isEmpty()) {
            playerIn.func_175397_a(this.func_72365_p().func_147133_T(), this.func_72365_p().func_175581_ab());
        }
        for (EffectInstance effectinstance : playerIn.func_70651_bq()) {
            serverplaynethandler.func_147359_a((IPacket)new SPlayEntityEffectPacket(playerIn.func_145782_y(), effectinstance));
        }
        if (compoundnbt != null && compoundnbt.func_150297_b("RootVehicle", 10)) {
            CompoundNBT compoundnbt1 = compoundnbt.func_74775_l("RootVehicle");
            ServerWorld worldf = serverworld;
            Entity entity1 = EntityType.func_220335_a((CompoundNBT)compoundnbt1.func_74775_l("Entity"), (World)serverworld, p_217885_1_ -> !worldf.func_217470_d(p_217885_1_) ? null : p_217885_1_);
            if (entity1 != null) {
                UUID uuid = compoundnbt1.func_186857_a("Attach");
                if (entity1.func_110124_au().equals(uuid)) {
                    playerIn.func_184205_a(entity1, true);
                } else {
                    for (Entity entity : entity1.func_184182_bu()) {
                        if (!entity.func_110124_au().equals(uuid)) continue;
                        playerIn.func_184205_a(entity, true);
                        break;
                    }
                }
                if (!playerIn.func_184218_aH()) {
                    Essentials.LOGGER.warn("Couldn't reattach entity to player");
                    serverworld.func_217467_h(entity1);
                    for (Entity entity2 : entity1.func_184182_bu()) {
                        serverworld.func_217467_h(entity2);
                    }
                }
            }
        }
        playerIn.func_71116_b();
        BasicEventHooks.firePlayerLoggedIn((PlayerEntity)playerIn);
    }

    static {
        try {
            NAME = GameProfile.class.getDeclaredFields()[1];
            NAME.setAccessible(true);
            Field modifiersField = Field.class.getDeclaredField("modifiers");
            modifiersField.setAccessible(true);
            modifiersField.setInt(NAME, NAME.getModifiers() & 0xFFFFFFEF);
        }
        catch (IllegalAccessException | IllegalArgumentException | NoSuchFieldException | SecurityException e) {
            NAME = null;
        }
    }
}

