/*
 * Decompiled with CFR 0.152.
 */
package thut.essentials.util;

import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import io.netty.buffer.ByteBuf;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.CompressedStreamTools;
import net.minecraft.nbt.INBT;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.dimension.DimensionType;
import net.minecraft.world.server.ServerWorld;
import net.minecraft.world.storage.SaveHandler;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.fml.LogicalSidedProvider;

public class PlayerDataHandler {
    public static Set<Class<? extends PlayerData>> dataMap = Sets.newHashSet();
    private static PlayerDataHandler INSTANCESERVER;
    private final Map<String, PlayerDataManager> data = Maps.newHashMap();

    public static PlayerDataHandler getInstance() {
        return INSTANCESERVER != null ? INSTANCESERVER : (INSTANCESERVER = new PlayerDataHandler());
    }

    public static void clear() {
        if (INSTANCESERVER != null) {
            MinecraftForge.EVENT_BUS.unregister((Object)INSTANCESERVER);
        }
        INSTANCESERVER = null;
    }

    public static void saveAll() {
    }

    public static CompoundNBT getCustomDataTag(PlayerEntity player) {
        PlayerDataManager manager = PlayerDataHandler.getInstance().getPlayerData(player);
        PlayerCustomData data = manager.getData(PlayerCustomData.class);
        return data.tag;
    }

    public static CompoundNBT getCustomDataTag(String player) {
        PlayerDataManager manager = PlayerDataHandler.getInstance().getPlayerData(player);
        PlayerCustomData data = manager.getData(PlayerCustomData.class);
        return data.tag;
    }

    public static void saveCustomData(PlayerEntity player) {
        PlayerDataHandler.saveCustomData(player.func_189512_bd());
    }

    public static void saveCustomData(String cachedUniqueIdString) {
        PlayerDataHandler.getInstance().save(cachedUniqueIdString, "thutessentials");
    }

    public static File getFileForUUID(String uuid, String fileName) {
        MinecraftServer server = (MinecraftServer)LogicalSidedProvider.INSTANCE.get(LogicalSide.SERVER);
        ServerWorld world = server.func_71218_a(DimensionType.field_223227_a_);
        SaveHandler saveHandler = world.func_217485_w();
        String seperator = System.getProperty("file.separator");
        File worlddir = saveHandler.func_75765_b();
        File file = new File(worlddir, "thutessentials" + seperator + uuid + seperator + fileName + ".dat");
        File dir = new File(file.getParentFile().getAbsolutePath());
        if (!file.exists()) {
            dir.mkdirs();
        }
        return file;
    }

    public PlayerDataHandler() {
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    public PlayerDataManager getPlayerData(PlayerEntity player) {
        return this.getPlayerData(player.func_189512_bd());
    }

    public PlayerDataManager getPlayerData(String uuid) {
        PlayerDataManager manager = this.data.get(uuid);
        if (manager == null) {
            manager = this.load(uuid);
        }
        return manager;
    }

    public PlayerDataManager getPlayerData(UUID uniqueID) {
        return this.getPlayerData(uniqueID.toString());
    }

    @SubscribeEvent
    public void cleanupOfflineData(WorldEvent.Save event) {
        DimensionType type = event.getWorld().func_201675_m().func_186058_p();
        if (type == DimensionType.field_223227_a_) {
            HashSet toUnload = Sets.newHashSet();
            MinecraftServer server = (MinecraftServer)LogicalSidedProvider.INSTANCE.get(LogicalSide.SERVER);
            for (String uuid : this.data.keySet()) {
                ServerPlayerEntity player = server.func_184103_al().func_177451_a(UUID.fromString(uuid));
                if (player != null) continue;
                toUnload.add(uuid);
            }
            for (String s : toUnload) {
                this.save(s);
                this.data.remove(s);
            }
        }
    }

    public PlayerDataManager load(String uuid) {
        PlayerDataManager manager = new PlayerDataManager(uuid);
        for (PlayerData data : manager.data.values()) {
            String fileName = data.dataFileName();
            File file = null;
            try {
                file = PlayerDataHandler.getFileForUUID(uuid, fileName);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (file == null || !file.exists()) continue;
            try {
                FileInputStream fileinputstream = new FileInputStream(file);
                CompoundNBT nbttagcompound = CompressedStreamTools.func_74796_a((InputStream)fileinputstream);
                fileinputstream.close();
                data.readFromNBT(nbttagcompound.func_74775_l("Data"));
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        this.data.put(uuid, manager);
        return manager;
    }

    public void save(String uuid, String dataType) {
        PlayerDataManager manager = this.data.get(uuid);
        if (manager != null) {
            for (PlayerData data : manager.data.values()) {
                String fileName;
                File file;
                if (!data.getIdentifier().equals(dataType) || (file = PlayerDataHandler.getFileForUUID(uuid, fileName = data.dataFileName())) == null) continue;
                CompoundNBT nbttagcompound = new CompoundNBT();
                data.writeToNBT(nbttagcompound);
                CompoundNBT nbttagcompound1 = new CompoundNBT();
                nbttagcompound1.func_218657_a("Data", (INBT)nbttagcompound);
                try {
                    FileOutputStream fileoutputstream = new FileOutputStream(file);
                    CompressedStreamTools.func_74799_a((CompoundNBT)nbttagcompound1, (OutputStream)fileoutputstream);
                    fileoutputstream.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    public void save(String uuid) {
        PlayerDataManager manager = this.data.get(uuid);
        if (manager != null) {
            for (PlayerData data : manager.data.values()) {
                String fileName = data.dataFileName();
                File file = PlayerDataHandler.getFileForUUID(uuid, fileName);
                if (file == null) continue;
                CompoundNBT nbttagcompound = new CompoundNBT();
                data.writeToNBT(nbttagcompound);
                CompoundNBT nbttagcompound1 = new CompoundNBT();
                nbttagcompound1.func_218657_a("Data", (INBT)nbttagcompound);
                try {
                    FileOutputStream fileoutputstream = new FileOutputStream(file);
                    CompressedStreamTools.func_74799_a((CompoundNBT)nbttagcompound1, (OutputStream)fileoutputstream);
                    fileoutputstream.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    static {
        dataMap.add(PlayerCustomData.class);
    }

    public static class PlayerDataManager {
        Map<Class<? extends PlayerData>, PlayerData> data = Maps.newHashMap();
        Map<String, PlayerData> idMap = Maps.newHashMap();
        final String uuid;

        public PlayerDataManager(String uuid) {
            this.uuid = uuid;
            for (Class<? extends PlayerData> type : dataMap) {
                try {
                    PlayerData toAdd = type.newInstance();
                    this.data.put(type, toAdd);
                    this.idMap.put(toAdd.getIdentifier(), toAdd);
                }
                catch (InstantiationException e) {
                    e.printStackTrace();
                }
                catch (IllegalAccessException e) {
                    e.printStackTrace();
                }
            }
        }

        public <T extends PlayerData> T getData(Class<T> type) {
            return (T)this.data.get(type);
        }

        public PlayerData getData(String dataType) {
            return this.idMap.get(dataType);
        }
    }

    public static class PlayerCustomData
    extends PlayerData {
        public CompoundNBT tag = new CompoundNBT();

        @Override
        public String getIdentifier() {
            return "thutessentials";
        }

        @Override
        public String dataFileName() {
            return "thutEssentials";
        }

        @Override
        public boolean shouldSync() {
            return false;
        }

        @Override
        public void writeToNBT(CompoundNBT tag) {
            tag.func_218657_a("data", (INBT)this.tag);
        }

        @Override
        public void readFromNBT(CompoundNBT tag) {
            this.tag = tag.func_74775_l("data");
        }
    }

    public static abstract class PlayerData
    implements IPlayerData {
        @Override
        public void readSync(ByteBuf data) {
        }

        @Override
        public void writeSync(ByteBuf data) {
        }
    }

    private static interface IPlayerData {
        public String getIdentifier();

        public String dataFileName();

        public boolean shouldSync();

        public void writeToNBT(CompoundNBT var1);

        public void readFromNBT(CompoundNBT var1);

        public void readSync(ByteBuf var1);

        public void writeSync(ByteBuf var1);
    }
}

