/*
 * Decompiled with CFR 0.152.
 */
package thut.essentials.util;

import com.google.common.collect.Maps;
import java.util.Map;
import java.util.UUID;
import java.util.function.Predicate;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import thut.essentials.Essentials;
import thut.essentials.events.MoveEvent;
import thut.essentials.util.Transporter;

public class PlayerMover {
    public static ITextComponent INTERUPTED;
    private static Transporter.Vector4 offset;
    static Map<UUID, Mover> toMove;

    public static void setMove(PlayerEntity player, int moveTime, int dimension, BlockPos moveTo, ITextComponent message, ITextComponent failMess) {
        PlayerMover.setMove(player, moveTime, dimension, moveTo, message, failMess, true);
    }

    public static void setMove(PlayerEntity player, int moveTime, int dimension, BlockPos moveTo, ITextComponent message, ITextComponent failMess, boolean event) {
        PlayerMover.setMove(player, moveTime, dimension, moveTo, message, failMess, null, event);
    }

    public static void setMove(PlayerEntity player, int moveTime, int dimension, BlockPos moveTo, ITextComponent message, ITextComponent failMess, Predicate<Entity> callback, boolean event) {
        if (player.func_184187_bx() != null || player.func_184207_aI()) {
            player.func_145747_a(Essentials.config.getMessage("thutessentials.tp.dismount", new Object[0]));
            return;
        }
        player.func_184102_h().func_213167_f(() -> {
            if (!toMove.containsKey(player.func_110124_au())) {
                long time = moveTime;
                if (time > 0L) {
                    player.func_145747_a(Essentials.config.getMessage("thutessentials.tp.tele_init", new Object[0]));
                    time += player.func_130014_f_().func_82737_E();
                }
                toMove.put(player.func_110124_au(), new Mover(player, time, dimension, moveTo, message, failMess, callback, event));
            }
        });
    }

    @SubscribeEvent
    public void playerTick(LivingEvent.LivingUpdateEvent tick) {
        if (!(tick.getEntity().field_70170_p instanceof ServerWorld)) {
            return;
        }
        if (toMove.containsKey(tick.getEntity().func_110124_au())) {
            Mover mover = toMove.get(tick.getEntity().func_110124_au());
            Transporter.Vector4 loc = new Transporter.Vector4(mover.player.func_226277_ct_(), mover.player.func_226278_cu_(), mover.player.func_226281_cx_(), mover.player.field_71093_bK.func_186068_a());
            Transporter.Vector4 diff = new Transporter.Vector4(mover.start.x, mover.start.y, mover.start.z, mover.player.field_71093_bK.func_186068_a());
            diff.sub(loc);
            if (tick.getEntity().func_130014_f_().func_82737_E() > mover.moveTime) {
                mover.move();
                toMove.remove(tick.getEntity().func_110124_au());
            } else if (diff.lengthSquared() > 0.0 && mover.moveTime > 0L) {
                if (mover.failMess != null) {
                    tick.getEntity().func_145747_a(mover.failMess);
                }
                toMove.remove(tick.getEntity().func_110124_au());
                return;
            }
        }
    }

    static {
        offset = new Transporter.Vector4(0.5, 0.5, 0.5, 0.0f);
        toMove = Maps.newHashMap();
    }

    private static class Mover {
        final long moveTime;
        final PlayerEntity player;
        final int dimension;
        final BlockPos moveTo;
        final Transporter.Vector4 start;
        final ITextComponent message;
        final ITextComponent failMess;
        final boolean event;
        final Predicate<Entity> callback;

        public Mover(PlayerEntity player, long moveTime, int dimension, BlockPos moveTo, ITextComponent message, ITextComponent failMess, Predicate<Entity> callback, boolean event) {
            this.player = player;
            this.dimension = dimension;
            this.moveTime = moveTime;
            this.moveTo = moveTo;
            this.message = message;
            this.failMess = failMess;
            this.event = event;
            this.callback = callback;
            this.start = new Transporter.Vector4(player.func_226277_ct_(), player.func_226278_cu_(), player.func_226281_cx_(), dimension);
        }

        private void move() {
            if (this.event) {
                MinecraftForge.EVENT_BUS.post((Event)new MoveEvent(this.player));
            }
            Transporter.Vector4 dest = new Transporter.Vector4(this.moveTo, this.dimension);
            dest.add(offset);
            if (Essentials.config.log_teleports) {
                Essentials.LOGGER.trace("TP: " + this.player.func_110124_au() + " " + this.player.func_200200_C_() + " from: " + this.start + " to " + this.moveTo);
            }
            Entity player1 = Transporter.transferTo((Entity)this.player, dest);
            if (this.callback != null) {
                this.callback.test(player1);
            }
            if (this.message != null) {
                player1.func_145747_a(this.message);
            }
        }
    }
}

