/*
 * Decompiled with CFR 0.152.
 */
package thut.essentials.util;

import net.minecraft.entity.Entity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.chunk.ChunkStatus;
import net.minecraft.world.chunk.IChunk;
import net.minecraft.world.dimension.DimensionType;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public class Transporter {
    public static Entity transferTo(Entity entity, Vector4 dest) {
        return Transporter.transferTo(entity, dest, false);
    }

    public static Entity transferTo(Entity entity, Vector4 dest, boolean sound) {
        if (entity.func_130014_f_() instanceof ServerWorld) {
            new InvulnTicker(entity);
            if (dest.w == (float)entity.field_71093_bK.func_186068_a()) {
                return Transporter.moveMob(entity, dest);
            }
            ServerWorld destWorld = entity.func_184102_h().func_71218_a(DimensionType.func_186069_a((int)((int)dest.w)));
            if (entity instanceof ServerPlayerEntity) {
                ServerPlayerEntity player = (ServerPlayerEntity)entity;
                player.field_184851_cj = true;
                player.func_200619_a(destWorld, (double)dest.x, (double)dest.y, (double)dest.z, entity.field_70177_z, entity.field_70125_A);
                if (sound) {
                    destWorld.func_184134_a((double)dest.x, (double)dest.y, (double)dest.z, SoundEvents.field_187534_aX, SoundCategory.BLOCKS, 1.0f, 1.0f, false);
                    player.func_184185_a(SoundEvents.field_187534_aX, 1.0f, 1.0f);
                }
                player.field_184851_cj = false;
                return player;
            }
            new TransferTicker(destWorld, entity, dest, sound);
            return entity;
        }
        return entity;
    }

    private static void transferMob(ServerWorld destWorld, Vector4 dest, Entity entity) {
        ServerPlayerEntity player = null;
        if (entity instanceof ServerPlayerEntity) {
            player = (ServerPlayerEntity)entity;
            player.field_184851_cj = true;
        }
        ServerWorld serverworld = (ServerWorld)entity.func_130014_f_();
        entity.field_71093_bK = destWorld.field_73011_w.func_186058_p();
        Transporter.removeMob(serverworld, entity, true);
        entity.revive();
        entity.func_70012_b((double)dest.x, (double)dest.y, (double)dest.z, entity.field_70177_z, entity.field_70125_A);
        entity.func_70029_a((World)destWorld);
        Transporter.addMob(destWorld, entity);
        if (player != null) {
            player.field_184851_cj = false;
        }
    }

    private static void addMob(ServerWorld world, Entity entity) {
        if (MinecraftForge.EVENT_BUS.post((Event)new EntityJoinWorldEvent(entity, (World)world))) {
            return;
        }
        IChunk ichunk = world.func_217353_a(MathHelper.func_76128_c((double)(entity.func_226277_ct_() / 16.0)), MathHelper.func_76128_c((double)(entity.func_226281_cx_() / 16.0)), ChunkStatus.field_222617_m, true);
        if (ichunk instanceof Chunk) {
            ichunk.func_76612_a(entity);
        }
        world.func_217440_f(entity);
    }

    private static void removeMob(ServerWorld world, Entity entity, boolean keepData) {
        entity.remove(keepData);
        world.removeEntity(entity, keepData);
    }

    private static Entity moveMob(Entity entity, Vector4 dest) {
        if (entity instanceof ServerPlayerEntity) {
            ((ServerPlayerEntity)entity).field_71135_a.func_147364_a((double)dest.x, (double)dest.y, (double)dest.z, entity.field_70177_z, entity.field_70125_A);
            ((ServerPlayerEntity)entity).field_71135_a.func_184342_d();
        } else {
            entity.func_70012_b((double)dest.x, (double)dest.y, (double)dest.z, entity.field_70177_z, entity.field_70125_A);
        }
        return entity;
    }

    private static class TransferTicker {
        private final Entity entity;
        private final ServerWorld destWorld;
        private final Vector4 dest;
        private final boolean sound;

        public TransferTicker(ServerWorld destWorld, Entity entity, Vector4 dest, boolean sound) {
            this.entity = entity;
            this.dest = dest;
            this.sound = sound;
            this.destWorld = destWorld;
            MinecraftForge.EVENT_BUS.register((Object)this);
        }

        @SubscribeEvent
        public void TickEvent(TickEvent.WorldTickEvent event) {
            if (event.world == this.entity.func_130014_f_() && event.phase == TickEvent.Phase.END) {
                MinecraftForge.EVENT_BUS.unregister((Object)this);
                Transporter.transferMob(this.destWorld, this.dest, this.entity);
                if (this.sound) {
                    this.destWorld.func_184134_a((double)this.dest.x, (double)this.dest.y, (double)this.dest.z, SoundEvents.field_187534_aX, SoundCategory.BLOCKS, 1.0f, 1.0f, false);
                    this.entity.func_184185_a(SoundEvents.field_187534_aX, 1.0f, 1.0f);
                }
            }
        }
    }

    private static class InvulnTicker {
        private final ServerWorld overworld;
        private final Entity entity;
        private final long start;

        public InvulnTicker(Entity entity) {
            this.entity = entity;
            this.overworld = entity.func_184102_h().func_71218_a(DimensionType.field_223227_a_);
            this.start = this.overworld.func_82737_E();
            MinecraftForge.EVENT_BUS.register((Object)this);
        }

        @SubscribeEvent
        public void damage(LivingHurtEvent event) {
            if (event.getEntity() != this.entity) {
                return;
            }
            long time = this.overworld.func_82737_E();
            if (time - this.start > 20L) {
                MinecraftForge.EVENT_BUS.unregister((Object)this);
                return;
            }
            event.setCanceled(true);
        }
    }

    public static class Vector4 {
        public float x;
        public float y;
        public float z;
        public float w;

        public Vector4() {
            this.w = 0.0f;
            this.z = 0.0f;
            this.y = 0.0f;
            this.x = 1.0f;
        }

        public Vector4(BlockPos pos, DimensionType dim) {
            this();
            this.x = pos.func_177958_n();
            this.y = pos.func_177956_o();
            this.z = pos.func_177952_p();
            this.w = dim.func_186068_a();
        }

        public Vector4(CompoundNBT nbt) {
            this();
            this.x = nbt.func_74760_g("x");
            this.y = nbt.func_74760_g("y");
            this.z = nbt.func_74760_g("z");
            this.w = nbt.func_74760_g("w");
        }

        public Vector4(double posX, double posY, double posZ, float w) {
            this.x = (float)posX;
            this.y = (float)posY;
            this.z = (float)posZ;
            this.w = w;
        }

        public Vector4(Entity e) {
            this(e.func_226277_ct_(), e.func_226278_cu_(), e.func_226281_cx_(), e.field_71093_bK.func_186068_a());
        }

        public Vector4(String toParse) {
            String[] vals = toParse.split(" ");
            if (vals.length == 4) {
                this.x = Float.parseFloat(vals[0]);
                this.y = Float.parseFloat(vals[1]);
                this.z = Float.parseFloat(vals[2]);
                this.w = Float.parseFloat(vals[3]);
            }
        }

        public Vector4(BlockPos moveTo, int dimension) {
            this(moveTo.func_177958_n(), moveTo.func_177956_o(), moveTo.func_177952_p(), dimension);
        }

        public Vector4 copy() {
            return new Vector4(this.x, this.y, this.z, this.w);
        }

        public boolean equals(Object o) {
            if (o instanceof Vector4) {
                Vector4 v = (Vector4)o;
                return v.x == this.x && v.y == this.y && v.z == this.z && v.w == this.w;
            }
            return super.equals(o);
        }

        public String toString() {
            return "x:" + this.x + " y:" + this.y + " z:" + this.z + " w:" + this.w;
        }

        public boolean withinDistance(float distance, Vector4 toCheck) {
            return (int)this.w == (int)toCheck.w && toCheck.x >= this.x - distance && toCheck.z >= this.z - distance && toCheck.y >= this.y - distance && toCheck.y <= this.y + distance && toCheck.x <= this.x + distance && toCheck.z <= this.z + distance;
        }

        public void writeToNBT(CompoundNBT nbt) {
            nbt.func_74776_a("x", this.x);
            nbt.func_74776_a("y", this.y);
            nbt.func_74776_a("z", this.z);
            nbt.func_74776_a("w", this.w);
        }

        public void add(Vector4 offset) {
            this.x += offset.x;
            this.y += offset.y;
            this.z += offset.z;
        }

        public void sub(Vector4 offset) {
            this.x -= offset.x;
            this.y -= offset.y;
            this.z -= offset.z;
        }

        public double lengthSquared() {
            return this.x * this.x + this.y * this.y + this.z * this.z;
        }
    }
}

