/*
 * Decompiled with CFR 0.152.
 */
package thut.essentials.util;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Map;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.event.ClickEvent;
import net.minecraft.world.dimension.DimensionType;
import net.minecraftforge.server.permission.DefaultPermissionLevel;
import net.minecraftforge.server.permission.IPermissionHandler;
import net.minecraftforge.server.permission.PermissionAPI;
import net.minecraftforge.server.permission.context.IContext;
import net.minecraftforge.server.permission.context.PlayerContext;
import thut.essentials.Config;
import thut.essentials.Essentials;
import thut.essentials.commands.CommandManager;
import thut.essentials.util.PlayerDataHandler;
import thut.essentials.util.PlayerMover;

public class WarpManager {
    public static Map<String, int[]> warpLocs;
    static final Field warpsField;

    public static void init() {
        warpLocs = Maps.newHashMap();
        for (String s : Essentials.config.warps) {
            String[] args = s.split(":");
            warpLocs.put(args[0], WarpManager.getInt(args[1]));
        }
        IPermissionHandler manager = PermissionAPI.getPermissionHandler();
        for (String s : warpLocs.keySet()) {
            String node = "thutessentials.warp." + s;
            if (manager.getRegisteredNodes().contains(node)) continue;
            manager.registerNode(node, DefaultPermissionLevel.ALL, "Warp to " + s);
        }
    }

    static int[] getInt(String val) {
        String[] args = val.split(" ");
        int dim = args.length == 4 ? Integer.parseInt(args[3]) : 0;
        return new int[]{Integer.parseInt(args[0]), Integer.parseInt(args[1]), Integer.parseInt(args[2]), dim};
    }

    public static int setWarp(BlockPos center, int dimension, String name) {
        ArrayList warps = Lists.newArrayList(Essentials.config.warps);
        for (String s : warps) {
            String[] args = s.split(":");
            if (!args[0].equals(name)) continue;
            return 1;
        }
        String warp = name + ":" + center.func_177958_n() + " " + center.func_177956_o() + " " + center.func_177952_p() + " " + dimension;
        warps.add(warp);
        warpLocs.put(name, new int[]{center.func_177958_n(), center.func_177956_o(), center.func_177952_p(), dimension});
        IPermissionHandler manager = PermissionAPI.getPermissionHandler();
        String node = "thutessentials.warp." + name;
        if (!manager.getRegisteredNodes().contains(node)) {
            manager.registerNode(node, DefaultPermissionLevel.ALL, "Warp to " + name);
        }
        Essentials.config.warps = warps;
        Essentials.config.write();
        return 0;
    }

    public static int delWarp(String name) {
        ArrayList warps = Lists.newArrayList(Essentials.config.warps);
        for (String s : warps) {
            String[] args = s.split(":");
            if (!args[0].equals(name)) continue;
            warps.remove(s);
            warpLocs.remove(name);
            Essentials.config.warps = warps;
            Essentials.config.write();
            return 0;
        }
        return 1;
    }

    public static int[] getWarp(String name) {
        return warpLocs.get(name);
    }

    public static void sendWarpsList(ServerPlayerEntity player) {
        IPermissionHandler manager = PermissionAPI.getPermissionHandler();
        PlayerContext context = new PlayerContext((PlayerEntity)player);
        player.func_145747_a(CommandManager.makeFormattedComponent("thutessentials.warps.header"));
        for (String s : Essentials.config.warps) {
            String[] args = s.split(":");
            s = args[0];
            if (!manager.hasPermission(player.func_146103_bH(), "thutessentials.warp." + s, (IContext)context)) continue;
            ITextComponent message = CommandManager.makeFormattedComponent("thutessentials.warps.entry", null, false, s);
            if (s.contains(" ")) {
                s = "\"" + s + "\"";
            }
            Style style = new Style();
            style.func_150241_a(new ClickEvent(ClickEvent.Action.RUN_COMMAND, "/warp " + s));
            player.func_145747_a(message.func_150255_a(style));
        }
        player.func_145747_a(CommandManager.makeFormattedComponent("thutessentials.warps.footer"));
    }

    public static int attemptWarp(ServerPlayerEntity player, String warpName) {
        long time;
        int[] warp = WarpManager.getWarp(warpName);
        CompoundNBT tag = PlayerDataHandler.getCustomDataTag((PlayerEntity)player);
        CompoundNBT tptag = tag.func_74775_l("tp");
        long last = tptag.func_74763_f("warpDelay");
        if (last > (time = player.func_184102_h().func_71218_a(DimensionType.field_223227_a_).func_82737_E()) && Essentials.config.warpReUseDelay > 0) {
            return 1;
        }
        if (warp != null) {
            IPermissionHandler manager = PermissionAPI.getPermissionHandler();
            PlayerContext context = new PlayerContext((PlayerEntity)player);
            if (!manager.hasPermission(player.func_146103_bH(), "thutessentials.warp." + warpName, (IContext)context)) {
                return 2;
            }
            ITextComponent teleMess = CommandManager.makeFormattedComponent("thutessentials.warps.warped", null, false, warpName);
            PlayerMover.setMove((PlayerEntity)player, Essentials.config.warpActivateDelay, warp[3], new BlockPos(warp[0], warp[1], warp[2]), teleMess, PlayerMover.INTERUPTED);
            tptag.func_74772_a("warpDelay", time + (long)Essentials.config.warpReUseDelay);
            tag.func_218657_a("tp", (INBT)tptag);
            PlayerDataHandler.saveCustomData((PlayerEntity)player);
            return 0;
        }
        return 3;
    }

    static {
        Field temp = null;
        try {
            temp = Config.class.getDeclaredField("warps");
        }
        catch (NoSuchFieldException | SecurityException e) {
            e.printStackTrace();
        }
        warpsField = temp;
    }
}

