/*
 * Decompiled with CFR 0.152.
 */
package thut.essentials.util.world;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MutableBoundingBox;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityInject;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.capabilities.ICapabilitySerializable;
import net.minecraftforge.common.util.INBTSerializable;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import thut.essentials.util.world.IHasStructures;

public class WorldStructures
implements IHasStructures,
ICapabilitySerializable<ListNBT> {
    private static final ResourceLocation CAPTAG = new ResourceLocation("thutessentials", "genned_structures");
    @CapabilityInject(value=IHasStructures.class)
    public static final Capability<IHasStructures> CAPABILITY = null;
    private final LazyOptional<IHasStructures> holder = LazyOptional.of(() -> this);
    List<StructInfo> structs = Lists.newArrayList();

    public static void setup() {
        CapabilityManager.INSTANCE.register(IHasStructures.class, (Capability.IStorage)new Storage(), WorldStructures::new);
        MinecraftForge.EVENT_BUS.register(WorldStructures.class);
    }

    @SubscribeEvent
    public static void attach(AttachCapabilitiesEvent<World> event) {
        if (!(event.getObject() instanceof ServerWorld)) {
            return;
        }
        if (event.getCapabilities().containsKey(CAPTAG)) {
            return;
        }
        event.addCapability(CAPTAG, (ICapabilityProvider)new WorldStructures());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void putStructure(ResourceLocation key, MutableBoundingBox box) {
        List<StructInfo> list = this.structs;
        synchronized (list) {
            this.structs.add(new StructInfo(key, new MutableBoundingBox(box)));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Collection<ResourceLocation> getStructures(BlockPos pos) {
        ArrayList ret = Lists.newArrayList();
        List<StructInfo> list = this.structs;
        synchronized (list) {
            for (StructInfo i : this.structs) {
                if (!i.box.func_175898_b((Vec3i)pos)) continue;
                ret.add(i.key);
            }
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeStructures(ResourceLocation key, MutableBoundingBox box) {
        List<StructInfo> list = this.structs;
        synchronized (list) {
            this.structs.removeIf(i -> (key == null || i.key.equals((Object)key)) && i.box.func_78884_a(box));
        }
    }

    public <T> LazyOptional<T> getCapability(Capability<T> cap, Direction side) {
        return CAPABILITY.orEmpty(cap, this.holder);
    }

    public ListNBT serializeNBT() {
        ListNBT list = new ListNBT();
        for (StructInfo i : this.structs) {
            list.add((Object)i.serializeNBT());
        }
        return list;
    }

    public void deserializeNBT(ListNBT nbt) {
        this.structs.clear();
        for (INBT tag : nbt) {
            if (!(tag instanceof CompoundNBT)) continue;
            this.structs.add(new StructInfo((CompoundNBT)tag));
        }
    }

    public static class Storage
    implements Capability.IStorage<IHasStructures> {
        public void readNBT(Capability<IHasStructures> capability, IHasStructures instance, Direction side, INBT nbt) {
            if (instance instanceof ICapabilitySerializable) {
                ((ICapabilitySerializable)instance).deserializeNBT(nbt);
            }
        }

        public INBT writeNBT(Capability<IHasStructures> capability, IHasStructures instance, Direction side) {
            if (instance instanceof ICapabilitySerializable) {
                return ((ICapabilitySerializable)instance).serializeNBT();
            }
            return null;
        }
    }

    public static class StructInfo
    implements INBTSerializable<CompoundNBT> {
        ResourceLocation key;
        MutableBoundingBox box;

        public StructInfo(ResourceLocation key, MutableBoundingBox box) {
            this.key = key;
            this.box = box;
        }

        public StructInfo(CompoundNBT tag) {
            this.deserializeNBT(tag);
        }

        public CompoundNBT serializeNBT() {
            CompoundNBT tag = new CompoundNBT();
            tag.func_74778_a("key", this.key.toString());
            tag.func_218657_a("box", (INBT)this.box.func_151535_h());
            return tag;
        }

        public void deserializeNBT(CompoundNBT nbt) {
            this.key = new ResourceLocation(nbt.func_74779_i("key"));
            this.box = new MutableBoundingBox(nbt.func_74759_k("box"));
        }
    }
}

