/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.abilities;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.particles.ParticleType;
import net.minecraft.util.DamageSource;
import xyz.pixelatedw.mineminenomi.api.abilities.DamagedPassiveAbility;
import xyz.pixelatedw.mineminenomi.api.helpers.AbilityHelper;
import xyz.pixelatedw.mineminenomi.api.helpers.DevilFruitHelper;
import xyz.pixelatedw.mineminenomi.api.helpers.HakiHelper;
import xyz.pixelatedw.mineminenomi.api.helpers.ItemsHelper;
import xyz.pixelatedw.mineminenomi.config.CommonConfig;
import xyz.pixelatedw.mineminenomi.data.entity.devilfruit.DevilFruitCapability;
import xyz.pixelatedw.mineminenomi.data.entity.entitystats.EntityStatsCapability;
import xyz.pixelatedw.mineminenomi.entities.projectiles.extra.KairosekiBulletProjectile;
import xyz.pixelatedw.mineminenomi.init.ModEffects;
import xyz.pixelatedw.mineminenomi.particles.data.GenericParticleData;
import xyz.pixelatedw.mineminenomi.particles.effects.common.LogiaParticleEffect;
import xyz.pixelatedw.mineminenomi.wypi.APIConfig;
import xyz.pixelatedw.mineminenomi.wypi.abilities.Ability;
import xyz.pixelatedw.mineminenomi.wypi.abilities.IChangeDamageSourceAbility;
import xyz.pixelatedw.mineminenomi.wypi.abilities.projectiles.AbilityProjectileEntity;
import xyz.pixelatedw.mineminenomi.wypi.data.ability.AbilityDataCapability;

public class LogiaInvulnerabilityAbility
extends DamagedPassiveAbility {
    private final ParticleType<GenericParticleData> particle;
    protected ILogiaEffect onSpecificLogiaEffect = (target, attacker) -> true;
    private final DamageSource[] newSources;
    private final String name;
    public LogiaParticleEffect particleEffect;
    public ArrayList<DamageSource> immunitySources = new ArrayList<DamageSource>(Arrays.asList(DamageSource.field_76367_g, DamageSource.field_220302_v, DamageSource.field_82728_o, DamageSource.field_188406_j, DamageSource.field_76379_h, DamageSource.field_82729_p, DamageSource.field_191552_t));
    private ArrayList<String> acceptableInstantSources = new ArrayList<String>(Arrays.asList("mob", "player"));
    private LogiaParticleEffect fireLogiaParticleEffect = null;

    public LogiaInvulnerabilityAbility(ParticleType<GenericParticleData> particle, String name, ILogiaEffect effect, DamageSource ... sources) {
        super("Logia Invulnerability " + name, AbilityHelper.getDevilFruitCategory());
        this.setDescription("Allows the user to avoid attacks by instinctively transforming parts of their body into their specific element");
        this.particle = particle;
        this.name = name;
        this.newSources = sources;
        this.immunitySources.addAll(Arrays.asList(this.newSources));
        this.onDamagedEvent = this::onDamagedEvent;
        if (effect != null) {
            this.onSpecificLogiaEffect = effect;
        }
        this.particleEffect = new LogiaParticleEffect(this.particle);
        this.hideInGUI(false);
        this.setDisplayName("Logia Invulnerability");
    }

    public boolean onDamagedEvent(LivingEntity entity, DamageSource damageSource) {
        if (!((Boolean)CommonConfig.INSTANCE.logiaInvulnerability.get()).booleanValue() || !DevilFruitCapability.get(entity).isLogia() || entity.func_70644_a(ModEffects.ABILITY_OFF) || DevilFruitHelper.kairosekiChecks(entity)) {
            return true;
        }
        if (damageSource.func_94541_c()) {
            this.spawnParticles((Entity)entity, false);
            return false;
        }
        boolean result = true;
        Entity trueSource = damageSource.func_76346_g();
        Entity instantSource = damageSource.func_76364_f();
        if (instantSource instanceof LivingEntity && this.acceptableInstantSources.contains(damageSource.func_76355_l())) {
            result = false;
            boolean isUsingChangeDamageSource = Arrays.stream(AbilityDataCapability.get((LivingEntity)instantSource).getEquippedAbilities(APIConfig.AbilityCategory.ALL)).anyMatch(ability -> ability instanceof IChangeDamageSourceAbility && ((IChangeDamageSourceAbility)ability).isSourceChangeEnabled());
            if (!isUsingChangeDamageSource) {
                boolean bypassInvulnerability;
                result = this.onSpecificLogiaEffect.attackerEffect(entity, (LivingEntity)instantSource);
                ItemStack heldItem = ((LivingEntity)instantSource).func_184614_ca();
                boolean hasHardeningHaki = heldItem.func_190926_b() && HakiHelper.hasHardeningActive((LivingEntity)instantSource);
                boolean hasImbuingHaki = !heldItem.func_190926_b() && HakiHelper.hasImbuingActive((LivingEntity)instantSource);
                boolean hasKairosekiWeapon = ItemsHelper.isKairosekiWeapon(heldItem);
                boolean bl = bypassInvulnerability = hasHardeningHaki || hasImbuingHaki || hasKairosekiWeapon;
                if (bypassInvulnerability) {
                    return true;
                }
            }
        }
        if (!EntityStatsCapability.get(entity).hasShadow()) {
            this.immunitySources.remove(DamageSource.field_76372_a);
            this.immunitySources.remove(DamageSource.field_76370_b);
            this.immunitySources.remove(DamageSource.field_76371_c);
        }
        if (damageSource.func_76352_a()) {
            result = instantSource instanceof KairosekiBulletProjectile;
            if (instantSource instanceof AbilityProjectileEntity && trueSource instanceof LivingEntity && CommonConfig.INSTANCE.doLogiasHaveHurtHakiLogic()) {
                AbilityProjectileEntity projectileEntity = (AbilityProjectileEntity)instantSource;
                if (projectileEntity.isPhysical()) {
                    if (projectileEntity.isAffectedByHardening() && HakiHelper.hasHardeningActive((LivingEntity)trueSource)) {
                        result = true;
                    } else if (projectileEntity.isAffectedByImbuing() && HakiHelper.hasImbuingActive((LivingEntity)trueSource)) {
                        result = true;
                    }
                } else {
                    result = CommonConfig.INSTANCE.doLogiasHaveHurtExtendedLogic();
                }
            }
        }
        if (this.immunitySources.stream().anyMatch(s -> damageSource.func_76355_l().equals(s.func_76355_l()))) {
            result = false;
        }
        boolean fireResistance = this.immunitySources.stream().anyMatch(s -> s.func_76355_l().equals("inFire")) && (damageSource.func_76355_l().equals("inFire") || damageSource.func_76355_l().equals("onFire"));
        boolean magmaImmunity = this.immunitySources.stream().anyMatch(s -> s.func_76355_l().equals("lava")) && damageSource.func_76347_k();
        boolean spawnFireParticles = false;
        if (fireResistance || magmaImmunity) {
            entity.func_70066_B();
            if (result && CommonConfig.INSTANCE.doLogiasHaveHurtExtendedLogic() && instantSource instanceof AbilityProjectileEntity) {
                return true;
            }
            spawnFireParticles = true;
            result = false;
        }
        if (!result) {
            this.spawnParticles((Entity)entity, spawnFireParticles);
        }
        return result;
    }

    private void spawnParticles(Entity entity, boolean isFire) {
        if (isFire) {
            if (this.fireLogiaParticleEffect == null) {
                this.fireLogiaParticleEffect = new LogiaParticleEffect(this.particle);
            }
            this.fireLogiaParticleEffect.ownerID = entity.func_145782_y();
            this.fireLogiaParticleEffect.hideTooClose = true;
            this.fireLogiaParticleEffect.spawn(entity.field_70170_p, entity.func_226277_ct_(), entity.func_226278_cu_(), entity.func_226281_cx_(), 0.0, 0.0, 0.0);
        } else {
            this.particleEffect.spawn(entity.field_70170_p, entity.func_226277_ct_(), entity.func_226278_cu_(), entity.func_226281_cx_(), 0.0, 0.0, 0.0);
        }
    }

    @Override
    public Ability create() {
        try {
            return (Ability)((Object)((Object)((Object)this)).getClass().getConstructor(ParticleType.class, String.class, ILogiaEffect.class, DamageSource[].class).newInstance(this.particle, this.name, this.onSpecificLogiaEffect, this.newSources));
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return null;
        }
    }

    public static interface ILogiaEffect
    extends Serializable {
        public boolean attackerEffect(LivingEntity var1, LivingEntity var2);
    }
}

