/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.abilities;

import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.network.IPacket;
import net.minecraft.network.play.server.SPlayerAbilitiesPacket;
import xyz.pixelatedw.mineminenomi.abilities.suna.DesertGirasoleAbility;
import xyz.pixelatedw.mineminenomi.api.helpers.AbilityHelper;
import xyz.pixelatedw.mineminenomi.api.helpers.DevilFruitHelper;
import xyz.pixelatedw.mineminenomi.config.CommonConfig;
import xyz.pixelatedw.mineminenomi.data.entity.devilfruit.DevilFruitCapability;
import xyz.pixelatedw.mineminenomi.data.entity.devilfruit.IDevilFruit;
import xyz.pixelatedw.mineminenomi.init.ModAbilities;
import xyz.pixelatedw.mineminenomi.init.ModAttributes;
import xyz.pixelatedw.mineminenomi.init.ModEffects;
import xyz.pixelatedw.mineminenomi.init.ModParticleTypes;
import xyz.pixelatedw.mineminenomi.packets.server.SFlightValuePacket;
import xyz.pixelatedw.mineminenomi.particles.effects.ParticleEffect;
import xyz.pixelatedw.mineminenomi.particles.effects.common.SpecialFlyingParticleEffect;
import xyz.pixelatedw.mineminenomi.wypi.abilities.PassiveAbility;
import xyz.pixelatedw.mineminenomi.wypi.network.WyNetwork;

public class SpecialFlyAbility
extends PassiveAbility {
    public static final SpecialFlyAbility INSTANCE = new SpecialFlyAbility();
    private static final ParticleEffect PARTICLES_SUNA = new SpecialFlyingParticleEffect(ModParticleTypes.SUNA2);
    private static final ParticleEffect PARTICLES_GASU = new SpecialFlyingParticleEffect(ModParticleTypes.GASU);
    private static final ParticleEffect PARTICLES_MOKU = new SpecialFlyingParticleEffect(ModParticleTypes.MOKU);

    public SpecialFlyAbility() {
        super("Special Fly", AbilityHelper.getDevilFruitCategory());
        this.setDescription("Allows the user to fly");
        this.duringPassiveEvent = this::duringPassiveEvent;
        this.hideInGUI(false);
        this.setDisplayName("Elemental Flight");
        this.setCustomTexture("special_fly");
    }

    @Override
    public void tick(PlayerEntity player) {
        if (this.isPaused() && !player.func_184812_l_() && !player.func_175149_v() && player.field_71075_bZ.field_75101_c) {
            player.field_71075_bZ.field_75101_c = false;
            player.field_71075_bZ.field_75100_b = false;
            if (player instanceof ServerPlayerEntity) {
                ((ServerPlayerEntity)player).field_71135_a.func_147359_a((IPacket)new SPlayerAbilitiesPacket(player.field_71075_bZ));
            }
        }
        super.tick(player);
    }

    private void duringPassiveEvent(PlayerEntity player) {
        boolean flight;
        if (!CommonConfig.INSTANCE.isSpecialFlyingEnabled() || player.func_184812_l_() || player.func_175149_v()) {
            return;
        }
        IDevilFruit props = DevilFruitCapability.get((LivingEntity)player);
        boolean isSuna = props.hasDevilFruit(ModAbilities.SUNA_SUNA_NO_MI);
        if (player.func_110148_a(ModAttributes.JUMP_HEIGHT).func_111126_e() < 0.0 || isSuna && player.field_70170_p.func_72896_J() || 6 > player.func_71024_bL().func_75116_a()) {
            player.field_71075_bZ.field_75101_c = false;
            player.field_71075_bZ.field_75100_b = false;
            if (player instanceof ServerPlayerEntity) {
                ((ServerPlayerEntity)player).field_71135_a.func_147359_a((IPacket)new SPlayerAbilitiesPacket(player.field_71075_bZ));
            }
            return;
        }
        boolean isGasu = props.hasDevilFruit(ModAbilities.GASU_GASU_NO_MI);
        boolean isMoku = props.hasDevilFruit(ModAbilities.MOKU_MOKU_NO_MI);
        boolean isFlying = player.field_71075_bZ.field_75100_b;
        boolean bl = flight = !AbilityHelper.isAffectedByWater((LivingEntity)player) && !player.func_70644_a(ModEffects.ABILITY_OFF) && !DevilFruitHelper.kairosekiChecks((LivingEntity)player);
        if (!player.field_70170_p.field_72995_K) {
            WyNetwork.sendTo(new SFlightValuePacket(flight), player);
            player.field_71075_bZ.field_75101_c = flight;
            if (isFlying) {
                if (isSuna) {
                    PARTICLES_SUNA.spawn(player.field_70170_p, player.func_226277_ct_(), player.func_226278_cu_(), player.func_226281_cx_(), 0.0, 0.0, 0.0);
                } else if (isMoku) {
                    PARTICLES_MOKU.spawn(player.field_70170_p, player.func_226277_ct_(), player.func_226278_cu_(), player.func_226281_cx_(), 0.0, 0.0, 0.0);
                } else if (isGasu) {
                    PARTICLES_GASU.spawn(player.field_70170_p, player.func_226277_ct_(), player.func_226278_cu_(), player.func_226281_cx_(), 0.0, 0.0, 0.0);
                }
            }
        }
        if (isFlying) {
            boolean canFly;
            double maxDifference;
            double d = maxDifference = isGasu ? 32.0 : 20.0;
            float speedMultiplier = isGasu ? 1.0f : (isMoku ? 0.95f : (DesertGirasoleAbility.isFruitBoosted(player) ? 0.915f : 0.9f));
            player.func_213317_d(player.func_213322_ci().func_216372_d((double)speedMultiplier, (double)(speedMultiplier - 0.25f), (double)speedMultiplier));
            if (player.func_70051_ag()) {
                player.func_213317_d(player.func_213322_ci().func_216372_d(0.67, 1.0, 0.67));
                player.func_70031_b(false);
            }
            if (player.field_70173_aa % 20 == 0) {
                player.func_71020_j(0.1f);
            }
            DevilFruitHelper.vanillaFlightThreshold((LivingEntity)player, (canFly = DevilFruitHelper.isFlyingAtMaxHeight(player, maxDifference)) ? 256 : (int)player.func_226278_cu_() - 1);
        }
        if (!flight) {
            player.field_71075_bZ.field_75100_b = false;
        }
    }
}

