/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.abilities.bane;

import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.network.IPacket;
import net.minecraft.network.play.server.SEntityVelocityPacket;
import net.minecraft.util.DamageSource;
import net.minecraft.util.math.Vec3d;
import xyz.pixelatedw.mineminenomi.abilities.bane.SpringHopperAbility;
import xyz.pixelatedw.mineminenomi.api.abilities.IMultiTargetAbility;
import xyz.pixelatedw.mineminenomi.api.helpers.AbilityHelper;
import xyz.pixelatedw.mineminenomi.wypi.WyHelper;
import xyz.pixelatedw.mineminenomi.wypi.abilities.Ability;
import xyz.pixelatedw.mineminenomi.wypi.abilities.ChargeableAbility;
import xyz.pixelatedw.mineminenomi.wypi.data.ability.AbilityDataCapability;
import xyz.pixelatedw.mineminenomi.wypi.data.ability.IAbilityData;

public class SpringSnipeAbility
extends ChargeableAbility
implements IMultiTargetAbility {
    public static final Ability INSTANCE = new SpringSnipeAbility();
    Vec3d v;

    public SpringSnipeAbility() {
        super("Spring Snipe", AbilityHelper.getDevilFruitCategory());
        this.setMaxCooldown(14.5);
        this.setMaxChargeTime(0.5);
        this.setDescription("Turning the user's forelegs into springs, they can launch themselves directly at the opponent");
        this.onStartChargingEvent = this::onStartChargingEvent;
        this.onEndChargingEvent = this::onEndChargingEvent;
        this.duringCooldownEvent = this::duringCooldown;
    }

    private boolean onStartChargingEvent(PlayerEntity player) {
        IAbilityData props = AbilityDataCapability.get((LivingEntity)player);
        SpringHopperAbility ability = (SpringHopperAbility)props.getEquippedAbility(SpringHopperAbility.INSTANCE);
        if (ability == null || ability.isOnCooldown()) {
            return false;
        }
        if (!ability.isContinuous()) {
            ability.startContinuity(player);
        }
        ability.jumpPower = Math.min(ability.jumpPower + 3, 9);
        this.clearTargets();
        return AbilityHelper.canUseMomentumAbility(player);
    }

    private boolean onEndChargingEvent(PlayerEntity player) {
        this.v = player.func_70676_i(1.0f);
        return true;
    }

    private void duringCooldown(PlayerEntity player, int cooldownTimer) {
        if (this.canDealDamage()) {
            IAbilityData props = AbilityDataCapability.get((LivingEntity)player);
            SpringHopperAbility ability = (SpringHopperAbility)props.getEquippedAbility(SpringHopperAbility.INSTANCE);
            Vec3d speed = this.v.func_216372_d(3.0, 3.0, 3.0);
            player.func_213293_j(speed.field_72450_a, speed.field_72448_b, speed.field_72449_c);
            ((ServerPlayerEntity)player).field_71135_a.func_147359_a((IPacket)new SEntityVelocityPacket((Entity)player));
            List<LivingEntity> list = WyHelper.getEntitiesNear(player.func_180425_c(), player.field_70170_p, 2.0);
            list.remove(player);
            list.forEach(entity -> {
                if (this.isTarget((LivingEntity)entity) && player.func_70685_l((Entity)entity)) {
                    entity.func_70097_a(DamageSource.func_76365_a((PlayerEntity)player), (float)(ability.jumpPower * 6));
                }
            });
        }
    }

    public boolean canDealDamage() {
        return this.cooldown > this.getMaxCooldown() * 0.9;
    }
}

