/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.abilities.bari;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.Blocks;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import xyz.pixelatedw.mineminenomi.api.helpers.AbilityHelper;
import xyz.pixelatedw.mineminenomi.api.protection.BlockProtectionRule;
import xyz.pixelatedw.mineminenomi.api.protection.block.AirBlockProtectionRule;
import xyz.pixelatedw.mineminenomi.api.protection.block.FoliageBlockProtectionRule;
import xyz.pixelatedw.mineminenomi.init.ModBlocks;
import xyz.pixelatedw.mineminenomi.wypi.abilities.ContinuousAbility;

public class BarrierAbility
extends ContinuousAbility {
    public static final BarrierAbility INSTANCE = new BarrierAbility();
    private static final BlockProtectionRule GRIEF_RULE = new BlockProtectionRule(AirBlockProtectionRule.INSTANCE, FoliageBlockProtectionRule.INSTANCE).setBypassGriefRule();
    private List<BlockPos> posList = new ArrayList<BlockPos>();

    public BarrierAbility() {
        super("Barrier", AbilityHelper.getDevilFruitCategory());
        this.setThreshold(30.0);
        this.setDescription("The user creates an impenetrable wall in front of themselves, which shields them from attacks");
        this.onStartContinuityEvent = this::onStartContinuityEvent;
        this.onEndContinuityEvent = this::onEndContinuityEvent;
    }

    private boolean onStartContinuityEvent(PlayerEntity player) {
        Direction dir = Direction.func_196054_a((Entity)player)[0];
        if (this.posList.isEmpty()) {
            if (dir == Direction.NORTH) {
                this.posList.addAll(AbilityHelper.createFilledCube(player.field_70170_p, player.func_226277_ct_(), player.func_226278_cu_(), player.func_226281_cx_() - 4.0, 3, 4, 1, ModBlocks.BARRIER, GRIEF_RULE));
            }
            if (dir == Direction.SOUTH) {
                this.posList.addAll(AbilityHelper.createFilledCube(player.field_70170_p, player.func_226277_ct_(), player.func_226278_cu_(), player.func_226281_cx_() + 4.0, 3, 4, 1, ModBlocks.BARRIER, GRIEF_RULE));
            }
            if (dir == Direction.EAST) {
                this.posList.addAll(AbilityHelper.createFilledCube(player.field_70170_p, player.func_226277_ct_() + 4.0, player.func_226278_cu_(), player.func_226281_cx_(), 1, 4, 3, ModBlocks.BARRIER, GRIEF_RULE));
            }
            if (dir == Direction.WEST) {
                this.posList.addAll(AbilityHelper.createFilledCube(player.field_70170_p, player.func_226277_ct_() - 4.0, player.func_226278_cu_(), player.func_226281_cx_(), 1, 4, 3, ModBlocks.BARRIER, GRIEF_RULE));
            }
        }
        return true;
    }

    private boolean onEndContinuityEvent(PlayerEntity player) {
        for (BlockPos pos : this.posList) {
            Block currentBlock = player.field_70170_p.func_180495_p(pos).func_177230_c();
            if (currentBlock != ModBlocks.BARRIER) continue;
            player.field_70170_p.func_175656_a(pos, Blocks.field_150350_a.func_176223_P());
        }
        this.posList = new ArrayList<BlockPos>();
        int cooldown = 1 + (int)Math.round((double)this.continueTime / 50.0);
        this.setMaxCooldown(cooldown);
        return true;
    }
}

