/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.abilities.bari;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Blocks;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.World;
import xyz.pixelatedw.mineminenomi.api.helpers.AbilityHelper;
import xyz.pixelatedw.mineminenomi.api.protection.BlockProtectionRule;
import xyz.pixelatedw.mineminenomi.api.protection.block.AirBlockProtectionRule;
import xyz.pixelatedw.mineminenomi.init.ModBlocks;
import xyz.pixelatedw.mineminenomi.wypi.WyHelper;
import xyz.pixelatedw.mineminenomi.wypi.abilities.ContinuousAbility;

public class BarrierBallAbility
extends ContinuousAbility {
    public static final BarrierBallAbility INSTANCE = new BarrierBallAbility();
    private static final BlockProtectionRule GRIEF_RULE = new BlockProtectionRule(AirBlockProtectionRule.INSTANCE);
    private List<BlockPos> posList = new ArrayList<BlockPos>();

    public BarrierBallAbility() {
        super("Barrier Ball", AbilityHelper.getDevilFruitCategory());
        this.setMaxCooldown(10.0);
        this.setThreshold(15.0);
        this.setDescription("The user creates a spherical barrier where they're pointing\n\n\u00a72SHIFT-USE\u00a7r: Creates the barrier around the user");
        this.onStartContinuityEvent = this::onStartContinuityEvent;
        this.onEndContinuityEvent = this::onEndContinuityEvent;
    }

    private boolean onStartContinuityEvent(PlayerEntity player) {
        if (this.posList.isEmpty()) {
            RayTraceResult mop = WyHelper.rayTraceBlocksAndEntities((Entity)player, 64.0);
            World world = player.field_70170_p;
            if (player.func_225608_bj_()) {
                this.posList.addAll(AbilityHelper.createEmptySphere(world, (int)player.func_226277_ct_(), (int)player.func_226278_cu_(), (int)player.func_226281_cx_(), 5, ModBlocks.BARRIER, GRIEF_RULE));
            } else if (mop != null) {
                this.posList.addAll(AbilityHelper.createEmptySphere(world, (int)mop.func_216347_e().field_72450_a, (int)mop.func_216347_e().field_72448_b, (int)mop.func_216347_e().field_72449_c, 5, ModBlocks.BARRIER, GRIEF_RULE));
            }
        }
        return true;
    }

    private boolean onEndContinuityEvent(PlayerEntity player) {
        for (BlockPos pos : this.posList) {
            if (player.field_70170_p.func_180495_p(pos).func_177230_c() != ModBlocks.BARRIER) continue;
            player.field_70170_p.func_175656_a(pos, Blocks.field_150350_a.func_176223_P());
        }
        this.posList = new ArrayList<BlockPos>();
        return true;
    }
}

