/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.abilities.beta;

import java.awt.Color;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.network.IPacket;
import net.minecraft.network.play.server.SPlayEntityEffectPacket;
import net.minecraft.potion.EffectInstance;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.EntityRayTraceResult;
import xyz.pixelatedw.mineminenomi.api.helpers.AbilityHelper;
import xyz.pixelatedw.mineminenomi.entities.projectiles.goro.LightningEntity;
import xyz.pixelatedw.mineminenomi.init.ModEffects;
import xyz.pixelatedw.mineminenomi.wypi.WyHelper;
import xyz.pixelatedw.mineminenomi.wypi.abilities.ChargeableAbility;

public class BetaBetaChainAbility
extends ChargeableAbility {
    public static final BetaBetaChainAbility INSTANCE = new BetaBetaChainAbility();
    private LightningEntity bolt;

    public BetaBetaChainAbility() {
        super("Beta Beta Chain", AbilityHelper.getDevilFruitCategory());
        this.setMaxCooldown(10.0);
        this.setMaxChargeTime(4.0);
        this.setDescription("The user shoots a mucus chain which will propel the user towards where it hit, or grab an entity towards the user");
        this.duringChargingEvent = this::duringChargingEvent;
        this.onEndChargingEvent = this::endChargeEvent;
    }

    private void duringChargingEvent(PlayerEntity player, int timer) {
        Entity entity;
        EntityRayTraceResult trace = WyHelper.rayTraceEntities((Entity)player, 0.5);
        if (this.bolt == null) {
            LightningEntity bolt = new LightningEntity((Entity)player, trace.func_216347_e().field_72450_a, trace.func_216347_e().field_72448_b - (double)(player.func_70047_e() / 3.0f), trace.func_216347_e().field_72449_c, player.field_70177_z, player.field_70125_A, 90.0f, 3.0f);
            bolt.setColor(new Color(55, 135, 0, 188));
            bolt.disableEnergyEffect();
            bolt.setAliveTicks(this.getMaxChargeTime() * 2);
            bolt.setDamage(0.0f);
            bolt.setSize(0.1f);
            bolt.setBranches(1);
            bolt.setSegments(1);
            bolt.disableLightningMimic();
            this.bolt = bolt;
            player.field_70170_p.func_217376_c((Entity)bolt);
        }
        if (!this.bolt.firstContactBlocks.isEmpty()) {
            BlockPos pos = this.bolt.firstContactBlocks.get(0);
            this.bolt.func_70106_y();
            this.bolt = null;
            player.func_223102_j((double)pos.func_177958_n(), (double)(pos.func_177956_o() + 2), (double)pos.func_177952_p());
            this.stopCharging(player);
            return;
        }
        if (!this.bolt.targets.isEmpty() && (entity = player.field_70170_p.func_73045_a(this.bolt.targets.get(0).intValue())) instanceof LivingEntity) {
            this.bolt.func_70106_y();
            this.bolt = null;
            EffectInstance eff = new EffectInstance(ModEffects.STICKY, 300, 1, false, false);
            ((LivingEntity)entity).func_195064_c(eff);
            ((ServerPlayerEntity)player).field_71135_a.func_147359_a((IPacket)new SPlayEntityEffectPacket(player.func_145782_y(), eff));
            entity.func_223102_j(trace.func_216347_e().field_72450_a, trace.func_216347_e().field_72448_b - (double)(player.func_70047_e() / 3.0f), trace.func_216347_e().field_72449_c);
            this.stopCharging(player);
            return;
        }
        player.func_195064_c(new EffectInstance(ModEffects.MOVEMENT_BLOCKED, 5, 1, false, false));
    }

    private boolean endChargeEvent(PlayerEntity player) {
        if (this.bolt != null) {
            this.bolt.func_70106_y();
            this.bolt = null;
        }
        return true;
    }
}

